@extends('layouts.site')

@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('auth.profile') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    @if(Session::has('message'))
        <p class="alert alert-success alert-dismissible fade show mt-2" role="alert">{{ Session::get('message') }}
            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </p>
    @endif
    @if(Session::has('error'))
        <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ Session::get('error') }}
            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </p>
    @endif

    <!-- profile data -->
    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            @if(!empty($userData->visitor->image))
                             <img src="{{asset('avatars/visitors/'.$userData->visitor->image)}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                            @else
                                <img src="{{asset('avatars/visitors/pp.svg')}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                            @endif
                        </div>
                    </div>

                     <div class="mt-5 row clearfix text-center ml-2">
                    <div class="col-5 mb-4">
                        <a href="{{route('getPlan')}}">
                            <i class="fas fa-play"></i><br />
                            {{ trans('auth.medical_plans') }}
                        </a>
                    </div>
                    


                </div>

                </div>

                <div class="col-md-9 boxing bg-white">
                        @if (session()->has('success'))
                            <div class="alert alert-dismissable alert-success">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>
                                    {!! session()->get('success') !!}
                                </strong>
                            </div>
                        @endif



                                    <form method="POST" id="profileForm" action="{{ route('visitor-update' , $userData) }}" data-parsley-validate="" class="col align-self-center" enctype='multipart/form-data' style="margin-bottom: 24px;">
                                        @csrf
                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.name')}} </strong></label>
                                                <input id="name" type="text" disabled class="forminput form-control @error('name') is-invalid @enderror" name="name" value="{{$userData->name}}" autocomplete="name" placeholder="الاسم"
                                                       data-parsley-maxlength="30"
                                                       data-parsley-required="true"
                                                       data-parsley-required-message="هذا الحقل الزامى"
                                                       tabindex=1>
                                                <label for="error-name"></label>
                                                @error('name')
                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.email')}} <span style="color: red;">*</span></strong></label>
                                                <input id="email" type="email" class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{$userData->email}}" autocomplete="email" placeholder="{{trans('auth.email')}}"
                                                       data-parsley-maxlength="30"
                                                       data-parsley-required="true"
                                                       data-parsley-required-message="هذا الحقل الزامى"
                                                       tabindex=2>
                                                <label for="error-email"></label>
                                                @error('email')
                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <!-- <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.phone-number')}} </strong></label>
                                                <input id="mobile" type="tel" class="forminput form-control @error('mobile') is-invalid @enderror" name="mobile" value="{{ !empty($userData->visitor->mobile) ? $userData->visitor->mobile : '' }}" autocomplete="email" placeholder="رقم الهاتف"
                                                       tabindex=3>
                                                <label for="error-mobile"></label>
                                                @error('mobile')
                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror
                                            </div> -->
                                            <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.phone')}} </strong></label>
                                                <input id="mobile" type="tel" class="forminput form-control" name="mobile" value="{{ !empty($userData->visitor->mobile) ? $userData->visitor->mobile : '' }}" autocomplete="email" placeholder="{{trans('auth.phone')}}"
                                                       tabindex=3>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.birthyear')}} <span style="color: red;">*</span></strong></label>
                                                <input id="birthyear" type="number" class="forminput form-control @error('birthyear') is-invalid @enderror" name="birthyear" value="{{ !empty($userData->visitor->birthyear) ?  $userData->visitor->birthyear : ''}}" autocomplete="birthyear" placeholder="{{trans('auth.birthyear')}}"
                                                       tabindex=4>
                                                <label for="error-birthyear"></label>
                                                @error('birthyear')
                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.password')}} </strong></label>
                                                <input id="visitor-password" type="password" class="forminput form-control @error('password') is-invalid @enderror" name="password" value=""  placeholder=" {{trans('auth.password')}}" tabindex=5>
                                                <label for="error-visitor-password"></label>
                                                @error('password')
                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.password-confirm')}} </strong></label>
                                                <input id="confirm-password" type="password" class="forminput form-control @error('confirm-password') is-invalid @enderror" name="confirm-password" value=""  placeholder="{{trans('auth.password-confirm')}}" tabindex=6>
                                                <label for="error-confirm-password"></label>
                                                @error('confirm-password')
                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror
                                            </div>
                                        </div>


                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <label for="validationDefault01" class="mt-3"><strong> {{trans('auth.profile-picture')}} </strong></label>
                                                <div class="custom-file">
                                                    <input type="file" name="picture" class="custom-file-input" id="customPicture" tabindex=7>

                                                    @error('picture')
                                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </p>
                                                    @enderror
                                                    <label class="custom-file-label text-center"  for="customFile">  </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-md-12 text-center">
                                                <button type="submit" class="lgx-btn mt-5 w-25">
                                                    {{ trans('auth.update') }}
                                                </button>
                                            </div>
                                        </div>

                                    </form>

                                </div>
                            </div>
                        </div>
            </div>
        </div>
    </div>

@endsection

@section('scriptSection')


    <script>
          jQuery.validator.addMethod("noSpace", function(value, element) { 
              return value.indexOf(" ") < 0; 
            }, "@lang('home.prevent_space')");
        $("#profileForm").validate({
            errorPlacement: function(error, element) {
                // Append error within linked label
                console.log('error')
                console.log(error)
                console.log(element)
                console.log(element.attr( "id" ))
                $( element )
                    .closest( "form" )
                    .find( "label[for='error-" + element.attr( "id" ) + "']" )
                    .append( error );
            },
            errorElement: "span",
            rules : {
                name : {
                    required:true,
                    minlength : 2,
                },
                email : {
                    email:true,
                    required:true,
                    minlength : 4,
                },
                // mobile : {
                //     digits: true,
                //     required:true,
                //     minlength : 11,
                // },
                birthyear : {
                    required:true,
                    minlength : 4,
                },
                password : {
                    minlength : 8,
                    noSpace:true, 
                },
                'confirm-password' : {
                    equalTo : "#visitor-password",
                    noSpace:true,
                },
            },
            messages: {
                name : {
                    required:"@lang('home.required_field')",
                    minlength : "@lang('home.minlength_2_field')",
                },
                email : {
                    email:"@lang('home.email_valid_field')",
                    required:"@lang('home.required_field')",
                    minlength : "@lang('home.minlength_4_field')",
                },
                // mobile:{
                //     digits:"@lang('home.matches_mobile')",
                //     required:"@lang('home.required_field')",
                //     minlength : "@lang('home.minlength_11_field')",
                // },
                birthyear:{
                    required:"@lang('home.required_field')",
                    minlength : "@lang('home.minlength_4_field')",
                },
                password:{
                    minlength : "@lang('home.minlength_8_field')",
                },
                'confirm-password':{
                    equalTo : "@lang('home.same-password')",
                },
            },
        });
        // Add the following code if you want the name of the file appear on select
        $(".custom-file-input").on("change", function() {
            var fileName = $(this).val().split("\\").pop();
            $(this).siblings(".custom-file-label").addClass("selected").html(fileName);
        });

        setTimeout(function(){
            
            $('.alert-danger').hide(100);
        },2000);

    </script>

@endsection

