@extends('layouts.site')

@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area">
                                    <ul class="breadcrumb mt-2">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">تقييم الجلسة</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    @if(Session::has('message'))
        <p class="alert alert-success alert-dismissible fade show mt-2" role="alert">{{ Session::get('message') }}
            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </p>
    @endif


    <!-- profile data -->
    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            @if(!empty($userData->visitor->image))
                                <img src="{{asset('avatars/visitors/'.$userData->visitor->image)}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                            @else
                                <img src="{{asset('avatars/visitors/pp.svg')}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                                <h4 class="mt-3 colorsite">{{ $userData->name }}</h4>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white">
                        <div class="lgx-tab p-3">
                            <div class="align-items-center">

                                <form method="POST"  id="rateSessionForm"  action="{{route('Insert-rate',$id)}}" class="col align-self-center" data-parsley-validate="">
                                @csrf
                                    <div class="form-row">
                                        <input type="hidden"  name="question[]" value="{{ trans('home.rate-session-question1') }} ">
                                        <div class="col-md-12 mt-3 text-right">
                                            <h4 for="validationDefault01" class="text-right mx-3"><strong> {{ trans('home.rate-session-question1')  }} </h4>

                                            <div class="form-group mt-4 px-3">
                                                <input type="hidden"  name="answer1" value="{{ trans('home.rate-session-question5') }} ">
                                                <!-- stars -->
                                                <div class="container">
                                                    <div class="starrating risingstar d-flex justify-content-end flex-row-reverse mt-5">
                                                        <input type="radio" id="star55" name="answer1" value="5"/><label for="star55" title="5 star"></label>
                                                        <input type="radio" id="star44" name="answer1" value="4" /><label for="star44" title="4 star"></label>
                                                        <input type="radio" id="star33" name="answer1" value="3" /><label for="star33" title="3 star"></label>
                                                        <input type="radio" id="star22" name="answer1" value="2" /><label for="star22" title="2 star"></label>
                                                        <input type="radio" id="star11" name="answer1" value="1" /><label for="star11" title="1 star"></label>
                                                    </div>
                                                </div>
                                                <label for="error-answer"></label>
                                                @error('answer[1]')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>



                                        </div>
                                    </div>

                                    <div class="form-row">

                                        <div class="col-md-12 mt-3 text-right">
                                            <h4 for="validationDefault01" class="text-right mx-3"><strong> {{ trans('home.rate-session-question2')  }} </h4>
                                            <div class="form-group mt-4 px-3">
                                                <input type="hidden"  name="answer2" value="{{ trans('home.rate-session-question2') }} ">
                                                <!-- stars -->
                                                <div class="container">
                                                    <div class="starrating risingstar d-flex justify-content-end flex-row-reverse mt-5">
                                                        <input type="radio" id="star555" name="answer2" value="5"/><label for="star555" title="5 star"></label>
                                                        <input type="radio" id="star444" name="answer2" value="4" /><label for="star444" title="4 star"></label>
                                                        <input type="radio" id="star333" name="answer2" value="3" /><label for="star333" title="3 star"></label>
                                                        <input type="radio" id="star222" name="answer2" value="2" /><label for="star222" title="2 star"></label>
                                                        <input type="radio" id="star111" name="answer2" value="1" /><label for="star111" title="1 star"></label>
                                                    </div>
                                                </div>
                                                <label for="error-answer"></label>
                                                @error('answer[2]')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>

                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mt-3 text-right">
                                            <h4 for="validationDefault01" class="text-right mx-3"><strong> {{ trans('home.rate-session-question3')  }} </h4>
                                            <div class="form-group mt-4 px-3">
                                                <input type="hidden"  name="answer3" value="{{ trans('home.rate-session-question3') }} ">
                                                <!-- stars -->
                                                <div class="container">
                                                    <div class="starrating risingstar d-flex justify-content-end flex-row-reverse mt-5">
                                                        <input type="radio" id="star5555" name="answer3" value="5"/><label for="star5555" title="5 star"></label>
                                                        <input type="radio" id="star4444" name="answer3" value="4" /><label for="star4444" title="4 star"></label>
                                                        <input type="radio" id="star3333" name="answer3" value="3" /><label for="star3333" title="3 star"></label>
                                                        <input type="radio" id="star2222" name="answer3" value="2" /><label for="star2222" title="2 star"></label>
                                                        <input type="radio" id="star1111" name="answer3" value="1" /><label for="star1111" title="1 star"></label>
                                                    </div>
                                                </div>
                                                <label for="error-answer"></label>
                                                @error('answer[3]')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mt-3 text-right">
                                            <h4 for="validationDefault01" class="text-right mx-3"><strong> {{ trans('home.rate-session-question4')  }} </h4>
                                            <div class="form-group mt-4 px-3">
                                                <input type="hidden"  name="answer4" value="{{ trans('home.rate-session-question4') }} ">
                                                <!-- stars -->
                                                <div class="container">
                                                    <div class="starrating risingstar d-flex justify-content-end flex-row-reverse mt-5">
                                                        <input type="radio" id="star55555" name="answer4" value="5"/><label for="star55555" title="5 star"></label>
                                                        <input type="radio" id="star44444" name="answer4" value="4" /><label for="star44444" title="4 star"></label>
                                                        <input type="radio" id="star33333" name="answer4" value="3" /><label for="star33333" title="3 star"></label>
                                                        <input type="radio" id="star22222" name="answer4" value="2" /><label for="star22222" title="2 star"></label>
                                                        <input type="radio" id="star11111" name="answer4" value="1" /><label for="star11111" title="1 star"></label>
                                                    </div>
                                                </div>
                                                <label for="error-answer"></label>
                                                @error('answer[4]')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mt-4 px-3">
                                            <h4 for="validationDefault01" class="text-right mx-3"><strong> {{ trans('home.rate-session-question6')  }} </h4>
                                            <input type="hidden"  name="comment" value="{{ trans('home.rate-session-question6') }}">
                                            {{ Form::textarea('comment',old('comment'), ['placeholder' => '','id'=>'comment'  ,'class' => 'form-control forminput '.($errors->has('comment')?'is-invalid':'') , 'cols' => 20, 'rows' =>5]) }}
                                            <label for="error-comment"></label>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mt-3 text-right">
                                            <h4 for="validationDefault01" class="text-right mx-3"><strong> {{ trans('home.rate-session-question5')  }} </h4>
                                            <div class="form-group mt-4 px-3">
                                                <input type="hidden"  name="rating" value="{{ trans('home.rate-session-question5') }} ">
                                                <!-- stars -->
                                                <div class="container">
                                                    <div class="starrating risingstar d-flex justify-content-end flex-row-reverse mt-5">
                                                        <input type="radio" id="star5" name="rating" value="5"/><label for="star5" title="5 star"></label>
                                                        <input type="radio" id="star4" name="rating" value="4" /><label for="star4" title="4 star"></label>
                                                        <input type="radio" id="star3" name="rating" value="3" /><label for="star3" title="3 star"></label>
                                                        <input type="radio" id="star2" name="rating" value="2" /><label for="star2" title="2 star"></label>
                                                        <input type="radio" id="star1" name="rating" value="1" /><label for="star1" title="1 star"></label>
                                                    </div>
                                                </div>
                                            </div>

                                            @error('answer')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-md-12 text-center">
                                            <button type="submit" class="lgx-btn mt-5" style="width:30%">
                                                {{ trans('auth.add-evaluation') }}
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                </div>

            </div>
        </div>
    </div>
@endsection

@section('scriptSection')
    <script>
        jQuery.validator.addMethod("noSpace", function(value, element) {
            return value.indexOf(" ") < 0 && value != "";
        }, "No space please and don't leave it empty");

        jQuery.validator.addMethod("NoSpecialCharacter", function(value, element) {
            return this.optional(element) || /^[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]+[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]*$/.test(value);
        }, "No Special Characters");

        $(document).ready(function(){
            $("#rateSessionForm").validate({
                errorPlacement: function(error, element) {
                    // Append error within linked label
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                rules : {
                    "answer[]":{
                        required:true,
                        minlength : 2,
                        NoSpecialCharacter: true,
                    },
                    messages: {
                        "answer[]":{
                            required:"@lang('home.required_field')",
                            minlength : "@lang('home.minlength_2_field')",
                            NoSpecialCharacter: "@lang('home.no_numbers_and_SpecialCharacter')",
                        }
                    },
                }

            });
        });
    </script>
@endsection
