@extends('layouts.site')

@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-4">
                                    <ul class="breadcrumb">
                                        @if(config('app.locale') == "en")
                                        <li class="active"> {{ trans('home.website-evaluation') }} </li>
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @else
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            <li class="active"> {{ trans('home.website-evaluation') }} </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    @if(Session::has('message'))
        <p class="alert alert-success alert-dismissible fade show mt-2" role="alert">{{ Session::get('message') }}
            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </p>
    @endif


    <!-- profile data -->
    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2 mx-4">
                        <div class="col-md-12 float-right pt-5 text-center">
                            @if(!empty($userData->visitor->image))
                                <img src="{{asset('avatars/visitors/'.$userData->visitor->image)}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                            @else
                                <img src="{{asset('avatars/visitors/pp.svg')}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                                <h4 class="mt-3 colorsite">{{ $userData->name }}</h4>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white">
                    <div class="lgx-tab p-3">
                        <div class="align-items-center">
                            <form method="POST" action="{{route('insert-rate-website')}}" class="col align-self-center">
                                @csrf
                                <div class="form-group">
                                    <label for="validationDefault01" class="mt-3"> {{trans('home.website-rate-question')}} </label>
                                    <textarea id="comment" type="text" class="forminput form-control mt-3" value="{{old('comment')}}"  name="comment"  placeholder="{{trans('auth.add-here')}}"
                                              data-parsley-required="true"
                                              data-parsley-required-message="{{trans('input-required')}}"
                                    ></textarea>
                                    @error('comment')
                                          <span style="color:red">   {{ $message }} </span>
                                         @enderror
                                </div>


                                <div class="row justify-content-center">
                                    <div class="starrating risingstar d-flex justify-content-center flex-row-reverse mt-5">
                                        <input type="radio" id="star5" name="rating" value="5" /><label for="star5" title="5 star"></label>
                                        <input type="radio" id="star4" name="rating" value="4" /><label for="star4" title="4 star"></label>
                                        <input type="radio" id="star3" name="rating" value="3" /><label for="star3" title="3 star"></label>
                                        <input type="radio" id="star2" name="rating" value="2" /><label for="star2" title="2 star"></label>
                                        <input type="radio" id="star1" name="rating" value="1" /><label for="star1" title="1 star"></label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12 text-center">
                                        <button type="submit" class="lgx-btn mt-5" style="width:30%">
                                            {{ trans('auth.add-evaluation') }}
                                        </button>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>



@endsection
