@extends('layouts.site')

@section('content')

<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-4">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{trans('auth.signup')}}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>

<div class="lgx-schedule">
    <div class="container-fluid loginstyle">
        <div class="row justify-content-center lgx-inner dynamic-form">

                <div class="col-md-7">
                    <div id="lgx-testimonials"  class="lgx-testimonials">
                        <div class="lgx-inner">
                            <div class="container">
                                <div class="lgx-content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="lgx-testiowlarea">
                                                <div id="lgx-owltestimonial" class="owl-carousel lgx-owltestimonial">
                                                    @foreach ($services as $item)
                                                    <div class="item lgx-fadeInLeft">
                                                        <figure class="lgx-client-image">
                                                            <figcaption class="lgx-zoomIn-q">
                                                                <i class="fa fa-quote-left"></i>
                                                            </figcaption>
                                                        </figure>
                                                        <div class="testi-info-area">
                                                            <p class="lgx-review">
                                                                {{ config('app.locale') == "ar" ?  $item->title_ar : $item->title_en}}
                                                            </p>
                                                        </div>
                                                    </div> <!--//.Item-->
                                                    @endforeach
                                                </div><!--l//#LGX-OWL TESTIMONIAL-->
                                            </div>
                                        </div> <!--//.COL 12 -->
                                    </div> <!--//.ROW-->
                                </div> <!--//.LGX CONTENT-->
                            </div> <!--//.CONTAINER-->
                        </div><!--//.LGX INNER-->
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="lgx-tab">
                        <div class="align-items-center  boxing">

                            @if(Session::has('message'))
                                <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ Session::get('message') }}
                                    <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </p>
                            @endif

                            <form method="POST" id="registerForm" action="{{ route('register') }}" class="col align-self-center pt-4 pb-4" data-parsley-validate="">
                                @csrf

                                <div class="form-group">
                                    <input id="name" type="text" class="forminput form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" autocomplete="name" autofocus placeholder="{{trans('auth.name')}}"
                                           data-parsley-required="true"
                                           data-parsley-required-message=" هذا الحقل الزامى"
                                     >
                                    <label for="error-name"></label>
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <input id="email" type="email" class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="{{trans('auth.email')}}"
                                           data-parsley-required="true"
                                           data-parsley-required-message=" هذا الحقل الزامى"
                                    >
                                    <label for="error-email"></label>
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>


                                <div class="form-group">
                                    <input id="mobile" type="text" class="forminput form-control" name="mobile" onkeypress="onlyNumber(event)"  autocomplete="mobile" placeholder="{{trans('home.Mobile')}}"
                                           data-parsley-required="true"
                                    >                                    
                                </div>



                                <div class="form-group">
                                    <input id="password" type="password" class="forminput form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="{{trans('auth.password')}}"
                                           data-parsley-required="true"
                                           data-parsley-required-message=" هذا الحقل الزامى"
                                    >
                                    <label for="error-password"></label>
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <input id="password-confirm" type="password" class="forminput form-control" name="password_confirmation" required autocomplete="new-password" placeholder="{{trans('auth.password-confirm')}}"
                                           data-parsley-required="true"
                                           data-parsley-required-message=" هذا الحقل الزامى"
                                    >
                                    <label for="error-password-confirm"></label>
                                    @error('password_confirmation')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror


                                </div>

                                <div class="form-group">
                                    <div class="form-check d-flex justify-content-start p-4"  @if(config('app.locale') == "en") dir="ltr" @else  dir="rtl"  @endif>
                                        <input type="checkbox" class="form-check-input mx-2" id="agreement" value="1" name="agreement" >
                                        <label class="mx-5" for="exampleCheck1">
                                            {{trans('home.agreement')}}
                                            <a href="{{  config('app.locale') == "ar" ?  url(trans('home.Terms_Conditions_url')) : url('en/'.trans('home.Terms_Conditions_url'))  }}">{{trans('auth.here')}}</a>
                                        </label>
                                    </div>
                                    <label for="error-agreement"></label>
                                    @if($errors->has('agreement'))
                                        <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">
                                            {{ $errors->first('agreement') }}
                                            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>

                                    @endif

                                </div>

                                <div class="form-group">
                                    <div class="col-md-12">
                                        <button type="submit" class="lgx-btn" style="width: 100%">
                                            {{ trans('auth.signup') }}
                                        </button>
                                    </div>
                                </div>
                                <div>
                                    <a href="{{route('login')}}">{{ trans('auth.login') }}</a>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>

        </div>
    </div>
</div>
@endsection
@section('scriptSection')
    <script>
        jQuery.validator.addMethod("noSpace", function(value, element) {
            return value.indexOf(" ") < 0 && value != "";
        }, "No space please and don't leave it empty");

        jQuery.validator.addMethod("NoSpecialCharacter", function(value, element) {
            return this.optional(element) || /^[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]+[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]*$/.test(value);
        }, "No Special Characters");

        $(document).ready(function(){
            $("#registerForm").validate({
                errorPlacement: function(error, element) {
                    // Append error within linked label
                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                rules : {
                    name:{
                        required:true,
                        minlength : 2,
                        NoSpecialCharacter: true,
                    },
                    email : {
                        email:true,
                        required:true,
                        minlength : 4,
                    },
                    password:{
                        required:true,
                        minlength : 4,
                        noSpace:true
                    },
                    password_confirmation:{
                        required:true,
                        minlength : 4,
                        equalTo:"#password",
                    },
                    agreement:{
                        required:true,
                    },
                },
                messages: {
                    name:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_2_field')",
                        NoSpecialCharacter: "@lang('home.no_numbers_and_SpecialCharacter')",
                    },
                    email : {
                        email:"@lang('home.email_valid_field')",
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                    password:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                        noSpace:"@lang('home.prevent_space')",

                    },
                    password_confirmation:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                        equalTo:"@lang('home.equalTo_field')",

                    },
                    agreement:{
                        required:"@lang('home.agreement_field')",
                    },
                },
            });
        });


         function onlyNumber($event) {
               //console.log($event.keyCode); //keyCodes value
               let keyCode = ($event.keyCode ? $event.keyCode : $event.which);
               if ((keyCode < 48 || keyCode > 57)) { // 46 is dot
                  $event.preventDefault();
               }
            }

    </script>
@endsection
