@extends('layouts.site')
@section('meta_tags')
    <title>{{ config('app.name', 'New Life') }} | {{ trans('home.blog') }}</title>
    <style>
        .hidden{
            display:none!important;
        }
    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-5">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{ trans('home.home') }}</a></li>
                                        <li class="active">{{ trans('home.blog') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <section id="blog-section">
        <div class="lgx-blog lgx-blog-list">
            <div class="lgx-inner">
                <div class="container">
                    <h3>@lang('home.last_news')</h3>
                    <div class="row dir-rtl">
                        {{--@include('include.blog_items',['class'=>'col-sm-12 col-md-4','items'=>$blog])--}}
                        @include('include.blog_blocks',['items'=>$blog])

                    </div>
                   
                   @if(!\Request::segment(2) == 'last')
                    <div class="btn-area text-center">
                        <div id="loader" class="hidden">
                            <img src="{{ asset('img/loading.gif') }}" width="100" alt="">
                        </div>
                        <a class="lgx-btn lgx-btn-big" href="{{ route('blog_more') }}">{{trans('home.more')}}</a>
                    </div>
                    @endif

                </div><!-- //.CONTAINER -->

            </div><!-- //.INNER -->

        </div>
        @if(isset($blogFeatured))
        <div class="lgx-blog lgx-blog-list">
            <div class="lgx-inner">
                <div class="container">
                    <h3>@lang('home.featured_news')</h3>
                    <div class="row dir-rtl">
                        {{--@include('include.blog_items',['class'=>'col-sm-12 col-md-6','items'=>$blogFeatured])--}}
                        @include('include.blog_blocks',['items'=>$blogFeatured])

                    </div>
                </div><!-- //.CONTAINER -->

            </div><!-- //.INNER -->

        </div>
        @endif
        @if(isset($blogViews))
        <div class="lgx-blog lgx-blog-list">
            <div class="lgx-inner">
                <div class="container">
                    <h3>@lang('home.most_views')</h3>
                    <div class="row dir-rtl">
                        {{--@include('include.blog_items',['class'=>'col-sm-12 col-md-4','items'=>$blogViews])--}}
                        @include('include.blog_blocks',['items'=>$blogViews])
                    </div>
                </div><!-- //.CONTAINER -->

            </div><!-- //.INNER -->

        </div>
        @endif
    </section>
@endsection
@section('scriptSection')
    <script>
        $(document).ready(function(){
            $(document).on('click','#loadMore',function(e){
                $("#loader").removeClass('hidden');
                $("#loadMore").addClass('hidden')
                e.preventDefault();
                skip=$(".blog-area .lgx-card-single").length;
                $.ajax({
                    type: "GET",
                    url: "{{ route('get_more_blog') }}",
                    data: {"skip": skip},
                    success: function (msg) {
                        if(msg.success){
                            if(msg.html.length){
                                $(".blog-area .row").append(msg.html);
                                $("#loadMore").removeClass('hidden')
                            }else{
                                $("#loadMore").remove();
                            }

                        }
                        $("#loader").addClass('hidden');
                    }
                });
            });
        })
    </script>
@endsection
