<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'laravel') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{asset('css/fontawesome-free-5.14.0-web/css/all.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-4.5.0/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-datepicker3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/extra.css')}}" rel="stylesheet">

    <!-- Scripts -->
    <script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/jquery-ui.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/bootstrap.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.en-CA.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/extra.js')}}" type="text/javascript"></script>
</head>
<body>

 <!-- Freequently Asked Questions section -->
<div class="xs-section-padding">
        <div class="row xs-faq-group">
            <div class="col-md-12">
                <div class="xs-single-faq" style="text-align: center;padding: 200px 10px 33px 10px;/*! color: #ff2e8a; */">

                    <img class="regimage" src="{{ asset('assets/img/logo.png')}}" alt="verify">

                    <h3 style="color:#ff2e8a;"> {{ trans('home.welcome-newLife')  }} </h3>

                    @if($user->type == "therapists")
                    <!--    <p>  {{ trans('home.ToComplete')  }} </p>

                        <a class="btn btn-primary" href="{{route('sendEmailTherapist',["email" => $user->email,"verifyToken" => $user->verifyToken])}}">
                            {{ url("/verify/{$user->email}/{$user->verifyToken}") }}
                        </a>

                    -->
                        <p>مرحبا  {{ $user->name }}</p>
                        <p>شكراً لك علي التسجيل </p>
                        <p> @lang('home.p1')</p>
                        <p>@lang('home.p2')</p>
                        <p> @lang('home.p3')</p>
                      <!--   <p>يمكنك تسجيل الدخول إلى حسابك واستكمال المعلومات الخاصة بك</p>
                        <p>لمساعدتنا في تنشيط حسابك ، يمكنك تحرير ملف التعريف الخاص بك</p>
                        <p>من الرابط أدناه</p>  -->
                        <a class="btn btn-primary"  href="{{ route('therapists_profile_basic') }}">
                            {{ route('therapists_profile_basic') }}
                        </a>

                    @else
                        <p>  {{ trans('home.active-visitor') }} </p>
                        <a class="btn btn-primary" href="{{route('sendEmailVisitor',["email" => $user->email,"verifyToken" => $user->verifyToken])}}">
                            {{ url("/verify/{$user->email}/{$user->verifyToken}") }}
                        </a>
                    @endif

                </div><!-- .xs-single-faq END -->

            </div>
        </div><!-- .row END -->
</div><!-- end Freequently Asked Questions section -->


</body>
</html>
