<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'laravel') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{asset('css/fontawesome-free-5.14.0-web/css/all.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-4.5.0/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-datepicker3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/extra.css')}}" rel="stylesheet">

    <!-- Scripts -->
    <script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/jquery-ui.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/bootstrap.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.en-CA.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/extra.js')}}" type="text/javascript"></script>
</head>
<body>

<!-- Freequently Asked Questions section -->
<div class="xs-section-padding container">
    <div class="row xs-faq-group">
        <div class="col-md-12">
            <div class="xs-single-faq">
                <div style="text-align: center">
                    <img class="regimage" src="{{ asset('assets/img/logo.png')}}" alt="verify">
                </div>

                <div style="padding: 50px;">
                    <p style="text-align: center">مرحباً   {{ ($user->name)?$user->name:$user->email }},</p>

                    <p style="text-align: center"> يوجد لديك رساله جديده  في صندوق الوارد </p>

                    <p style="text-align: center"> السؤال </p>
                    <p style="text-align: center">{{ $message->message }}</p>
                    <p style="text-align: center">  الإجابه </p>
                    <p style="text-align: center">{{ $message->answer }}</p>

                    <p> الرابط </p>
                    @if($goType == 'therapist')
                    <a href="{{ route('get-messages', $session->id) }}"> {{ route('get-messages', $session->id) }} </a>
                    @else
                    <a href="{{ route('get-client-send-message', $session->id) }}"> {{ route('get-client-send-message', $session->id) }} </a>

                    @endif

                </div>

            </div><!-- .xs-single-faq END -->

        </div>
    </div><!-- .row END -->
</div><!-- end Freequently Asked Questions section -->


</body>
</html>
