<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'laravel') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{asset('css/fontawesome-free-5.14.0-web/css/all.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-4.5.0/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-datepicker3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/extra.css')}}" rel="stylesheet">

    <!-- Scripts -->
    <script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/jquery-ui.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/bootstrap.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.en-CA.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/extra.js')}}" type="text/javascript"></script>
</head>
<body>

<!-- Freequently Asked Questions section -->
<div class="xs-section-padding" style="{{ app()->getLocale()=='ar'?'direction:rtl;':'direction:ltr;' }}">
    <div class="row xs-faq-group">
        <div class="col-md-12">
            <div class="xs-single-faq" style="text-align: center;padding: 200px 10px 33px 10px;/*! color: #ff2e8a; */">
                <img class="regimage" src="{{ asset('assets/img/logo.png')}}" alt="verify">
                <h3 style="color:#ff2e8a; direction: rtl;"> {{ trans('home.welcome-newLife')  }} </h3>
                <p style="direction: rtl;">@lang('home.Dear') {{ $therapistUser->name }},</p>
                <!-- <p> @lang('home.Your session has payed') {{ convertDateTimezone($allsessions->start_time,$therapistUser->timezone?$therapistUser->timezone:'Africa/Cairo','Y-m-d h:i a') }} {{ $visitorUser->name }}</p> -->

                <p style="direction: rtl;">@lang('home.reserve_session_msg') {{ $visitorUser->name }} </p>
                <p style="direction: rtl;">@lang('home.for') {{ $allsessions->type }} دقائق   </p>
                <p style="direction: rtl;">@lang('home.when') {{ convertDateTimezone($allsessions->start_time,$therapistUser->timezone?$therapistUser->timezone:'Africa/Cairo','Y-m-d h:i a') }}</p>

                <p>@lang('home.Please check your sessions')</p>
            </div><!-- .xs-single-faq END -->

        </div>
    </div><!-- .row END -->
</div><!-- end Freequently Asked Questions section -->


</body>
</html>
