<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'laravel') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{asset('css/fontawesome-free-5.14.0-web/css/all.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-4.5.0/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-datepicker3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/extra.css')}}" rel="stylesheet">

    <!-- Scripts -->
    <script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/jquery-ui.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/bootstrap.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datepicker/bootstrap-datepicker.en-CA.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/extra.js')}}" type="text/javascript"></script>
</head>
<body>


<section class="my-5">
    <div class="container">
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8">
                <div class="header" style="background: #3da8c0;padding: 20px;color: #fff;text-align: center;border-radius: 7px;">
                    <img class="regimage" src="{{ asset('assets/img/1hour.png')}}" width="51%" style="border-radius: 50%;">
                    <br>
                    <p style="font-weight: bold;font-size: 15px; margin-top: 11px;margin-bottom: 0;">Only 1 Hours left for your session with {{ ($therapist)?$session->visitor->user->name:$session->therapist->user->name }}</p>
                </div>
                <p style="margin: 20px 0;text-align: center;">Please come 10-15 minutes before the session time so as to test your camera and microphone as well as prepare yourself. 
                     {{ ($therapist)?convertDateTimezone($session->start_time,($session->therapist->user->timezone?$session->therapist->user->timezone:'Africa/Cairo'),'Y-m-d h:i a'):convertDateTimezone($session->start_time,'Africa/Cairo','Y-m-d h:i a') }} 

                   <!-- {{ $session->start_time}} -->
                </p>
                <h4 style="font-weight:bold;color:#3da8c0;">How to get the best session experience ?</h4>
                <p style="margin-bottom:0">- Internet speed must not be less than 1 MB/s.</p>
                <p>- The Session room opens 15 minutes before your session start time.</p>
            </div>
            <div class="col-md-2"></div>
        </div>
    </div>
</section>


</body>
</html>
