@extends('layouts.site')

@section('content')
    <style>
        @media (max-width: 767px) {
            .btn-group{
                width: 100%!important;
            }
        }
        .btn-group.btn-group-toggle .btn.btn-secondary{
            font-size: 16px
        }
        .goNext{
            font-size: 16px;
            padding: 10px 15px;
            margin-top: 0px;
            height: 42px;
            line-height: 20px
        }
        .btn-group{
            display: inline-block;
            width: 35%;
        }
        .forminput{
            margin-top: 0px;
        }
        #recomm-form .form-row.dynamic-align{
            min-height: 350px;
        }
        .header-recommendation{
            background: #f3f6f9;
            padding: 35px;
        }
        .header-recommendation p{
            color: #4d4d4f;
            font-size: 16px;
            font-weight: bold;
        }
        .header-recommendation p span{
            color: #c35cfe;
        }
    </style>
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area m-5">
                                    <h3 class="heading" style="font-size: 2rem">
                                        <span class="heading"> {{ trans('home.questions')  }} </span>
                                    </h3>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <div class="lgx-schedule">
        <div class="container-fluid">
            <div class="row justify-content-center lgx-inner">
                <div class="col-md-8">
                    <div class="lgx-tab">
                        <div class="align-items-center pb-3 boxing">
                            <div class="col-12 header-recommendation">
                                <p>
                                    @lang('home.Please read the contents of the download and make sure that the packages apply to you in')
                                    <span>@lang('home.The past two weeks')</span>
                                </p>
                            </div>
                            <!-- insert-family-problems -->
                            <form method="POST"  id="recomm-form" action="{{route('insert-family-problems')}}" data-parsley-validate="" class="col align-self-center px-5 py-4" style="margin-bottom: 24px;">
                                @csrf

 
                                <!-- question 2 -->
                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mt-3">
                                        <h4 for="validationDefault01" ><strong> {{ trans('home.question2')  }}</strong> </h4>
                                        <div class="form-group mt-4 px-3 dynamic-align">
                                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                <input type="hidden" name="question[0]"  value="{{ trans('home.question2') }}" autocomplete="off">
                                                <label class="btn btn-secondary btn-block active">
                                                    <input type="radio" name="answer[0]"  value="{{ trans('home.male') }}" autocomplete="off"> {{ trans('home.male') }}
                                                </label>
                                                <label class="btn btn-secondary btn-block">
                                                    <input type="radio" name="answer[0]"  value="{{ trans('home.female') }}"  autocomplete="off"> {{ trans('home.female') }}
                                                </label>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- question 3 -->
                                <div class="form-row dynamic-align d-none">
                                    <div class="col-md-12 mt-3">
                                        <h4 for="validationDefault01" ><strong> {{ trans('home.question3')  }}</strong> </h4>
                                        <div class="form-group mt-4 px-3 dynamic-align">
                                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                <input type="hidden" name="question[1]"  value="{{ trans('home.question3') }}" autocomplete="off">
                                                <label class="btn btn-secondary btn-block active">
                                                    <input type="radio" class="gender" name="answer[1]" value=" {{ trans('home.male') }}"  autocomplete="off"> {{ trans('home.male') }}
                                                </label>
                                                <label class="btn btn-secondary btn-block">
                                                    <input type="radio" class="gender" name="answer[1]"  value="{{ trans('home.female') }}" autocomplete="off"> {{ trans('home.female') }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- question 6-->
                                <div class="form-row dynamic-align d-none">
                                    <div class="col-md-12 mt-3">
                                        <h4 for="validationDefault01" ><strong> {{ trans('home.question6')  }}</strong> </h4>
                                        <div class="form-group mt-4 px-3 dynamic-align">
                                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                <input type="hidden" name="question[2]"  value="{{ trans('home.question6') }}" autocomplete="off">
                                                <label class="btn btn-secondary btn-block active">
                                                    <input type="radio" name="answer[2]" class="question6-yes" id="question6-yes" value="yes" autocomplete="off"> {{ trans('home.yes') }}
                                                </label>
                                                <label class="btn btn-secondary btn-block">
                                                    <input type="radio" name="answer[2]" class="question6-no" id="question6-no" value="no"  autocomplete="off"> {{ trans('home.no') }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row dynamic-align d-none">
                                    <div class="col-md-12 mt-3">
                                        <h4 for="validationDefault01" ><strong> {{ trans('home.doYou')  }}</strong> </h4> 
                                        <div class="form-group mt-4 px-3 dynamic-align">
                                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                <input type="hidden" name="question[7]"  value="{{ trans('home.doYou')  }}" autocomplete="off">
                                                <label class="btn btn-secondary btn-block active">
                                                    <input type="radio" name="answer[7]" class="question4-yes" id="question4-psychological-problems-yes" value="yes"  autocomplete="off"> {{ trans('home.yes') }}
                                                </label>
                                                <label class="btn btn-secondary btn-block">
                                                    <input type="radio" name="answer[7]" class="question4-no" id="question4-psychological-problems-no" value="no"  autocomplete="off"> {{ trans('home.no') }}
                                                </label>
                                            </div>
                                            @error('ans7')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>
                                    <div class="form-row dynamic-align d-none">
                                        <div class="col-md-12 mt-3">
                                            <h4 class="@if(app()->getLocale()=='ar') text-right @else text-left @endif mx-3" for="validationDefault01" ><strong> {{ trans('auth.email')  }}</strong> </h4>
                                            <div class="form-group mt-4 px-3">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <button type="button" data-step="1" class="btn btn-success goNext">@lang('home.start_now')</button>
                                                    </div>
                                                    <input  id="userEmail" type="email"  class="forminput  form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{trans('auth.enter-email')}}"
                                                           data-parsley-maxlength="30"
                                                           data-parsley-required="true"
                                                           data-parsley-required-message="هذا الحقل مطلوب"
                                                    >
                                                </div>
                                                <label for="error-userEmail"></label>
                                                @error('email')
                                                <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror

                                            </div>
                                        </div>
                                    </div>

                                <!-- final question  -->
                                <div class="form-row dynamic-align d-none submitBtn" id="submitBtn">
                                    <div class="col-md-12">
                                        <input type="hidden" name="service_type" id="serviceype" value="{{ trans('home.Treatment-of-marital-and-family-problems-and-divorce') }}">
                                        <input type="hidden" name="speciality_id"  value="25">
                                        <input type="hidden" style="opacity:0" name="gender" id="gender">
                                        <button type="submit" class="lgx-btn mb-4 w-25">
                                            {{ trans('home.send') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>



@endsection
@section('scriptSection')
    <script>

        $('input.gender').change(function() {
            if(this.value == 'male' || this.value == ' ذكر')
            {
                $('#gender').val('male');
            }
            else
            {
                $('#gender').val('female');
            }
        });


        function validateEmail($email) {
            var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
            return emailReg.test( $email );
        }
        //inherit from question 6
        join_treatment="<div class=\"form-row dynamic-align d-none\">\n" +
            "                                    <div class=\"col-md-12 mt-3\">\n" +
            "                                        <h4 for=\"validationDefault01\" ><strong> {{ trans('home.join_treatment')  }}</strong> </h4>\n" +
            "                                        <div class=\"form-group mt-4 px-3 dynamic-align\">\n" +
            "                                            <div class=\"btn-group btn-group-toggle\" data-toggle=\"buttons\">\n" +
            "                                            <input type=\"hidden\" name=\"question[3]\"  value=\"{{ trans('home.join_treatment') }}\" autocomplete=\"off\">\n" +
            "                                                <label class=\"btn btn-secondary btn-block active\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[3]\" class=\"join_treatment_yes\" id=\"join_treatment_yes\" value=\"yes\"  autocomplete=\"off\"> {{ trans('home.yes') }} ({{ trans('home.Marital treatment') }})\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[3]\" class=\"join_treatment_no\" id=\"join_treatment_no\" value=\"no\"  autocomplete=\"off\"> {{ trans('home.no') }} ({{ trans('home.Individual treatment') }})\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[3]\" class=\"join_treatment_not_sure\" id=\"join_treatment_not_sure\" value=\"not_sure\"  autocomplete=\"off\"> {{ trans('home.not-sure') }} ({{ trans('home.I will decide later') }})\n" +
            "                                                </label>\n" +
            "                                            </div>\n" +
            "\n" +
            "                                        </div>\n" +
            "                                    </div>\n" +
            "                                </div>";
        divorced="<div  class=\"form-row dynamic-align d-none\">\n" +
            "                                    <div class=\"col-md-12 mt-3\">\n" +
            "                                        <h4 for=\"validationDefault01\" ><strong> {{ trans('home.Are you divorced?')  }}</strong> </h4>\n" +
            "                                        <div class=\"form-group mt-4 px-3 dynamic-align\">\n" +
            "                                            <div class=\"btn-group btn-group-toggle\" data-toggle=\"buttons\">\n" +
            "                                            <input type=\"hidden\" name=\"question[4]\"  value=\"{{ trans('home.Are you divorced?') }}\" autocomplete=\"off\">\n" +
            "                                                <label class=\"btn btn-secondary btn-block active\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[4]\" class=\"divorced_yes\" id=\"divorced_yes\" value=\"yes\"  autocomplete=\"off\"> {{ trans('home.yes') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[4]\" class=\"divorced_no\" id=\"divorced_no\" value=\"no\"  autocomplete=\"off\"> {{ trans('home.no') }}\n" +
            "                                                </label>\n" +
            "                                            </div>\n" +
            "\n" +
            "                                        </div>\n" +
            "                                    </div>\n" +
            "                                </div>";
            //inherit from Are you divorced? yes
        negative_emotions_or_develop="<div  class=\"form-row dynamic-align d-none\">\n" +
            "                                    <div class=\"col-md-12 mt-3\">\n" +
            "                                        <div class=\"form-group mt-4 px-3 dynamic-align\">\n" +
            "                                            <div class=\"btn-group btn-group-toggle\" data-toggle=\"buttons\">\n" +
            "                                            <input type=\"hidden\" name=\"question[5]\"  value=\"{{ trans('home.Do you want to cure negative emotions or develop your self?') }}\" autocomplete=\"off\">\n" +
            "                                                <label class=\"btn btn-secondary btn-block active\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[5]\" class=\"negative_emotions_or_develop_yes\" id=\"negative_emotions_or_develop_yes\" value=\"yes\"  autocomplete=\"off\"> {{ trans('home.I want to cure negative feelings and accept the reality after the divorce') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[5]\" class=\"negative_emotions_or_develop_no\" id=\"negative_emotions_or_develop_no\" value=\"no\"  autocomplete=\"off\"> {{ trans('home.I want to develop yourself and learn social skills?') }}\n" +
            "                                                </label>\n" +
            "                                            </div>\n" +
            "\n" +
            "                                        </div>\n" +
            "                                    </div>\n" +
            "                                </div>";
        //inherit from Are you divorced? no
        sexual_problem="<div  class=\"form-row dynamic-align d-none\">\n" +
            "                                    <div class=\"col-md-12 mt-3\">\n" +
            "                                        <h4 for=\"validationDefault01\" ><strong> {{ trans('home.Is your main problem a sexual problem?')  }}</strong> </h4>\n" +
            "                                        <div class=\"form-group mt-4 px-3 dynamic-align\">\n" +
            "                                            <div class=\"btn-group btn-group-toggle\" data-toggle=\"buttons\">\n" +
            "                                            <input type=\"hidden\" name=\"question[6]\"  value=\"{{ trans('home.Is your main problem a sexual problem?') }}\" autocomplete=\"off\">\n" +
            "                                                <label class=\"btn btn-secondary btn-block active\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[6]\" class=\"sexual_problem_yes\" id=\"sexual_problem_yes\" value=\"yes\" autocomplete=\"off\"> {{ trans('home.yes') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[6]\" class=\"sexual_problem_no\" id=\"sexual_problem_no\" value=\"no\"  autocomplete=\"off\"> {{ trans('home.no') }}\n" +
            "                                                </label>\n" +
            "                                            </div>\n" +
            "\n" +
            "                                        </div>\n" +
            "                                    </div>\n" +
            "                                </div>";

        What_is_the_psychological_problem="<div  class=\"form-row dynamic-align d-none\">\n" +
            "                                    <div class=\"col-md-12 mt-3\">\n" +
            "                                        <h4 for=\"validationDefault01\" ><strong> {{ trans('home.What is the psychological problem that you suffer from')  }}</strong> </h4>\n" +
            "                                        <div class=\"form-group mt-4 px-3 dynamic-align\">\n" +
            "                                            <div class=\"btn-group btn-group-toggle\" data-toggle=\"buttons\">\n" +
            "                                            <input type=\"hidden\" name=\"question[8]\"  value=\"{{ trans('home.What is the psychological problem that you suffer from') }}\" autocomplete=\"off\">\n" +
            "                                                <label class=\"btn btn-secondary btn-block active\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[8]\" class=\"question4-anxiety\" id=\"question4-anxiety\" value=\"anxiety\"  autocomplete=\"off\"> {{ trans('home.Anxiety') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[8]\" class=\"question4-Depression\" id=\"question4-depression\" value=\"depression\"  autocomplete=\"off\"> {{ trans('home.Depression') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[8]\" class=\"question4-obsessive\" id=\"question4-obsessive\" value=\"obsessive\" autocomplete=\"off\"> {{ trans('home.Obsessive') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[8]\" class=\"question4-personality-disorder\" id=\"question4-personality-disorder\" value=\"personality disorder\"  autocomplete=\"off\"> {{ trans('home.Personality disorder') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[8]\" class=\"question4-sexual-abuse\" id=\"question4-sexual-abuse\" value=\"sexual abuse\"  autocomplete=\"off\"> {{ trans('home.Sexual abuse') }}\n" +
            "                                                </label>\n" +
            "                                                <label class=\"btn btn-secondary btn-block\">\n" +
            "                                                    <input type=\"radio\" name=\"answer[8]\" class=\"question4-post-traumatic-stress\" id=\"question4-post-traumatic-stress\" value=\"post traumatic stress\"  autocomplete=\"off\"> {{ trans('home.Post-traumatic stress') }}\n" +
            "                                                </label>\n" +
            "                                            </div>\n" +
            "\n" +
            "                                        </div>\n" +
            "                                    </div>\n" +
            "                                </div>";
        function generatePagination(){
            length=$("#recomm-form .form-row.dynamic-align").length;
            html='';
            // for (x=1;x<=length;x++){
            //     html+='<li class="page-item step-'+x+' disabled"><a data-step="'+(x-1)+'" class="page-link change-step" href="#">'+x+'</a></li>';
            // }
            // $("#paginate-recommendation ul.pagination").html(html);
        }
        $(document).ready(function(){
            $(document).on('keydown','#userEmail',function(event){
                if(event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
            $(document).on('keyup','#userEmail',function(e){
                userEmail=$(this);
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    userEmail.removeClass('is-invalid')
                    $("label[for='error-userEmail']").html('');
                    if(e.keyCode==13){
                        $('.goNext').trigger('click');
                    }
                }else{
                    userEmail.addClass('is-invalid');
                    if(userEmail.val()){
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.email_valid_field')</span>');
                    }else{
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.required_field')</span>');
                    }
                }

            });
            function goToStep(step){
                if($("#recomm-form .form-row").eq(step).length){
                    $("#recomm-form .form-row").addClass('d-none')
                    $("#recomm-form .form-row").eq(step).removeClass('d-none');
                    $("#paginate-recommendation").removeClass('d-none');
                    $("#paginate-recommendation .pagination li.active").removeClass('active');
                    $("#paginate-recommendation .step-"+(parseInt(step)+1)).addClass('active');
                }
                for (i=0;i<=step;i++){
                    $("#paginate-recommendation .pagination li").eq(i).removeClass('disabled');
                }
            }
            $(document).on('click','.goNext',function(){
                userEmail=$("#userEmail")
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    step=$(this).attr('data-step');
                    console.log(step);
                    goToStep(step)
                    $('#submitBtn').removeClass('d-none');
                    $(".form-row.dynamic-align:not(.submitBtn)").addClass('d-none')
                }else{
                    userEmail.addClass('is-invalid')
                }
            });
            $(document).on('click','.change-step',function(e){
                e.preventDefault();
                step=$(this).attr('data-step');
                goToStep(step)
            })
            $(document).on('change','#recomm-form .form-row input[type="radio"]',function(){
                el=$(this);
                radioValue=el.val();
                radioName=el.attr('id');

                if(radioValue=='yes'&&radioName=='question6-yes'){
                    $("#recomm-form .form-row:not(.d-none)").after(join_treatment);
                }
                if(radioValue=='no'&&radioName=='question6-no'){
                    $("#recomm-form .form-row:not(.d-none)").after(divorced);
                }

                //question6_option_divorced_yes
                if(radioValue=='yes'&&radioName=='divorced_yes'){
                    $("#recomm-form .form-row:not(.d-none)").after(negative_emotions_or_develop);
                }
                //question6_option_divorced_no
                if(radioValue=='no'&&radioName=='divorced_no'){
                    $("#recomm-form .form-row:not(.d-none)").after(sexual_problem);
                }

                if(radioValue=='yes'&&radioName=='question4-psychological-problems-yes'){
                    $("#recomm-form .form-row:not(.d-none)").after(What_is_the_psychological_problem);
                }
                generatePagination();
                step=$("#recomm-form .form-row:not(.d-none)").index();
                goToStep(step)
            });
        });
    </script>
@endsection
