@extends('layouts.site')
@section('meta_tags')
    <title>{{ config('app.name', 'New Life') }} | {{ trans('home.job') }}</title>
    <style>
        .hidden{
            display:none!important;
        }
    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area">
                                    <h2 class="lgx-heading lgx-heading-brand">
                                        <span class="back-heading"><i class="fa fa-map-marker" aria-hidden="true"></i></span>
                                        <span class="heading">{{ trans('home.job') }}</span>
                                    </h2>
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{ trans('home.home') }}</a></li>
                                        <li class="active">{{ trans('home.job') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <section>
        <div class="lgx-blog lgx-blog-list">
            <div class="lgx-inner">
                <div class="container">
                    <h3>@lang('home.last_news')</h3>
                    <div class="blog-area">
                        <div class="row">
                            {{-- @include('include.blog_items',['class'=>'col-sm-12 col-md-4','items'=>$jop]) --}}

                        </div>
                    </div>
                    {{-- @if($paginate)
                        {{ $jop->links() }}
                    @else --}}
                    <div class="btn-area text-center">
                        <div id="loader" class="hidden">
                            <img src="{{ asset('img/loading.gif') }}" width="100" alt="">
                        </div>
                        <a class="lgx-btn lgx-btn-big" href="{{ route('blog_more') }}">{{trans('home.more')}}</a>
                    </div>
                    {{-- @endif --}}
                </div><!-- //.CONTAINER -->

            </div><!-- //.INNER -->

        </div>

    </section>
@endsection
@section('scriptSection')
    <script>
        $(document).ready(function(){
            $(document).on('click','#loadMore',function(e){
                $("#loader").removeClass('hidden');
                $("#loadMore").addClass('hidden')
                e.preventDefault();
                skip=$(".blog-area .lgx-card-single").length;
                $.ajax({
                    type: "GET",
                    url: "{{ route('get_more_blog') }}",
                    data: {"skip": skip},
                    success: function (msg) {
                        if(msg.success){
                            if(msg.html.length){
                                $(".blog-area .row").append(msg.html);
                                $("#loadMore").removeClass('hidden')
                            }else{
                                $("#loadMore").remove();
                            }

                        }
                        $("#loader").addClass('hidden');
                    }
                });
            });
        })
    </script>
@endsection
