<!doctype html>
<html class="no-js {{ ( app()->getLocale()=='ar' )?'rtl':'ltr' }}" lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ (app()->getLocale()=='ar')?'rtl':'ltr' }}">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @hasSection('meta_tags')
        @yield('meta_tags')
    @else
        <title>  {{ (app()->getLocale()=='ar')? trans('home.siteArabic'): trans('home.siteEnglish') }} </title>
        <meta name="description" content="@lang('home.meta_description')" />
        <!-- Schema.org markup for Google+ -->
        <meta itemprop="name" content="{{ (app()->getLocale()=='ar')? trans('home.siteArabic'): trans('home.siteEnglish') }}">
        <meta itemprop="description" content="@lang('home.meta_description')">
        <meta itemprop="image" content="">
        <!-- Twitter Card data -->
        <meta name="twitter:card" content="{{ (app()->getLocale()=='ar')? trans('home.siteArabic'): trans('home.siteEnglish') }}">
        <meta name="twitter:site" content="{{ '@'.(app()->getLocale()=='ar')? trans('home.siteArabic'): trans('home.siteEnglish') }}">
        <meta name="twitter:title" content="{{ (app()->getLocale()=='ar')? trans('home.siteArabic'): trans('home.siteEnglish') }}">
        <meta name="twitter:description" content="@lang('home.meta_description')">
        <meta name="twitter:image" content="{{asset('assets/img/logo200-200.png?v=1.0.0.0')}}">
        <!-- Open Graph data -->
        <meta property="og:title" content="{{ (app()->getLocale()=='ar')? trans('home.siteArabic'): trans('home.siteEnglish') }}" />
        <meta property="og:type" content="article" />
        <meta property="og:url" content="{{ url()->current() }}" />
        <meta property="og:image" content="{{asset('assets/img/logo200-200.png?v=1.0.0.0')}}" />
        <meta property="og:description" content="@lang('home.meta_description')" />
    @endif
<!--  FAVICON AND TOUCH ICONS -->
    <link rel="shortcut icon" type="image/x-icon" href="{{asset('assets/img/logo200-200.png?v=1.0.0.0')}}"/>
    <!-- this icon shows in browser toolbar -->
    <link rel="icon" type="image/x-icon" href="{{asset('assets/img/logo200-200.png?v=1.0.0.0')}}"/>
    <!-- this icon shows in browser toolbar -->
    <link rel="apple-touch-icon" sizes="57x57" href="{{ asset('assets/img/favicon/apple-icon-57x57.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="60x60" href="{{ asset('assets/img/favicon/apple-icon-60x60.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="72x72" href="{{ asset('assets/img/favicon/apple-icon-72x72.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('assets/img/favicon/apple-icon-76x76.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="114x114" href="{{ asset('assets/img/favicon/apple-icon-114x114.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="120x120" href="{{ asset('assets/img/favicon/apple-icon-120x120.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="144x144" href="{{ asset('assets/img/favicon/apple-icon-144x144.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ asset('assets/img/favicon/apple-icon-152x152.png?v=1.0.0.0') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/img/favicon/apple-icon-180x180.png?v=1.0.0.0') }}">
    <link rel="icon" type="image/png" sizes="192x192" href="{{ asset('assets/img/favicon/android-icon-192x192.png?v=1.0.0.0') }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('assets/img/favicon/favicon-32x32.png?v=1.0.0.0') }}">
    <link rel="icon" type="image/png" sizes="96x96" href="{{ asset('assets/img/favicon/favicon-96x96.png?v=1.0.0.0') }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('assets/img/favicon/favicon-16x16.png?v=1.0.0.0') }}">
    <link rel="manifest" href="{{ asset('assets/img/favicon/manifest.json?v=1.0.0.0') }}">

    {{--<link href="{{asset('css/frontend.css')}}" rel="stylesheet">--}}

    <link href="{{asset('css/fontawesome-free-5.14.0-web/css/all.min.css')}}" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('css/bootstrap-4.5.0/bootstrap.min.css')}}" media="all">

    <link href="{{asset('css/extra.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/bootstrap-datepicker3.min.css')}}" rel="stylesheet">
    @if(auth()->check())
    <link href="{{ asset('css/parsley.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('select2/dist/css/select2.min.css')}}">

    <link href="{{ asset('css/fullcalendar.min.css') }}" rel="stylesheet">
    <!-- FONT AWESOME -->
    <link rel="stylesheet" href="{{asset('assets/libs/maginificpopup/magnific-popup.min.css')}}" media="all"/>
    <!-- Time Circle -->
    <link rel="stylesheet" href="{{asset('assets/libs/timer/TimeCircles.min.css')}}" media="all"/>
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap4.min.css">
        <!-- jquery-ui Calender -->
        <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.min.css">
    @endif

    <!-- OWL CAROUSEL CSS -->
    <link rel="stylesheet" href="{{asset('assets/libs/owlcarousel/owl.carousel.min.css')}}" media="all" />
    <link rel="stylesheet" href="{{asset('assets/libs/owlcarousel/owl.theme.default.min.css')}}" media="all" />
    <link rel="stylesheet" href="{{asset('assets/libs/animate/animate.min.css')}}" media="all" />
    <!-- MASTER  STYLESHEET  -->
    <link id="lgx-master-style" rel="stylesheet" href="{{asset('assets/css/style-default.min.css?v=1.1.1.1.1.1.1.11')}}" media="all"/>
    <!-- MODERNIZER CSS  -->
    <link rel="stylesheet" href="{{ asset('css/jquery.toast.min.css') }}">
<!--<link href="{{ asset('css/main.min.css') }}" rel="stylesheet">-->

    <!-- GOOGLE FONT -->
    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Oswald:400,700%7cLora:400,400i,700,700i"/>
    {{--is allredy removed jquery.dataTables.css--}}
    {{--<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.css">--}}
    @if(config('app.locale')=='ar')
        <link href="https://fonts.googleapis.com/css2?family=Lato&family=Montserrat&family=Open+Sans&family=Poppins&family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
        <style>
            /**:not(.fa,.fc-icon){*/
            /*    font-family: Tajawal!important;*/
            /*}*/
        </style>
    @endif
    <link href="{{asset('css/'.LaravelLocalization::getCurrentLocaleDirection().'.min.css?v=1.1.1.1.1.1.1.2')}}" rel="stylesheet">

    <!-- SeetAlert2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.min.css">
    @yield('headScript')
    <style>
        input::placeholder:after{color:red!important;content:" *"!important}input:-ms-input-placeholder:after{color:red!important;content:" *"!important}input::-ms-input-placeholder:after{color:red!important;content:" *"!important}.lgx-btn,.lgx-header .lgx-navbar .lgx-nav li a{padding:9px!important;font-size:12px}.image-layer{position:absolute;top:0;width:89%;background:rgb(128 128 128 / 60%);height:140px;color:#fff;padding:5px;cursor:pointer}.dropdown-menu{padding:0 10px}.heading{cursor:default}.btn-facebook{color:#fff;-webkit-text-shadow:0 -1px 0 rgba(0,0,0,0.25);text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#2b4b90;background-image:-moz-linear-gradient(top,#3b5998,#133783);background-image:-webkit-gradient(linear,0 0,0 100%,from(#3b5998),to(#133783));background-image:-webkit-linear-gradient(top,#3b5998,#133783);background-image:-o-linear-gradient(top,#3b5998,#133783);background-image:linear-gradient(to bottom,#3b5998,#133783);background-repeat:repeat-x;border-color:#133783 #133783 #091b40;border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25)}.btn-facebook.active,.btn-facebook.disabled,.btn-facebook:active,.btn-facebook:focus,.btn-facebook:hover,.btn-facebook[disabled]{color:#fff;background-color:#133783!important}.btn-google{color:#fff;-webkit-text-shadow:0 -1px 0 rgba(0,0,0,0.25);text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#ea4435;background-image:-moz-linear-gradient(top,#ef8379,#e6574a);background-image:-webkit-gradient(linear,0 0,0 100%,from(#ef8379),to(#133783));background-image:-webkit-linear-gradient(top,#ef8379,#e6574a);background-image:-o-linear-gradient(top,#ef8379,#e6574a);background-image:linear-gradient(to bottom,#ef8379,#e6574a);background-repeat:repeat-x;border-color:#e6574a #e6574a #091b40;border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25)}.btn-google.active,.btn-google.disabled,.btn-google:active,.btn-google:focus,.btn-google:hover,.btn-google[disabled]{color:#fff;background-color:#f73927!important}button:disabled,button:hover:disabled,button:hover[disabled],button[disabled]{border:1px solid #999;background-color:#ccc;color:#666;cursor:not-allowed}.label-green{background:#19ef0c}.label-red{background:#ea8181}.ui-widget{font-size:1.3em;font-weight:400}.lgx-single-speaker .item-price{font-size:15px}span.price-flag{position:absolute;left:0;background:#ba58fe94;padding:0 30px;color:#fbfbfb;border-bottom-right-radius:10px;border-top-left-radius:5px;font-size:15px}hr{margin-top:2.5rem;margin-bottom:1rem}#sidebarReservation a.text-secondary{position:absolute;z-index:9}.jq-toast-wrap.bottom-left{right:20px;left:auto}.close-jq-toast-single{left:7px;right:auto}.jq-toast-single{text-align:right!important}h3.title{line-height:3rem}.select2-container .select2-selection--single,.select2-container--default .select2-selection--single .select2-selection__arrow{height:42px}.select2-container--default .select2-selection--single .select2-selection__rendered{line-height:42px}.select2-container--default .select2-selection--single{border:1px solid #ced4d9}.custom-file-label::after{height:40px;line-height:30px}.custom-file-label{padding:.375rem 5.75rem;height:42px;line-height:2.5}.custom-file-input{height:42px}#blog-section .single-properties-item .hits-area{height:25px}#blog-section .single-properties-item .title a{line-height:1.7em}#blog-section .single-properties-item .text-area .title{min-height:70px}.bg-badge-purple{background-color:#d166fd;color:#fff}.color-purple{color:#d166fd}.hover-single-item{-webkit-transition-duration:.3s;transition-duration:.3s;-webkit-transition-property:transform;transition-property:transform;box-shadow:0 0 4px #0000001a}.single-properties-item{background:#fff;min-height:230px}#blog-section .single-properties-item{min-height:300px}.single-properties-item a img{width:100%;max-width:100%!important;max-height:180px}.single-properties-item .title{margin-top:0;color:#2e2841;font-size:1.5rem;padding:5px}.dir-rtl{direction:rtl}input{direction:rtl}label[for^=error-]{display:block;text-align:right;color:red}.page-link{color:#fe2e8a;font-size:18px;padding:1rem 1.5rem}.page-item.active .page-link{z-index:3;color:#fff;background-color:#09b2ca;border-color:#09b2ca}@media (max-width:575.98px){#navbarSupportedContent ul li{text-align:center;height:40px}.lgx-single-speaker .profile-img img{width:55%!important}.lgx-single-speaker .speaker-info .lgx-btn{width:45%!important;margin-top:20px}.slider-text-single img{height:330px!important}}@media (max-width:767.98px){#gifImage{height:170px!important}#logoNewYear{display:none}}@media (min-width:991.98px){#websdk-iframe{width:700px!important;height:400px!important}}@media (min-width:1199.98px){#websdk-iframe{width:700px!important;height:400px!important}}@media (min-width:1199.98px){#websdk-iframe{width:700px!important;height:400px!important}}.booking_now:hover{cursor:pointer;background:#f8f9fa}#faqExample .card .card-header .btn-link{font-size:15px}#therapist-times .fbold{font-weight:700;padding:15px}.fz14{font-size:14px}#therapist-times{background:#f5f5f5}#therapist-times .times-card{border-radius:15px;border:1px solid #ccc!important}#therapist-times .time-type{color:#3da8c0;line-height:15px;text-align:center;width:35%}#therapist-times .time-to{width:15%;line-height:40px}#therapist-times .time-from-to{width:50%}#carouselExampleControls .single-time,#therapist-times .single-time{padding:5px;height:65px;margin-bottom:5px;cursor:pointer}#carouselExampleControls .single-time.is_booked,#therapist-times .single-time.is_booked{background:#73bffe3d}#carouselExampleControls .single-time:hover,#therapist-times .single-time:hover{background:#f5f5f5}.select2-container .select2-search--inline .select2-search__field{height:21px}
    </style>
    <!-- Smartsupp Live Chat script -->
<!--    <script type="text/javascript">
        var _smartsupp = _smartsupp || {};
        _smartsupp.key = '7d7611fcb653317a39ff4062551ee205266ba51e';
        window.smartsupp||(function(d) {
            var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
            s=d.getElementsByTagName('script')[0];c=d.createElement('script');
            c.type='text/javascript';c.charset='utf-8';c.async=true;
            c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
        })(document);
    </script>
    @if(auth()->check())
    <script>
        smartsupp('name', '{{ auth()->user()->name }}');
        smartsupp('email', '{{ auth()->user()->email }}');
        @if(auth()->user()->visitor)
        smartsupp('phone', '{{ auth()->user()->visitor->mobile }}');
        @endif
        smartsupp('type', '{{ auth()->user()->type }}');
    </script>
    @endif -->
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-TRTK6G2');</script>
    <!-- End Google Tag Manager -->
    <!-- Meta Pixel Code -->
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '677643230039441');
        fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
                   src="https://www.facebook.com/tr?id=677643230039441&ev=PageView&noscript=1"
        /></noscript>
    <!-- End Meta Pixel Code -->
    <style>
        .se-pre-con {
            position: fixed;
            left: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            z-index: 9999;
            background: url('{{ asset('img/loading-'.app()->getLocale().'.gif') }}') center no-repeat #fff;
        }
    </style>
</head>
<body @if (isset($sliders))class="home"@else class="page page-template"@endif>

<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TRTK6G2"
                  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
{{--<a href="https://wa.me/201011556009" target="_blank">
    <div style="
    background: #4dc247;
    position: fixed;
    bottom: 24px;
    right: 130px;
    width: 60px;
    height: 60px;
    z-index: 99;
    border-radius: 50%;
    text-align: center;
    padding:4px;
">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 32 32" class="wh-messenger-svg-whatsapp wh-svg-icon" style="
"><path d=" M19.11 17.205c-.372 0-1.088 1.39-1.518 1.39a.63.63 0 0 1-.315-.1c-.802-.402-1.504-.817-2.163-1.447-.545-.516-1.146-1.29-1.46-1.963a.426.426 0 0 1-.073-.215c0-.33.99-.945.99-1.49 0-.143-.73-2.09-.832-2.335-.143-.372-.214-.487-.6-.487-.187 0-.36-.043-.53-.043-.302 0-.53.115-.746.315-.688.645-1.032 1.318-1.06 2.264v.114c-.015.99.472 1.977 1.017 2.78 1.23 1.82 2.506 3.41 4.554 4.34.616.287 2.035.888 2.722.888.817 0 2.15-.515 2.478-1.318.13-.33.244-.73.244-1.088 0-.058 0-.144-.03-.215-.1-.172-2.434-1.39-2.678-1.39zm-2.908 7.593c-1.747 0-3.48-.53-4.942-1.49L7.793 24.41l1.132-3.337a8.955 8.955 0 0 1-1.72-5.272c0-4.955 4.04-8.995 8.997-8.995S25.2 10.845 25.2 15.8c0 4.958-4.04 8.998-8.998 8.998zm0-19.798c-5.96 0-10.8 4.842-10.8 10.8 0 1.964.53 3.898 1.546 5.574L5 27.176l5.974-1.92a10.807 10.807 0 0 0 16.03-9.455c0-5.958-4.842-10.8-10.802-10.8z" fill-rule="evenodd" style="
    fill: white;
"></path></svg>
    </div>
</a>--}}
    <!--[if lt IE 8]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade
    your browser</a> to improve your experience.</p>
<![endif]-->
<div class="lgx-container ">
    <!-- ***  ADD YOUR SITE CONTENT HERE *** -->
    <!--HEADER-->
    <header>
        <div id="lgx-header" class="lgx-header">
            <div class="lgx-header-inner">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-12 mainmenuclass">
                            <nav class="navbar navbar-expand-md navbar-dark sticky-top lgx-navbar">
                                <div class="container">
                                    <div class="col-md-3 navbar-default">
                                        <div class="lgx-logo">
                                            <a href="{{ route('index') }}" class="navbar-brand mr-5">
                                                <img class="lazy" src="{{asset('img/placeholder.png')}}" data-src="{{asset('assets/img/logo-white.png')}}"  data-srcset="{{asset('assets/img/logo-white.png')}}"  alt="New Life" id="logo-image"/>
                                            </a>
                                        </div>
                                        <button class="navbar-toggler navbar-toggle"
                                                type="button"
                                                data-toggle="collapse"
                                                data-target="#navbarSupportedContent"
                                                aria-controls="navbarSupportedContent"
                                                aria-expanded="false" aria-label="{{ __('Toggle navigation') }}"
                                        >
                                            <i class="fas fa-bars icon-bar"></i>
                                        </button>
                                    </div>
                                    <div class="col-md-9 py-3 Nav-items">
                                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                            <!-- Left Side Of Navbar -->
                                            <ul class="navbar-nav lgx-nav ml-auto">
                                                @guest
                                                    <li><a class="lgx-scroll" href="{{route('therapistslist')}}">{{trans('home.therapists')}}</a></li>
                                                    {{--                                                    <li><a class="lgx-scroll" href="{{route('index')}}#lgx-schedule">{{trans('home.how')}}</a></li>--}}
                                                    <li><a class="lgx-scroll" href="{{route('index')}}#lgx-blog">{{trans('home.blog')}}</a></li>
                                                    <li><a class="lgx-scroll" href="{{route('psychological-test')}}">{{trans('home.psychological-test')}}</a></li>
                                                    <li class="lgx-scroll"><a href="{{route('page_view',trans('home.route_about'))}}">{{trans('home.about')}}</a></li>
                                                    <li class="lgx-scroll"><a href="{{route('page_view',trans('home.faqs_route'))}}">{{trans('home.faqs')}}</a></li>
                                                @else
                                                    @if (auth()->user()->type == 'visitors')
                                                        <li><a class="lgx-scroll" href="{{route('therapistslist')}}">{{trans('home.therapists')}}</a></li>
                                                        <li><a class="lgx-scroll" href="{{route('index')}}#lgx-schedule">{{trans('home.how')}}</a></li>
                                                        <li><a class="lgx-scroll" href="{{route('index')}}#lgx-blog">{{trans('home.blog')}}</a></li>
                                                        <li><a class="lgx-scroll" href="{{route('psychological-test')}}">{{trans('home.psychological-test')}}</a></li>
                                                    @else
                                                        <li><a class="lgx-scroll" href="{{route('index')}}">{{trans('home.home')}}</a></li>
                                                        <li><a class="lgx-scroll" href="{{route('therapists_sessions')}}">{{trans('auth.therapists.sessions')}}</a></li>
                                                        <li><a class="lgx-scroll" href="{{route('clients-files')}}">{{trans('auth.therapists.clients_files')}}</a></li>
                                                        <li><a class="lgx-scroll" href="{{route('therapists_clients')}}">{{trans('auth.therapists.clients')}}</a></li>
                                                        <li><a class="lgx-scroll" href="{{route('therapists_invoice')}}">{{trans('auth.therapists.invoices')}}</a></li>
                                                    @endif
                                                @endguest
                                            </ul>
                                            <!-- Right Side Of Navbar -->
                                            <ul class="navbar-nav mr-auto lgx-nav">
                                                @guest
                                                    <li>
                                                        <a class="nav-link" href="{{ route('login') }}">{{ trans('auth.login') }}</a>
                                                    </li>
                                                    <li>
                                                        <a class="nav-link" href="{{ route('therapist_signup') }}">{{ trans('auth.therapists.signup') }}</a>
                                                    </li>
                                                    {{--                                                    <li>--}}
                                                    {{--                                                            @foreach(LaravelLocalization::getSupportedLocales() as $localeCode => $properties)--}}
                                                    {{--                                                                @if ($localeCode != LaravelLocalization::getCurrentLocale())--}}
                                                    {{--                                                                <li class="nav-item dropdown">--}}
                                                    {{--                                                                    <a class="nav-link" rel="alternate" hreflang="{{ $localeCode }}" href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}">--}}
                                                    {{--                                                                        {{ $properties['native'] }}--}}
                                                    {{--                                                                    </a>--}}
                                                    {{--                                                                </li>--}}
                                                    {{--                                                                @endif--}}
                                                    {{--                                                            @endforeach--}}
                                                    {{--                                                     </li>--}}
                                                @else
                                                    @if (auth()->user()->type == 'visitors')
                                                        <li class="nav-item dropdown">
                                                            <a class="nav-link" href="{{ route('mysessions') }}">{{ trans('auth.mysessions') }}</a>
                                                        </li>
                                                        <li class="nav-item dropdown">
                                                            <a class="nav-link dropdown-toggle" href="{{ route('profile') }}" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                <i class="fas fa-user"></i>
                                                                {{Str::limit(auth()->user()->name,20)}}
                                                            </a>
                                                            <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                                                <li><a class="dropdown-item" href="{{ route('visitor-profile') }}">{{ trans('auth.profile') }}</a></li>
                                                                <li><a class="dropdown-item" href="{{ route('rate-website') }}">{{ trans('auth.rate-website') }}</a></li>
                                                                <li><a class="dropdown-item" href="{{ route('complaint') }}">{{ trans('auth.complaint') }}</a></li>
                                                                <li>
                                                                    <a class="dropdown-item" href="{{ route('logout') }}"
                                                                       onclick="event.preventDefault();
                                                                        document.getElementById('logout-form').submit();">
                                                                        {{ trans('auth.logout') }}
                                                                    </a>
                                                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                                                        @csrf
                                                                    </form>
                                                                </li>
                                                            </ul>
                                                        </li>
                                                    @else
                                                        <li class="nav-item dropdown">
                                                            <a class="nav-link dropdown-toggle" href="{{ route('therapists_profile_basic') }}" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                <i class="fas fa-user"></i>
                                                                {{(app()->getLocale()=='ar')? Str::limit(auth()->user()->therapist->name_a,20) : Str::limit(auth()->user()->therapist->name_e,20)}}
                                                            </a>
                                                            <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                                                <li><a class="dropdown-item" href="{{ route('therapists_profile_basic') }}">{{ trans('auth.therapists.profile') }}</a></li>
                                                                <li>
                                                                    <a class="dropdown-item" href="{{ route('logout') }}"
                                                                       onclick="event.preventDefault();
                                                                        document.getElementById('logout-form').submit();">
                                                                        {{ trans('auth.logout') }}
                                                                    </a>
                                                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                                                        @csrf
                                                                    </form>
                                                                </li>
                                                            </ul>
                                                        </li>
                                                    @endif
                                                @endguest
                                                @if(config('app.locale') == "en")
                                                    <li>
                                                        <a class="nav-link" href="{{ URL('/'.getCurrentUrl('ar')) }}">{{ trans('home.arabic') }}</a>
                                                    </li>
                                                @else
                                                    <li>
                                                        <a class="nav-link" href="{{ URL('en/'.getCurrentUrl('en')) }}">{{ trans('home.english') }}</a>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </nav>
                        </div>
                    </div>
                    <!--//.ROW-->
                </div>
                <!-- //.CONTAINER -->
            </div>
            <!-- //.INNER-->
        </div>
    </header>
    <!--HEADER END-->
@yield('content')
<!--FOOTER-->
    <footer>
        <div id="lgx-footer" class="lgx-footer">
            <div class="lgx-footer-bg">
                <div class="lgx-inner">
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-4">
                                <div class="footer-social mb-0">
                                    <ul class="list-inline d-flex justify-content-center">
                                        <li><a class="sp-fb" href="https://www.facebook.com/newhayahuk"><i class="fab fa-facebook-f"></i></a></li>
                                        <li><a class="sp-tw" href="https://www.instagram.com/newhayahuk/"><i class="fab fa-instagram"></i></a></li>
                                        <li><a class="sp-tw" href="https://twitter.com/newhayahuk"><i class="fab fa-twitter"></i></a></li>
                                        <li><a class="sp-tw" href="https://www.youtube.com/channel/UCi2PFQag9zjE3X7OWtfdTrw"><i class="fab fa-youtube"></i></a></li>
                                        <li><a class="sp-tw" href="https://www.snapchat.com/add/newhayahuk"><i class="fab fa-snapchat"></i></a></li>
                                        <li><a class="sp-tw" href="https://www.linkedin.com/company/newhayahuk"><i class="fab fa-linkedin"></i></a></li>
                                    </ul>
                                </div>
                                <a href="#" target="_blank">
                                    <img class="lazy" src="{{asset('img/placeholder.png')}}" data-src="{{ asset('images/vodafone.png') }}"  data-srcset="{{ asset('images/vodafone.png') }}" style="    width: 77px;border-radius: 5px;" alt="">
                                </a>
                                <a href="#" target="_blank">
                                    <img class="lazy" src="{{asset('img/placeholder.png')}}" data-src="{{ asset('img/button-your-business/cards.jpg') }}"  data-srcset="{{ asset('img/button-your-business/cards.jpg') }}" style="width: 105px" alt="">
                                </a>
                            </div>
                            <div class="col-xl-4">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item bg-transparent">
                                        <a href="{{ route('index') }}">{{trans('home.home')}}</a>
                                    </li>
                                    <li class="list-group-item bg-transparent">
                                        <a  target="_blank" href="{{route('page_view',trans('home.terms-url'))}}">{{trans('home.terms')}}</a>
                                    </li>
                                    <li class="list-group-item bg-transparent">
                                        <a  target="_blank" href="{{route('page_view',trans('home.privacy-policy-url'))}}">{{trans('home.privacy-policy')}}</a>
                                    </li>
                                    {{--                                        <li class="list-group-item bg-transparent">--}}
                                    {{--                                            <a href="{{route('page_view',['6'])}}">{{trans('home.privacy')}}</a>--}}
                                    {{--                                        </li>--}}
                                    <li class="list-group-item bg-transparent">
                                        <a href="{{route('contact-us') }}">{{trans('home.contact-us')}}</a>
                                    </li>
                                    @if (auth()->check()&&auth()->user()->type != 'visitors')
                                        <li class="list-group-item bg-transparent">
                                            <a href="{{route('page_view',getStaticPageValue(10,'url')) }}">{{ getStaticPageValue(10) }}</a>
                                        </li>
                                    @endif
                                    @if ((auth()->check()&&auth()->user()->type == 'visitors')||!auth()->check())
                                        <li class="list-group-item bg-transparent">
                                            <a href="{{route('page_view',getStaticPageValue(11,'url')) }}">{{ getStaticPageValue(11) }}</a>
                                        </li>
                                    @endif
                                    {{--<li class="list-group-item bg-transparent">
                                        <a href="{{route('videos') }}">{{trans('home.videos')}}</a>
                                    </li>--}}
                                </ul>
                            </div>
                            <div class="col-xl-4">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item bg-transparent">
                                        <h3>{{trans('home.we')}}</h3>
                                        <p class="mt-2" style="color:#fff;font-size: 1.2rem">
                                            {{trans('home.we-desc')}}
                                        </p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <p class="lgx-copyright mt-5 "><span class="text">{!! trans('home.copy') !!}</span></p>
                        <p class="lgx-copyright mt-1 "> {{ trans('home.by') }}  </p>
                    </div>
                    <!-- //.CONTAINER -->
                </div>
            </div>
            <!-- //.INNER-->
        </div>
    </footer>
    <!--FOOTER END-->
    <!-- Modal -->
<!-- <div class="modal fade" id="model" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog" role="document" style="max-width: 1000px;">
            <div class="modal-content">
              <div class="modal-body row p-0">
                <div class="col-md-6">
                    <p style=" position: absolute;background: black;width: 94%;height: 15px;"></p>
                    <img src="{{ asset('img/2022.gif') }}" style="height: 450px;" id="gifImage">
                </div>
                <div class="col-md-6 mt-5 pt-5">
                    <button type="button" style="top: -30px;font-size: 20px; position: absolute;left: 23px;color: #898989;opacity: 1;" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
                    <h4 class="text-center">@lang('home.newYear1')</h4>
                    <h2 style="color: #ff6666;margin: 10px 0;text-align: center;">@lang('home.newYear2')</h2>
                    <h4 class="mb-5 text-center">@lang('home.newYear3')</h4>
                    <h4 style=" margin-bottom: 30px;   text-align: center;font-size: 15px;font-weight: 600;">  @lang('home.new1')  <span id="selectText" style="font-size: 23px;color: #ff6666;">NewHayah 2022</span> <button id="copyText" class="btn btn-primary" onclick="copyData(selectText)">Copy Code</button><br><br> <a style="color: #4cb8ce;" href="{{route('therapists_have_coupon')}}">@lang('home.new2')</a> </h4>
                </div>
              </div>
            </div>
          </div>
        </div> -->
</div>
<!--.LGX SITE CONTAINER-->
<!-- *** ADD YOUR SITE SCRIPT HERE *** -->
<!-- Scripts -->
<!--<script src="{{asset('js/frontend.js')}}" type="text/javascript"></script>-->
{{--
<script>
    let createScript1=document.createElement('script')
    createScript1.src='{{asset('js/jquery-3.5.1.min.js')}}';
    document.body.appendChild(createScript1);

    let createScript2=document.createElement('script')
    createScript2.src='{{asset('js/jquery-ui.min.js')}}';
    document.body.appendChild(createScript2);


    let createScript3=document.createElement('script')
    createScript3.src='{{asset('js/bootstrap.min.js')}}';
    document.body.appendChild(createScript3);

    let createScript4=document.createElement('script')
    createScript4.src='{{ asset('select2/dist/js/select2.min.js')}}';
    document.body.appendChild(createScript4);

    let createScript5=document.createElement('script')
    createScript5.src='{{ asset('select2/dist/js/i18n/'.app()->getLocale().'.js')}}';
    document.body.appendChild(createScript5);

    let createScript6=document.createElement('script')
    createScript6.src='{{ asset('js/script-accordion.js')}}';
    document.body.appendChild(createScript6);

    let createScript7=document.createElement('script')
    createScript7.src='{{asset('js/owl.carousel.min.js')}}';
    document.body.appendChild(createScript7);

    let createScript8=document.createElement('script')
    createScript8.src='{{asset('js/datepicker/bootstrap-datepicker.min.js')}}';
    document.body.appendChild(createScript8);

    let createScript9=document.createElement('script')
    createScript9.src='{{asset('js/extra.js?v=1.0.0.0.6')}}';
    document.body.appendChild(createScript9);

    let createScript10=document.createElement('script')
    createScript10.src='{{asset('assets/js/vendor/modernizr-2.8.3.min.js')}}';
    document.body.appendChild(createScript10);


    let createScript11=document.createElement('script')
    createScript11.src='https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js';
    document.body.appendChild(createScript11);

    let createScript12=document.createElement('script')
    createScript12.src='{{asset('assets/libs/jquery.smooth-scroll.js')}}';
    document.body.appendChild(createScript12);

    let createScript13=document.createElement('script')
    createScript13.src='{{asset('assets/libs/jquery.validate.min.js')}}';
    document.body.appendChild(createScript13);


     let createScript14=document.createElement('script')
    createScript14.src='{{asset('assets/libs/maginificpopup/jquery.magnific-popup.min.js')}}';
    document.body.appendChild(createScript14);

    let createScript15=document.createElement('script')
    createScript15.src='{{asset('assets/libs/jquery.smooth-scroll.min.js')}}';
    document.body.appendChild(createScript15);

    let createScript16=document.createElement('script')
    createScript16.src='{{asset('assets/libs/jquery.easing.min.js')}}';
    document.body.appendChild(createScript16);

    let createScript17=document.createElement('script')
    createScript17.src='{{asset('assets/libs/typed/typed.min.js')}}';
    document.body.appendChild(createScript17);

    let createScript18=document.createElement('script')
    createScript18.src='{{asset('assets/js/custom.script.min.js')}}';
    document.body.appendChild(createScript18);

    let createScript19=document.createElement('script')
    createScript19.src='https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js';
    document.body.appendChild(createScript19);

    let createScript20=document.createElement('script')
    createScript20.src='https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap4.min.js';
    document.body.appendChild(createScript20);

    let createScript21=document.createElement('script')
    createScript21.src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js';
    document.body.appendChild(createScript21);



    @if(app()->getLocale()=='ar')
    let createScript22=document.createElement('script')
    createScript22.src='https://momentjs.com/downloads/moment-with-locales.min.js';
    document.body.appendChild(createScript22);
    @endif

    let createScript23=document.createElement('script')
    createScript23.src='https://code.jquery.com/ui/1.12.1/jquery-ui.min.js';
    document.body.appendChild(createScript23);

    let createScript24=document.createElement('script')
    createScript24.src='{{asset('js/fullcalendar.min.js')}}';
    document.body.appendChild(createScript24);

    let createScript25=document.createElement('script')
    createScript25.src='https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js';
    document.body.appendChild(createScript25);

    let createScript26=document.createElement('script')
    createScript26.src='{{ asset('js/jquery.toast.min.js') }}';
    document.body.appendChild(createScript26);

</script>
--}}

<script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
{{--
<script src="{{asset('js/jquery-ui.min.js')}}" type="text/javascript"></script>
<script src="{{asset('js/bootstrap.min.js')}}" type="text/javascript"></script>
--}}
@if(auth()->check())
<script src="{{ asset('select2/dist/js/select2.min.js')}}"></script>
<script src="{{ asset('select2/dist/js/i18n/'.app()->getLocale().'.js')}}"></script>
@endif
{{--<script src="{{ asset('js/script-accordion.min.js')}}"></script>--}}
{{--<script src="{{asset('js/parsley.min.js')}}"></script>--}}
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js" integrity="sha512-qTXRIMyZIFb8iQcfjXWCO8+M5Tbc38Qi5WzdPOYZHIlZpzBHG3L3by84BBBOiRGiEb7KKtAOAs5qYdUiZiQNNQ==" crossorigin="anonymous"></script>
@if(auth()->check()||request()->segment(1)=='therapist')
<script src="{{asset('js/datepicker/bootstrap-datepicker.min.js')}}" type="text/javascript"></script>
<script src="{{asset('js/datepicker/bootstrap-datepicker.en-CA.min.js')}}" type="text/javascript"></script>
@endif

{{--
<!--MODERNIZER js-->
<script src="{{asset('assets/js/vendor/modernizr-2.8.3.min.js')}}"></script>

<!-- SweetAlert2 js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js"></script>
--}}
<?php /*
        <!-- JQUERY  -->
        <script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
        <script src="{{asset('assets/js/vendor/jquery-1.12.4.min.js')}}"></script>
        <!-- BOOTSTRAP JS  -->
        <script src="{{asset('assets/libs/bootstrap/js/bootstrap.min.js')}}"></script>
        */?>
{{--
<script src="{{asset('assets/libs/jquery.smooth-scroll.js')}}"></script>
<!-- SKILLS SCRIPT  -->

<script src="{{asset('assets/libs/jquery.validate.min.js')}}"></script>
<!-- adding magnific popup js library -->
<script type="text/javascript" src="{{asset('assets/libs/maginificpopup/jquery.magnific-popup.min.js')}}"></script>

<!-- SMOTH SCROLL -->
<script src="{{asset('assets/libs/jquery.smooth-scroll.min.js')}}"></script>
<script src="{{asset('assets/libs/jquery.easing.min.js')}}"></script>
<!-- type js -->
<script src="{{asset('assets/libs/typed/typed.min.js')}}"></script>
<!-- CUSTOM SCRIPT  -->
<!-- CUSTOM SCRIPT  -->
<script src="{{asset('assets/js/custom.script.min.js')}}"></script>
--}}
{{--<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.js"></script>--}}
@if(auth()->check())
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap4.min.js"></script>
<script> $.fn.dataTable.ext.errMode = 'none';</script>
<!-- calender -->

@if(app()->getLocale()=='ar')
    <script src="https://momentjs.com/downloads/moment-with-locales.min.js"></script>
@endif
@endif
{{--        <script src="https://cdn.jsdelivr.net/npm/fullcalendar-scheduler@5.3.0/main.min.js"></script>--}}
{{--
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
--}}
@if(auth()->check())
<script  src="{{asset('js/fullcalendar.min.js')}}"></script>
@endif
{{-- <script src="https://rawgit.com/RobinHerbots/jquery.inputmask/3.x/dist/jquery.inputmask.bundle.js"></script>--}}
{{--
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js"></script>
<script src="{{ asset('js/jquery.toast.min.js') }}"></script>
<!-- Owl Carousel  -->
<script src="{{asset('js/owl.carousel.min.js')}}"></script>
<script src="{{asset('js/extra.min.js?v=1.0.0.0.6')}}" type="text/javascript"></script>
--}}
<script>
    document.addEventListener("DOMContentLoaded", function() {
        var lazyImages = [].slice.call(document.querySelectorAll("img.lazy"));

        if ("IntersectionObserver" in window) {
            lazyImageObserver = new IntersectionObserver(function (entries, observer) {
                entries.forEach(function (entry) {
                    if (entry.isIntersecting) {
                        lazyImage = entry.target;
                        lazyImage.src = lazyImage.dataset.src;
                        lazyImage.srcset = lazyImage.dataset.srcset;
                        lazyImage.classList.remove("lazy");
                        lazyImageObserver.unobserve(lazyImage);
                    }
                });
            });

            lazyImages.forEach(function (lazyImage) {
                lazyImageObserver.observe(lazyImage);
            });
        } else {
            // Possibly fall back to a more compatible method here
        }

    });
</script>
<script>


</script>
@yield('scriptSection')
{{-- @include('sweetalert::alert')--}}
@stack('downloadPDF')
@if(\Request::segment(2) != 'startsession')
    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        (function(){
            var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
            s1.async=true;
            s1.src='https://embed.tawk.to/61a4028c53b398095a667909/1flkajto0';
            s1.charset='UTF-8';
            s1.setAttribute('crossorigin','*');
            s0.parentNode.insertBefore(s1,s0);
        })();
    </script>
    <!--End of Tawk.to Script mohamed-->
@endif
<script>
    scripts=[
        //'https://newhayah.com/js/jquery-3.5.1.min.js',
        'https://newhayah.com/js/jquery-ui.min.js',
        'https://newhayah.com/js/bootstrap.min.js',
        'https://newhayah.com/assets/js/vendor/modernizr-2.8.3.min.js',
        'https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js',
        'https://newhayah.com/assets/libs/jquery.smooth-scroll.js',
        'https://newhayah.com/assets/libs/jquery.validate.min.js',
        'https://newhayah.com/assets/libs/maginificpopup/jquery.magnific-popup.min.js',
        'https://newhayah.com/assets/libs/jquery.smooth-scroll.min.js',
        'https://newhayah.com/assets/libs/jquery.easing.min.js',
        'https://newhayah.com/assets/libs/typed/typed.min.js',
        'https://code.jquery.com/ui/1.12.1/jquery-ui.min.js',
        'https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js',
        'https://newhayah.com/js/jquery.toast.min.js',
        'https://newhayah.com/js/owl.carousel.min.js',
        'https://newhayah.com/js/extra.min.js?v=1.0.0.0.6',
        'https://newhayah.com/assets/js/custom.script.min.js',
    ];
    scripts.forEach(function(item){
        let createScript=document.createElement('script')
        createScript.src=item;
        document.body.appendChild(createScript);
    })
    setTimeout(function(){
        $(document).ready(function(){

            setTimeout(function(){
                $('.se-pre-con').remove();
            },3000)
            $(document).ready(function(){
                //$("#model").modal('show');
                $('input[type="password"],input[name="phone"]').on("paste",function(e) {
                    e.preventDefault();
                });
                if($('.select2').length){
                    $('.select2').select2({
                        language: "{{ app()->getLocale() }}"
                    });
                }
                $(document).on('click','.booking_now',function(){
                    link=$(this).attr('data-link')
                    if(link){
                        window.location.href=link;
                    }
                });
                $(document).on('click','.is_booked',function () {
                    $.toast({
                        text: '@lang('home.This time slot is already booked Please choose another time slot')',
                        showHideTransition: 'slide',
                        icon: 'error',
                    });
                })
                $(document).on('click','.filter-poup',function(){
                    var width = '450px';
                    if ($(window).width() < 420) {
                        width = '300px';
                    }
                    $('#sidebarReservationFilter').width(width);
                    $('#sidebarReservationFilter').show("slide", { direction: "left" }, 1000);
                    $('#sidebarReservationFilter > div.card').css({
                        'max-height': ($(window).height()-150)+'px' ,
                        'overflow': 'auto'
                    });
                });
            });
            function closeSideBarFilter() {
                $('#sidebarReservationFilter').hide("slide", { direction: "left" }, 1000);
            }
        })

        /*  $('.owl-carousel.slider').owlCarousel({
              loop:true,
              margin:10,
              rtl:true,
              nav:true,
              responsive:{
                  0:{
                      items:1
                  },
                  600:{
                      items:3
                  },
                  1000:{
                      items:3
                  }
              }
          });*/
        function copyData(containerid) {
            var range = document.createRange();
            range.selectNode(containerid); //changed here
            window.getSelection().removeAllRanges();
            window.getSelection().addRange(range);
            document.execCommand("copy");
            window.getSelection().removeAllRanges();
            $('#copyText').html('Copied...');
        }
    },3000)

</script>
<script type="text/javascript" src="{{ asset('js/extra.js') }}"></script>
<!-- @php
    $item = new \App\User;
   $table = $item->getTable();
   dd(Schema::getColumnListing($table));
@endphp -->
</body>
</html>
