<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html lang="{{ app()->getLocale() }}" @if(app()->getLocale()=='ar') dir="rtl" @endif>
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title>@lang('home.Payment Session') {{ $therapist->name_e }}</title>
    @if(app()->getLocale()=='ar')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta3/dist/css/bootstrap.rtl.min.css">
    @else
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css">
    @endif
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

     <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        .loading {
            position: relative;
        }
        .loading::after {
            position: absolute;
            background: center 1.7857142857rem no-repeat rgba(255, 255, 255, .5);
            background-image: url(https://cf2.s3.souqcdn.com/public/style/img/loading.gif);
            background-repeat: no-repeat;
            background-position: center center;
            background-color: rgba(250, 250, 250, .8);
            background-size: 1.7857142857rem auto;
        }
        .loading::after {
            display: block!important;
            width: 100%;
            height: 100%;
            left: 0;
            top: 0;
            z-index: 148;
            content: ' '!important;
            line-height: 0;
        }
        body {
            background-color: #eee
        }

        .container {
            height: 100vh
        }

        .card {
            border: none
        }

        .form-control {
            border-bottom: 2px solid #eee !important;
            border: none;
            font-weight: 600
        }

        .form-control:focus {
            color: #495057;
            background-color: #fff;
            border-color: #8bbafe;
            outline: 0;
            box-shadow: none;
            border-radius: 0px;
            border-bottom: 2px solid blue !important
        }

        .inputbox {
            position: relative;
            margin-bottom: 20px;
            width: 100%
        }

        .inputbox span {
            position: absolute;
            top: 7px;
            @if(app()->getLocale()=='ar')
            right:11px;
            @else
            left: 11px;
            @endif
            transition: 0.5s
        }

        .inputbox i {
            position: absolute;
            top: 13px;
            @if(app()->getLocale()=='ar')
            left:8px;
            @else
            right: 8px;
            @endif
            transition: 0.5s;
            color: #3F51B5
        }

        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0
        }

        .inputbox input:focus~span {
            transform: translateX(-0px) translateY(-15px);
            font-size: 12px
        }

        .inputbox input:valid~span {
            transform: translateX(-0px) translateY(-15px);
            font-size: 12px
        }

        .card-blue {
            background-color: #ba58fe;
        }

        .hightlight {
            background-color: #5737d9;
            padding: 10px;
            border-radius: 10px;
            margin-top: 15px;
            font-size: 14px
        }

        .yellow {
            color: #eeeeee;
        }

        .decoration {
            text-decoration: none;
            font-size: 14px
        }

        .btn-success {
            color: #fff;
            background-color: #b957fe;
            border-color: #990dfb;
        }

        .btn-success:hover,.btn-success:focus,.btn-success:active {
            color: #fff;
            background-color: #bc75ef;
            border-color: #7108bb
        }
        .btn-success:focus{
            box-shadow: 0 0 0 0.2rem rgb(188 117 239 / 40%);
        }
        .btn-success:disabled {
            background-color: #d9a2ff;
            border-color: #7a2baf;
        }
        .decoration:hover {
            text-decoration: none;
            color: #fdcc49
        }
    </style>
    <!-- INCLUDE SESSION.JS JAVASCRIPT LIBRARY -->
    {{--test--}}
    {{--<script id="vaplusScript" src="https://api.vapulus.com:1338/app/session/script?appId=a3332a09-f9a2-4472-9852-bbb43213b5b3"></script>--}}
    {{--production--}}
    {{--<script src="https://api.vapulus.com:1338/app/session/script?appId=442856a6-6ba1-4c22-a3b4-339b58d1a72e"></script>--}}
    @if(env('SELECTED_PAYMENT')!='stripe')
        <script src="https://api.vapulus.com:1338/app/session/script?appId={{ config('app.WHEREBY_APP_ID') }}"></script>
        <!-- APPLY CLICK-JACKING STYLING AND HIDE CONTENTS OF THE PAGE -->
        <style id="antiClickjack">
            body {
                display: none !important;
            }
        </style>
    @endif

</head>
<body>
<header class="d-none d-md-block">
    <!-- Start of main nav -->
    <div class="container-fluid mid-container">
        <div class="row border-bottom d-flex justify-content-around align-items-center mx-xl-5 mx-md-4">
            <!--brand-->
            <div class="main-brand col-8 my-1 text-center">
                <a href="{{ route('index') }}"><img src="{{ asset('assets/img/logo.png') }}" alt="logo"></a>
            </div>
            <!--end brand-->
            <!--end of cart-->
        </div>
    </div>
    <!-- End of mid nav -->
</header>
<div class="container mt-5 px-5">
    <a class="{{ (app()->getLocale()=='ar')?'pull-left':'pull-right' }} btn btn-primary"  href="{{ route('therapists_preview',$therapist->id) }}"> <i class="fa fa-arrow-circle-o-left"></i> @lang('home.back') </a>
    <div class="mb-4">
        <h2>@lang('home.Confirm Session pay')</h2> <span>@lang('home.please make the payment, after that you can start session with the therapist on the session time.')</span>
    </div>
    <div class="row">
        <div class="col-xxl-8 col-xl-8  col-lg-8 col-md-12 col-xs-12 col-sm-12 col-12 order-md-1">
            <div class="card p-3">
                <h6 class="text-uppercase">@lang('home.Payment details')</h6>
                <div class="row" id="paymentForm">
                    {{--<form id="paymentForm" action="">

                    </form>--}}
                    <div class="col-md-12 mt-2">
                        <div class="inputbox mt-3 mr-2">
                            <input type="text" name="cardNumber" id="cardNumber" @if(env('SELECTED_PAYMENT')!='stripe'){{ 'readonly' }}@endif class="form-control">
                            <i class="fa fa-credit-card"></i> <span @if(env('SELECTED_PAYMENT')!='stripe') style="top: -26px" @endif>@lang('home.Card Number')</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="inputbox mt-3 mr-2"> <input type="text" name="cardMonth" id="cardMonth" class="form-control"> <span>@lang('home.Expiry month')</span> </div>
                    </div>
                    <div class="col-md-6">
                        <div class="inputbox mt-3 mr-2"> <input type="text" name="cardYear" id="cardYear" class="form-control"> <span>@lang('home.Expiry year')</span> </div>
                    </div>
                    <div class="col-md-12">
                        <div class="inputbox mt-3 mr-2"> <input type="text" name="cardCVC" id="cardCVC" class="form-control" @if(env('SELECTED_PAYMENT')!='stripe'){{ 'readonly' }}@endif> <span  @if(env('SELECTED_PAYMENT')!='stripe') style="top: -26px" @endif> @lang('home.CVV')</span> </div>
                    </div>
                    <div class="col-md-12">
                        <div class="inputbox mt-3 mr-2">
                            <input type="text" name="coupon" id="coupon" class="form-control">
                            <span> @lang('home.Coupon')</span> </div>
                            <p class="alert" id="coupon_message" style="padding: 5px;font-size: 12px;margin-top: -20px;"></p>
                    </div>
                    <div class="col-md-12">
                        <div class="inputbox mt-3 mr-2">
                            <input type="text" @if(auth()->check()&&isset(auth()->user()->visitor))value="{{ auth()->user()->visitor->mobile }}"@endif name="mobile" id="mobile" class="form-control">
                            <span > @lang('home.Mobile')</span> </div>
                    </div>
                    <div class="errorMessage"></div>
                    <div class="mt-4 mb-4 d-flex justify-content-between"> <button id="payButton" class="btn btn-success btn-block px-3">@lang('home.Pay') {{ $location->countryName=='Egypt'?'EGP':'USD' }}

                        <span class="neweprice">{{ ($location->countryName=='Egypt')?(in_array($session->type,['30','3','10'])?$therapist->price30:$therapist->price60):(in_array($session->type,['30','3','10'])?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar) }}</span></button> </div>
                </div>
            </div>

        </div>
        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-12 col-xs-12 col-sm-12 col-12 order-lg-1">
            <div class="card card-blue p-3 text-white mb-3"> <span>@lang('home.You have to pay')</span>
                <div class="d-flex flex-row align-items-end mb-3">
                    <h1 class="mb-0 yellow">{{ $location->countryName=='Egypt'?'EGP':'USD' }} 

                       <span class="neweprice"> {{ ($location->countryName=='Egypt')?(in_array($session->type,['30','3','10'])?$therapist->price30:$therapist->price60):(in_array($session->type,['30','3','10'])?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar) }} </span></h1>
                    <span></span>
                </div>
                {{--<span>Enjoy session after you complete the payment</span>
                <a href="#" class="yellow decoration">Know all the features</a>
                <div class="hightlight"> <span>You can start session</span> </div>--}}
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js"></script>
{{--<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/localization/messages_ar.min.js"></script>--}}
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script id="PaymentScript">



    @if(env('SELECTED_PAYMENT')!='stripe')
    $("#paymentForm").addClass('loading')
    if(window.PaymentSession){
        PaymentSession.configure({
            fields: {
                // ATTACH HOSTED FIELDS IDS TO YOUR PAYMENT PAGE FOR A CREDIT CARD
                card: {
                    cardNumber: "cardNumber",
                    securityCode: "cardCVC",
                    expiryMonth: "cardMonth",
                    expiryYear: "cardYear"
                }
            },
            callbacks: {
                initialized: function (err, response) {
                    console.log("init....");
                    console.log(err, response);
                    console.log("/init.....");
                    $("#paymentForm").removeClass('loading')
                    // HANDLE INITIALIZATION RESPONSE
                },
                formSessionUpdate: function (err,response) {
                    console.log("update callback.....");
                    console.log(err,response);
                    console.log("/update callback....");
                    $("#payButton").removeAttr('disabled');
                    // HANDLE RESPONSE FOR UPDATE SESSION
                    if (response.statusCode) {
                        if (200 == response.statusCode) {
                            $("#paymentForm").addClass('loading')

                            $.ajax({
                                type: "POST",
                                url: "{{ route('book_redirect',$session->id) }}",
                                data: {"session_id": response.data.sessionId,coupon:$("#coupon").val(),mobile:$("#mobile").val(),_token:token},
                                success: function (msg) {
                                    $("#paymentForm").removeClass('loading');
                                    $(".errorMessage").html('<div class="alert alert-'+(msg.success?'success':'danger')+'">'+msg.message+'</div>')
                                    animateCSS('.errorMessage','bounce').then(function(){
                                        setTimeout(function(){
                                            animateCSS('.errorMessage','flipOutX').then(()=>$(".errorMessage").html(''));
                                        },2000)
                                    });
                                    if(msg.redirect_url){
                                        window.location.href=msg.redirect_url;
                                    }

                                }
                            });
                            console.log("Session updated with data: " + response.data.sessionId);
                        } else if (201 == response.statusCode) {
                            console.log("Session update failed with field errors.");

                            if (response.message) {
                                var field = response.message.indexOf('valid')
                                field = response.message.slice(field + 5, response.message.length);
                                console.log(field + " is invalid or missing.");
                            }
                            $("#paymentForm").removeClass('loading')
                            $(".errorMessage").html('<div class="alert alert-'+(response.statusCode==200?'success':'danger')+'">'+response.message+'</div>')
                            animateCSS('.errorMessage','bounce').then(function(){
                                setTimeout(function(){
                                    animateCSS('.errorMessage','flipOutX').then(()=>$(".errorMessage").html(''));
                                },2000)
                            });
                        } else {
                            console.log("Session update failed: " + response);
                            $("#paymentForm").removeClass('loading')
                            $(".errorMessage").html('<div class="alert alert-'+(response.statusCode==200?'success':'danger')+'">'+response.message+'</div>')
                            animateCSS('.errorMessage','bounce').then(function(){
                                setTimeout(function(){
                                    animateCSS('.errorMessage','flipOutX').then(()=>$(".errorMessage").html(''));
                                },2000)
                            });
                        }
                    }

                }
            }
        });

    }else{
        alert('Fail to get app/session/script !\n\nPlease check if your appId added in session script tag in head section?')
    }
    @endif
    $(document).on('click','#payButton',function(){
        if($('#payButton').attr('disabled')==undefined){
            $("#paymentForm").addClass('loading')
            $(this).attr('disabled','disabled');
            @if(env('SELECTED_PAYMENT')=='stripe')
            $("#paymentForm").addClass('loading')
            $.ajax({
                type: "POST",
                url: "{{ route('book_redirect',$session->id) }}",
                data: {cardNumber:$("#cardNumber").val(),cardMonth:$("#cardMonth").val(),cardYear:$("#cardYear").val(),cardCVC:$("#cardCVC").val(),coupon:$("#coupon").val(),mobile:$("#mobile").val(),_token:token},
                success: function (msg) {
                    $("#paymentForm").removeClass('loading');
                    $(".errorMessage").html('<div class="alert alert-'+(msg.success?'success':'danger')+'">'+msg.message+'</div>')
                    animateCSS('.errorMessage','bounce').then(function(){
                        setTimeout(function(){
                            animateCSS('.errorMessage','flipOutX').then(()=>$(".errorMessage").html(''));
                        },2000)
                    });
                    if(msg.redirect_url){
                        window.location.href=msg.redirect_url;
                    }

                }
            });
            @else
            PaymentSession.updateSessionFromForm();
            @endif
        }
    });
</script>
<script type="text/javascript">
    var token= '{{ csrf_token() }}';
    var animateCSS = (element, animation, prefix = 'animate__') =>
        // We create a Promise and return it
        new Promise((resolve, reject) => {
            const animationName = `${prefix}${animation}`;
            const node = document.querySelector(element);

            node.classList.add(`${prefix}animated`, animationName);

            // When the animation ends, we clean the classes and resolve the Promise
            function handleAnimationEnd(event) {
                event.stopPropagation();
                node.classList.remove(`${prefix}animated`, animationName);
                resolve('Animation ended');
            }

            node.addEventListener('animationend', handleAnimationEnd, {once: true});
        });



    /*$("#paymentForm").validate({
        errorPlacement: function(error, element) {
            console.log('error')
            console.log(error)
            console.log(element)
            console.log(element.attr( "id" ))

            $( element )
                .closest( "form" )
                .find( "label[for='error-" + element.attr( "id" ) + "']" )
                .append( error );
        },
        errorElement: "span",
        rules : {
            cardNumber : {
                required:true,
            },
            cardMonth : {
                required:true,
            },
            cardYear : {
                required:true,
            },
            cardCVC : {
                required:true,
            },

        },
        submitHandler: function (form) {
            $("#paymentForm").addClass('loading')
            PaymentSession.updateSessionFromForm();
        }
    });*/
    // function pay() {
    //     // UPDATE THE SESSION WITH THE INPUT FROM HOSTED FIELDS
    //     PaymentSession.updateSessionFromForm();
    // }


    $("#coupon").on('keyup', function(){

        var coupon = $("#coupon").val();
        var id = "{{$session->id}}";



        $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

     
            $.ajax({
                type: "post",
                cache: false,
                url: "{{ route('applyCoupon') }}",
                data:  {'coupon': coupon, 'id': id},
                beforeSend:function(){
                    $("#coupon_message").html(' انتظر قليلا , جاري تطبيق الكوبون ...... ');
                },
                success:function(response){
                   if(coupon == '')
                   {
                    $("#coupon_message").removeClass(response.class);
                    $("#coupon_message").removeClass('alert-success');
                    $("#coupon_message").html('');
                    $(".neweprice").html(response.amount)
                   }
                   else
                   {
                    if(response.success == true)
                    {
                        $("#coupon_message").addClass('alert-success');
                        $("#coupon_message").removeClass('alert-danger');
                        $("#coupon_message").html(response.message);
                        $(".neweprice").html(response.amount)
                    }
                    else
                    {
                        $("#coupon_message").addClass('alert-danger');
                        $("#coupon_message").removeClass('alert-success');
                        $("#coupon_message").html(response.message);
                        $(".neweprice").html(response.amount)
                    }

                   } 
                   
                },
                error:function(xhr){
                   

                }
            });

        

        



    });


</script>
</body>
</html>
