@extends('layouts.site')
@section('meta_tags')
    <title>{{ $pagetitle }}</title>

    <meta name="description" content="{{ strip_tags($pagedescripetion) }}" />
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ config('app.name', 'New Life') }} | {{ $pagetitle }}">
    <meta itemprop="description" content="{{ strip_tags($pagedescripetion) }}">
    <meta itemprop="image" content="{{asset('assets/img/logo.png')}}">
    <!-- Twitter Card data -->
    <meta name="twitter:card" content="{{ config('app.name', 'New Life') }} | {{ $pagetitle }}">
    <meta name="twitter:site" content="@{{ config('app.name', 'New Life') }} | {{ $pagetitle }}">
    <meta name="twitter:title" content="{{ config('app.name', 'New Life') }} | {{ $pagedescripetion }}">
    <meta name="twitter:description" content="{{ strip_tags($pagedescripetion) }}">
    <meta name="twitter:image" content="{{asset('assets/img/logo.png')}}">
    <!-- Open Graph data -->
    <meta property="og:title" content="{{ config('app.name', 'New Life') }} | {{ $pagetitle }}" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="{{ Request::fullUrl() }}" />
    <meta property="og:image" content="{{asset('assets/img/logo.png')}}" />
    <meta property="og:description" content="{{ strip_tags($pagedescripetion) }}" />
    <meta name="keywords" content="{{$data->meta_keywords}}">
    <style>
        .hidden{
            display:none!important;
        }
        .lgx-blog-single .lgx-card-single section
        {
            width: 100% !important;
        }
    </style>
@endsection
@section('content')
    <section @if(config('app.locale')) style="direction:rtl" @endif>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-4">
                                    @if($data->id!=4)
                                    <h2 class="lgx-heading lgx-heading-brand  mt-2">
                                        <span class="heading">{{  config('app.locale') == "ar" ?  $data->title_ar : $data->title_en }}</span>
                                    </h2>
                                    @endif
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>
    @if($data->id==4)
        <section @if(config('app.locale')) style="direction:rtl" @endif>
            <div class="lgx-about">
                <div class="lgx-inner">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12">
                                <!--<h2 class="lgx-about-title">What About World Digital Conference 2019</h2>-->
                                <div class="lgx-heading-area">
                                    <h2 class="lgx-heading">
                                        {{--<span class="back-heading" style="font-size: 8rem;"><i class="fa fa-info-circle" aria-hidden="true"></i></span>--}}
                                        <span class="heading">{{ config('app.locale') == "ar" ?  $data->title_ar : $data->title_en }}</span>
                                    </h2>
                                </div>
                            </div>
                        </div>
                        <!--//.ROW-->
                    </div>
                    <!-- //.CONTAINER -->
                </div>
                <!-- //.INNER -->
            </div>
        </section>
    @endif
    <section @if(config('app.locale')) style="direction:rtl" @endif>

        <div class="lgx-blog lgx-blog-single">
            <div class="lgx-inner">
                <div class="container">
                    <div class="blog-area">
                        <div class="row">
                            <div class="col-12 col-xs-12">
                                <article class="lgx-card-single lgx-heading py-3">
                                    @if($data->id!=4)
                                    <header>
                                        <div class="text-area mx-3 p-3">
                                        </div>
                                    </header>
                                    @endif
                                    <section @if(config('app.locale')) style="direction:rtl" @endif>
                                        {!! config('app.locale') == "ar" ? $data->body_ar : $data->body_en !!}
                                    </section>
                                    <footer>
                                    </footer>
                                </article>
                            </div>
                        </div>
                    </div>
                </div><!-- //.CONTAINER -->

            </div><!-- //.INNER -->

        </div>
    </section>
@endsection
@section('scriptSection')
    <script>

        $(document).ready(function(){
            $(document).on('click','#loadMore',function(e){
                $("#loader").removeClass('hidden');
                $("#loadMore").addClass('hidden')
                e.preventDefault();
                skip=$(".blog-area .lgx-card-single").length;
                $.ajax({
                    type: "GET",
                    url: "{{ route('get_more_blog') }}",
                    data: {"skip": skip},
                    success: function (msg) {
                        if(msg.success){
                            if(msg.html.length){
                                $(".blog-area .row").append(msg.html);
                                $("#loadMore").removeClass('hidden')
                            }else{
                                $("#loadMore").remove();
                            }

                        }
                        $("#loader").addClass('hidden');
                    }
                });
            });
        })
    </script>
@endsection
