@extends('layouts.site_payment')
@section('headScript')
    <!-- INCLUDE SESSION.JS JAVASCRIPT LIBRARY -->
    <script src="https://api.vapulus.com:1338/app/session/script?appId=442856a6-6ba1-4c22-a3b4-339b58d1a72e"></script>
    <!-- APPLY CLICK-JACKING STYLING AND HIDE CONTENTS OF THE PAGE -->
    <style id="antiClickjack">
        body {
            display: none !important;
        }
    </style>
    <style>
        .credit-cart-h{
            background: #db68fc;
            color: white;
            padding-top: 10px;
            padding-bottom: 10px;
            font-size: 20px;
        }
        #paymentForm button{
            font-size: 16px;
            font-weight: bold;
        }
        #paymentForm .form-control{
            height: 35px;
            width: 100%;
        }
    </style>
@endsection
@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area">
                                    <h2 class="lgx-heading lgx-heading-brand">
                                        <span class="back-heading"><i class="fa fa-map-marker" aria-hidden="true"></i></span>
                                        <span class="heading">{{trans('home.payment-method')}}</span>
                                    </h2>
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('home.payment-method')}}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>


    <section>
        <div class="lgx-schedule">
            <div class="container-fluid">
                <div class="row justify-content-center lgx-inner">
                    <div class="col-md-6">

                        <div class="align-items-center pt-3 boxing">
                            <div class="text-center p-3">
                                <h4 class="credit-cart-h">
                                    <i class="fas fa-credit-card mr-2"></i>
                                    @lang('home.Credit Card')
                                </h4>
                            </div>
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div id="paymentForm" class="col align-self-center">

                                <div class="form-group">
                                    <label for="cardNumber">@lang('home.Card number'):</label>
                                    <input type="text" id="cardNumber" class="form-control input-md" value="" readonly />
                                </div>
                                <div class="form-group">
                                    <label for="cardMonth">@lang('home.Expiry month'):</label>
                                    <input type="text" id="cardMonth" class="form-control input-md" value="" />
                                </div>
                                <div class="form-group">
                                    <label for="cardYear">@lang('home.Expiry year'):</label>
                                    <input type="text" id="cardYear" class="form-control input-md" value="" />
                                </div>
                                <div class="form-group">
                                    <label for="cardCVC">@lang('home.Security code'):</label>
                                    <input type="text" id="cardCVC" class="form-control input-md" value="" readonly />
                                </div>
                                <button class="btn btn-primary btn-block" id="payButton" onclick="pay();">@lang('home.Pay')</button>
                                <div class="clearfix" style="height: 20px;"></div>


                            </div>

                        </div>

                    </div>
                </div>
            </div>
        </div>

    </section>
@endsection
@section('scriptSection')
    <script type="text/javascript">
        if(window.PaymentSession){
            PaymentSession.configure({
                fields: {
                    // ATTACH HOSTED FIELDS IDS TO YOUR PAYMENT PAGE FOR A CREDIT CARD
                    card: {
                        cardNumber: "cardNumber",
                        securityCode: "cardCVC",
                        expiryMonth: "cardMonth",
                        expiryYear: "cardYear"
                    }
                },
                callbacks: {
                    initialized: function (err, response) {
                        console.log("init....");
                        console.log(err, response);
                        console.log("/init.....");
                        // HANDLE INITIALIZATION RESPONSE
                    },
                    formSessionUpdate: function (err,response) {
                        console.log("update callback.....");
                        console.log(err,response);
                        console.log("/update callback....");

                        // HANDLE RESPONSE FOR UPDATE SESSION
                        if (response.statusCode) {
                            if (200 == response.statusCode) {
                                console.log("Session updated with data: " + response.data.sessionId);
                            } else if (201 == response.statusCode) {
                                console.log("Session update failed with field errors.");

                                if (response.message) {
                                    var field = response.message.indexOf('valid')
                                    field = response.message.slice(field + 5, response.message.length);
                                    console.log(field + " is invalid or missing.");
                                }
                            } else {
                                console.log("Session update failed: " + response);
                            }
                        }
                    }
                }
            });
        }else{
            alert('Fail to get app/session/script !\n\nPlease check if your appId added in session script tag in head section?')
        }

        function pay() {
            // UPDATE THE SESSION WITH THE INPUT FROM HOSTED FIELDS
            PaymentSession.updateSessionFromForm();
        }
    </script>
@endsection
