@extends('layouts.site')

@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        @if(config('app.locale') == "ar")
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            <li class="active"> {{trans('home.psychological-test')}}</li>
                                        @else
                                            <li class="active"> {{trans('home.psychological-test')}}</li>
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <section class="header-extradiv" id="infoSection">
        <div class="container">
            <div class="container headings text-center mb-5">
                <h3 class="text-center font-weight-bold"> {{ $PsyQuestions->name_ar }} </h3>
            </div>
            <div class="row">
                <div class="information col-lg-5 col-md-5 offset-1 col-12 p-2 mb-5">
                    <h2 class="@if(app()->getLocale()=='ar') text-right @else  text-left @endif  text-success"> {{ trans('home.instructions') }} </h2>
                    <p>
                        {{ $PsyQuestions->instructions_ar }}
                    </p>
                </div>
                <div class="information col-lg-5 col-md-5 col-12 p-2 mb-5">
                    <h2 class="@if(app()->getLocale()=='ar') text-right @else  text-left @endif text-danger"> {{ trans('home.disclaimer') }}  </h2>
                    <p>
                        {{ $PsyQuestions->note_ar }}
                    </p>
                </div>

            </div>
        </div>
    </section>

    <section class="questionTest mt-5" id="questionTest">
        <div class="container">
            <div class="card">
                <div class="card-header text-center ">
                    <h4 class="mt-4">@lang('home.Please read the contents of the download and make sure that the packages apply to you in')
                        <span>@lang('home.The past two weeks')</span></h4>
                </div>
                <div class="card-body text-center">
                    <!-- insert-counseling-married -->
                    @if($scaleEmail->message)
                    <div class="alert alert-info">
                        {{-- $scaleEmail->message --}}
                         @lang('home.Psychologicalresult')
                    </div>
                    @endif
                    @if($PsyQuestions->type=='with_type')
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                <tr>
                                    <td>#</td>
                                    <td>ذكر</td>
                                    <td>انثي</td>
                                </tr>
                                @if($scaleEmail->sum_points_p>6.45||$scaleEmail->sum_points_p>5.28)
                                <tr>
                                    <th>
                                        Psychoticism
                                        الذهانية
                                    </th>
                                    <th>
                                    @if($scaleEmail->sum_points_p>6.45)
                                            لديك درجة عالية على سمة الذهانية
                                    @endif
                                    </th>
                                    <th>
                                        @if($scaleEmail->sum_points_p>5.28)
                                            لديك درجة عالية على سمة الذهانية
                                        @endif
                                    </th>

                                </tr>
                                @endif
                                @if($scaleEmail->sum_points_n>16.86||$scaleEmail->sum_points_n>18.77)
                                <tr>
                                    <th>
                                        Neuroticism
                                        العصابية

                                    </th>
                                    <th>
                                        @if($scaleEmail->sum_points_n>16.86)
                                            لديك درجة عالية على سمة العصابية
                                        @endif
                                    </th>
                                    <th>
                                        @if($scaleEmail->sum_points_n>18.77)
                                            لديك درجة عالية على سمة العصابية
                                        @endif
                                    </th>
                                </tr>
                                @endif
                                @if($scaleEmail->sum_points_e>16.59||$scaleEmail->sum_points_e<8.81||$scaleEmail->sum_points_e>16.03||$scaleEmail->sum_points_e<8.09)
                                <tr>
                                    <th>
                                        Extraversion
                                        الانبساطية

                                    </th>
                                    <th>
                                        @if($scaleEmail->sum_points_e>16.59)
                                            لديك درجة عالية على سمة الانبساطية
                                        @endif
                                        @if($scaleEmail->sum_points_e<8.81)
                                            لديك درجة عالية على سمة الانطوائية
                                        @endif
                                    </th>
                                    <th>
                                        @if($scaleEmail->sum_points_e>16.03)
                                            لديك درجة عالية على سمة الانبساطية
                                        @endif
                                        @if($scaleEmail->sum_points_e<8.09)
                                                لديك درجة عالية على سمة الانطوائية
                                        @endif
                                    </th>
                                </tr>
                                @endif
                                @if($scaleEmail->sum_points_l>19.77||$scaleEmail->sum_points_l>20.94)
                                <tr>
                                    <th>
                                        Lie
                                        الكذب
                                    </th>
                                    <th>
                                        @if($scaleEmail->sum_points_l>19.77)
                                            لديك درجة عالية على سمة الكذب (كميل مرتفع لتزييف الإجابات من أجل الظهور بمظهر جذاب احتماعيا)
                                        @endif

                                    </th>
                                    <th>
                                        @if($scaleEmail->sum_points_l>20.94)
                                            لديك درجة عالية على سمة الكذب (كميل مرتفع لتزييف الإجابات من أجل الظهور بمظهر جذاب احتماعيا)
                                        @endif

                                    </th>
                                </tr>
                                @endif
                                </thead>
                            </table>
                        </div>
                    @endif
                    <div class="text-center">
                        <a class="btn btn-success" href="{{ route('scale-questions',['id'=>$PsyQuestions->id]) }}">@lang('home.exam again')</a>
                    </div>

                </div>
            </div>
        </div>
    </section>
@endsection

@section('scriptSection')
    <script>

    </script>
@endsection
