@extends('layouts.site')

@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        @if(config('app.locale') == "ar")
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            <li class="active"> {{trans('home.psychological-test')}}</li>
                                        @else
                                            <li class="active"> {{trans('home.psychological-test')}}</li>
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <section class="header-extradiv" id="infoSection">
        <div class="container">
            <div class="container headings text-center mb-5">
                <h3 class="text-center font-weight-bold"> {{ $PsyQuestions->name_ar }} </h3>
            </div>
            <div class="row">
                        <div class="information col-lg-5 col-md-5 offset-1 col-12 p-2 mb-5">
                            <h2 class="@if(app()->getLocale()=='ar') text-right @else  text-left @endif  text-success"> {{ trans('home.instructions') }} </h2>
                            <p>
                                {{ $PsyQuestions->instructions_ar }}
                            </p>
                        </div>
                        <div class="information col-lg-5 col-md-5 col-12 p-2 mb-5">
                            <h2 class="@if(app()->getLocale()=='ar') text-right @else  text-left @endif text-danger"> {{ trans('home.disclaimer') }}  </h2>
                            <p>
                                {{ $PsyQuestions->note_ar }}
                            </p>
                        </div>

            </div>
        </div>
    </section>

    <section class="questionTest mt-5" id="questionTest">
        <div class="container">
                <div class="card">
                    <div class="card-header text-center ">
                        <h4 class="mt-4">@lang('home.Please read the contents of the download and make sure that the packages apply to you in')
                        <span>@lang('home.The past two weeks')</span></h4>
                    </div>
                    <div class="card-body text-center">
                        <!-- insert-counseling-married -->
                        <form method="POST"  id="recomm-form" action="{{ route('Insert-PsychologicalQuestions') }}" data-parsley-validate="" class="col align-self-center px-5 py-4" style="margin-bottom: 24px;">
                            @csrf

                            <!-- PsyQuestionsWithAnswers -->
                            @include('therapists.include.questionTest')
                                <div class="form-row dynamic-align d-none">
                                    <div class="col-md-12 mt-3">
                                        <h4 class="@if(app()->getLocale()=='ar') text-right @else text-left @endif mx-3" for="validationDefault01" ><strong> {{ trans('auth.email')  }}</strong> </h4>
                                        <div class="form-group mt-4 px-3">
                                            <div class="input-group">
                                                <input id="userEmail" type="email"  class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{trans('auth.enter-email')}}">
                                                {{--<div class="input-group-prepend">
                                                    <button type="button" data-step="1" class="btn btn-success goNext">@lang('home.start_now')</button>
                                                </div>--}}
                                            </div>
                                            <label for="error-userEmail"></label>
                                            @error('email')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                        </div>
                                        <div class="col-md-12">
                                            <button id="sendRequest" type="submit" disabled class="lgx-btn mb-4 w-25">
                                                {{ trans('home.send') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            {{--<div class="form-row dynamic-align d-none">
                                <div class="col-md-12">
                                    <button type="submit" class="lgx-btn mb-4 w-25">
                                        {{ trans('home.send') }}
                                    </button>
                                </div>
                            </div>--}}
                        </form>
                    </div>
                    <div class="card-footer">
                            <nav id="paginate-recommendation" class="table-responsive" aria-label="Page navigation example">
                                <ul class="pagination my-3 d-flex justify-content-start"  id="myList">
                                    @for($x=1;$x<=$PsyCount+1;$x++)
                                        <li class="page-item step-{{ $x }} disabled"><a data-step="{{ $x-1 }}" class="page-link change-step" href="#">{{ $x }}</a></li>
                                    @endfor
                                </ul>
                            </nav>
                    </div>
                </div>
        </div>
    </section>
@endsection

@section('scriptSection')
    <script>
        function validateEmail($email) {
            var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
            return emailReg.test( $email );
        }
        $(document).ready(function(){
            $(document).on('keydown','#userEmail',function(event){
                if(event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
            $(document).on('keyup','#userEmail',function(e){
                userEmail=$(this);
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    userEmail.removeClass('is-invalid')
                    $("#sendRequest").removeAttr('disabled');
                    $("label[for='error-userEmail']").html('');
                    if(e.keyCode==13){
                        $('.goNext').trigger('click');
                    }
                }else{
                    userEmail.addClass('is-invalid');
                    if(userEmail.val()){
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.email_valid_field')</span>');
                    }else{
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.required_field')</span>');
                    }
                }

            });
            function goToStep(step){
                if($("#recomm-form .form-row").eq(step).length){
                    $("#recomm-form .form-row").addClass('d-none')
                    $("#recomm-form .form-row").eq(step).removeClass('d-none');
                    $(".card-footer #paginate-recommendation").removeClass('d-none');
                    $(".card-footer #paginate-recommendation .pagination li.active").removeClass('active');
                    $(".card-footer #paginate-recommendation .step-"+(parseInt(step)+1)).addClass('active');
                }
                for (i=0;i<=step;i++){
                    $(".card-footer #paginate-recommendation .pagination li").eq(i).removeClass('disabled');
                }
            }
            $(document).on('click','.goNext',function(){
                userEmail=$("#userEmail")
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    step=$(this).attr('data-step');
                    console.log(step);
                    goToStep(step)
                }else{
                    userEmail.addClass('is-invalid')
                }
            });
            $(document).on('click','.change-step',function(e){
                e.preventDefault();
                step=$(this).attr('data-step');
                goToStep(step)
            })
            $(document).on('change','#recomm-form .form-row input[type="radio"]',function(){
                step=$("#recomm-form .form-row:not(.d-none)").index();
                goToStep(step)
            });
        });
    </script>
@endsection
