@extends('layouts.site')

@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        @if(config('app.locale') == "ar")
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            <li class="active"> {{trans('home.psychological-test')}}</li>
                                        @else
                                            <li class="active"> {{trans('home.psychological-test')}}</li>
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <section class="psychological_section">
        <div class="container">
            <div class="row">
                <div class="col-sm-6">
                    <div class="lgx-heading-area mt-5">
                        <h4 class="font-weight-bold  mt-5"> {{ trans('home.psychological_description') }}  </h4>
                           <div  class="psychological-icon text-white fz16 mt20 mb20 mt-5">
                               {{trans('home.all-tests')}}
                               <span  class="ml32 mx-3">
                                   <i  class="fa fa-check-circle mr4 fz12 mr5"></i>
                                   {{ trans('home.scientific') }}
                               </span>
                               <span  class="ml32 mx-3">
                                   <i  class="fa fa-check-circle mr4 fz12 mr5"></i>
                                    {{ trans('home.supported') }}
                               </span>
                               <span  class="ml32 mx-3">
                                   <i  class="fa fa-check-circle mr4 fz12 mr5"></i>
                                    {{ trans('home.trusted') }}
                               </span>
                           </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <img class="img-responsive" src="{{asset('images/boy__.png')}}" style="width: 100%;">
                </div>
            </div>
        </div>
    </section>

    <section class="psychological_question">
        <div class="container">
            <div class="row">
                <div class="col-md-9">
                    <table class="table table-striped">
                        <thead>
                        <tr id="table-tr">
                            <th>{{ trans('home.test-name') }}</th>
                            <th>{{ trans('home.recommendations') }}</th>
                            <th>{{ trans('home.test-period') }}</th>
                            <th>{{ trans('home.free') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($TypeQuestions as $type)
                            <tr>
                                <td>
                                    <a href="{{route('scale-questions',$type->id)}}"> {{ $type->name_ar }} </a>
                                    <p> {{ $type->description_ar }}</p>
                                </td>
                                <td>{{ $type->nominations_ar }}</td>
                                <td> {{ $type->duration_ar }} </td>
                                <td> {{ $type->is_free == 'yes' ? trans('home.yes'):trans('home.no') }} </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="col-md-3">
                    <div class="card text-center">
                        <div class="card-header"> {{trans('home.we-care')}} </div>
                        <div class="card-body">
                            <img src="https://newhayah.com/avatars/therapists/1609090415.jpg" class="rounded-circle mb-2" alt="Cinque Terre">
                            <h6>نورهان عبد الرحمن</h6>
                            <p> اخصائي نفسي </p>
                            <span class="item-rating">
                                <span class="fa fa-star text-warning"></span>
                                <span class="fa fa-star text-warning"></span>
                                <span class="fa fa-star text-warning"></span>
                                <span class="fa fa-star text-warning"></span>
                            </span>
                        </div>
                        <div class="card-footer">
                            <a href="{{route('therapistslist')}}"> {{trans('home.therapists-list')}} </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>
@endsection
