@extends('layouts.site')

@section('content')
    <style>
        @media (max-width: 767px) {
            .btn-group{
                width: 100%!important;
            }
        }
        .btn-group.btn-group-toggle .btn.btn-secondary{
            font-size: 16px
        }
        .goNext{
            font-size: 16px;
            padding: 10px 15px;
            margin-top: 0px;
            height: 42px;
            line-height: 20px
        }
        .btn-group{
            display: inline-block;
            width: 35%;
        }
        .forminput{
            margin-top: 0px;
        }
        #recomm-form .form-row.dynamic-align{
            min-height: 350px;
        }
        .header-recommendation{
            background: #f3f6f9;
            padding: 35px;
        }
        .header-recommendation p{
            color: #4d4d4f;
            font-size: 16px;
            font-weight: bold;
        }
        .header-recommendation p span{
            color: #c35cfe;
        }
    </style>
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area m-5">
                                    <h3 class="heading" style="font-size: 2rem">
                                        <span class="heading"> {{ trans('home.questions')  }} </span>
                                    </h3>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>


    <div class="lgx-schedule">
        <div class="container-fluid">
            <div class="row justify-content-center lgx-inner">
                <div class="col-md-8">
                    <div class="lgx-tab">
                        <div class="align-items-center pb-3 boxing">
                            <div class="col-12 header-recommendation">
                                <p>
                                    @lang('home.Please read the contents of the download and make sure that the packages apply to you in')
                                    <span>@lang('home.The past two weeks')</span>
                                </p>
                            </div>

                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mt-3">
                                        <h4 for="validationDefault01" ><strong> {{ trans('home.question1')  }}</strong> </h4>
                                        <div class="form-group mt-4 px-3 dynamic-align">
                                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                <label class="btn btn-secondary btn-block active">
                                                    <a href="{{ route('Counseling-married') }}" style="color:#fff">
                                                        <input type="radio" name="ans1" id="ans1" value="Counseling for those who are married" {{(old('ans1') == 'Counseling for those who are married') ? 'checked' : ''}} autocomplete="off"> {{ trans('home.Counseling-for-those-who-are-married') }}
                                                    </a>
                                                </label>

                                                <label class="btn btn-secondary btn-block">
                                                    <a href="{{ route('marital-family-problems') }}" style="color:#fff">
                                                        <input type="radio" name="ans1" id="ans1" value="Treatment of marital and family problems and divorce" {{(old('ans1') == 'Treatment of marital and family problems and divorce') ? 'checked' : ''}} autocomplete="off"> {{ trans('home.Treatment-of-marital-and-family-problems-and-divorce') }}
                                                    </a>
                                                </label>

                                                <label class="btn btn-secondary btn-block">
                                                    <a href="{{ route('children-problems') }}" style="color:#fff">
                                                        <input type="radio" name="ans1" id="ans1" value="Children problems" {{(old('ans1') == 'Children problems') ? 'checked' : ''}} autocomplete="off"> {{ trans('home.Children-problems') }}
                                                    </a>
                                                </label>

                                                <label class="btn btn-secondary btn-block">
                                                    <a href="{{ route('adolescent-psychological-problems') }}" style="color:#fff">
                                                        <input type="radio" name="ans1" id="ans1" value="Adolescent psychological problems" {{(old('ans1') == 'Adolescent psychological problems') ? 'checked' : ''}} autocomplete="off"> {{ trans('home.Adolescent-psychological-problems') }}
                                                    </a>
                                                </label>

                                                <label class="btn btn-secondary btn-block">
                                                    <a href="{{ route('developing-personal') }}" style="color:#fff">
                                                        <input type="radio" name="ans1" id="ans1" value="Developing personal and life skills" {{(old('ans1') == 'Developing personal and life skills') ? 'checked' : ''}} autocomplete="off"> {{ trans('home.Developing-personal-and-life-skills') }}
                                                    </a>
                                                </label>

                                            </div>
                                            @error('ans1')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>
                            <div class="col-12">
                                <nav id="paginate-recommendation" class="d-none" aria-label="Page navigation example">
                                    <ul class="pagination">
                                        @for($x=1;$x<=2;$x++)
                                            <li class="page-item step-{{ $x }} disabled"><a data-step="{{ $x-1 }}" class="page-link change-step" href="#">{{ $x }}</a></li>
                                        @endfor
                                    </ul>
                                </nav>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>



@endsection
@section('scriptSection')
    <script>
        function validateEmail($email) {
            var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
            return emailReg.test( $email );
        }
        $(document).ready(function(){
            $(document).on('keydown','#userEmail',function(event){
                if(event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
            $(document).on('keyup','#userEmail',function(e){
                userEmail=$(this);
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    userEmail.removeClass('is-invalid')
                    $("label[for='error-userEmail']").html('');
                    if(e.keyCode==13){
                        $('.goNext').trigger('click');
                    }
                }else{
                    userEmail.addClass('is-invalid');
                    if(userEmail.val()){
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.email_valid_field')</span>');
                    }else{
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.required_field')</span>');
                    }
                }

            });
            function goToStep(step){
                if($("#recomm-form .form-row").eq(step).length){
                    $("#recomm-form .form-row").addClass('d-none')
                    $("#recomm-form .form-row").eq(step).removeClass('d-none');
                    $("#paginate-recommendation").removeClass('d-none');
                    $("#paginate-recommendation .pagination li.active").removeClass('active');
                    $("#paginate-recommendation .step-"+(parseInt(step)+1)).addClass('active');
                }
                for (i=0;i<=step;i++){
                    $("#paginate-recommendation .pagination li").eq(i).removeClass('disabled');
                }
            }
            $(document).on('click','.goNext',function(){
                userEmail=$("#userEmail")
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    step=$(this).attr('data-step');
                    console.log(step);
                    goToStep(step)
                }else{
                    userEmail.addClass('is-invalid')
                }
            });
            $(document).on('click','.change-step',function(e){
                e.preventDefault();
                step=$(this).attr('data-step');
                goToStep(step)
            })
            $(document).on('change','#recomm-form .form-row input[type="radio"]',function(){
               step=$("#recomm-form .form-row:not(.d-none)").index();
                goToStep(step)
            });
        });
    </script>
@endsection
