@extends('layouts.site')

@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area m-5">
                                    <h3 class="heading" style="font-size: 2rem">
                                        <span class="heading"> {{ trans('home.questions')  }} </span>
                                    </h3>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>


    <div class="lgx-schedule">
        <div class="container-fluid">
            <div class="row justify-content-center lgx-inner">
                <div class="col-md-8">
                    <div class="lgx-tab">
                        <div class="align-items-center pt-3 boxing">

                            <form method="POST"  id="recomm-form" action="{{ route('insertRecommendation') }}" data-parsley-validate="" class="col align-self-center px-5 py-4" style="margin-bottom: 24px;">
                                 @csrf

                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mt-3">
                                        <h4 for="validationDefault01" ><strong> {{ trans('auth.email')  }} </h4>
                                        <div class="form-group mt-4 px-3">
                                            <input id="userEmail" type="email"  class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{trans('auth.enter-email')}}"
                                                   data-parsley-maxlength="30"
                                                   data-parsley-required="true"
                                                   data-parsley-required-message="هذا الحقل مطلوب"
                                            >
                                            @error('email')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>

                                </div>

                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mt-3">
                                        <h4 for="validationDefault01" ><strong> {{ trans('home.question1')  }} </h4>
                                        <div class="form-group mt-4 px-3 dynamic-align">
                                            @if(config('app.locale') == "en")
                                            <input type="radio"  class="mx-2" name="ans1" value="yes" {{(old('ans1') == 'yes') ? 'checked' : ''}} tabindex=1>
                                            <label class="mx-4">  <strong> {{ trans('home.yes') }} </strong></label>
                                            <br/>
                                            <input type="radio" class="mx-2" name="ans1" value="no" {{(old('ans1') == 'no') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.no') }}</strong></label>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.yes') }} </strong></label>
                                                <input type="radio"  class="mx-2" name="ans1" value="yes" {{(old('ans1') == 'yes') ? 'checked' : ''}} tabindex=1>
                                                <br/>
                                                <label class="mx-4">  <strong> {{ trans('home.no') }}</strong></label>
                                                <input type="radio" class="mx-2" name="ans1" value="no" {{(old('ans1') == 'no') ? 'checked' : ''}}>

                                            @endif
                                            @error('ans1')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>

                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question2')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                                <input type="radio" class="mx-2" name="ans2" value="most-time" tabindex=2 {{(old('ans2') == 'most-time') ? 'checked' : ''}}>
                                                <label class="mx-4">  <strong> {{ trans('home.most-time') }} </strong> </label><br/>
                                                <input type="radio" class="mx-2" name="ans2" value="alots" {{(old('ans2') == 'alots') ? 'checked' : ''}}>
                                                <label class="mx-4">  <strong> {{ trans('home.alots') }} </strong> </label><br/>
                                                <input type="radio" class="mx-2"  name="ans2" value="sometimes" {{(old('ans2') == 'sometimes') ? 'checked' : ''}}>
                                                <label class="mx-4">  <strong> {{ trans('home.sometimes') }} </strong> </label><br/>
                                                <input type="radio"  class="mx-2" name="ans2" value="no" {{(old('ans2') == 'no') ? 'checked' : ''}}>
                                                <label class="mx-4">  <strong> {{ trans('home.no') }}  </strong> </label>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.most-time') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans2" value="most-time" tabindex=2 {{(old('ans2') == 'most-time') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.alots') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans2" value="alots" {{(old('ans2') == 'alots') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.sometimes') }} </strong> </label>
                                                <input type="radio" class="mx-2"  name="ans2" value="sometimes" {{(old('ans2') == 'sometimes') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.no') }}  </strong> </label>
                                                <input type="radio"  class="mx-2" name="ans2" value="no" {{(old('ans2') == 'no') ? 'checked' : ''}}>
                                            @endif

                                            @error('ans2')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>



                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01" ><strong> {{ trans('home.question3')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio"  class="mx-2" name="ans3" value="less-than-19" tabindex=3>
                                            <label class="checkbox-inline mx-4">  <strong> {{ trans('home.less-than-19') }}  </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans3" value="19-24" {{(old('ans3') == '19-24') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.19-24') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans3" value="25-30" {{(old('ans3') == '25-30') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.25-30') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans3" value="31-36" {{(old('ans3') == '31-36') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.31-36') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans3" value="37-42" {{(old('ans3') == '37-42') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.37-42') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans3" value="43-47" {{(old('ans3') == '43-47') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.43-47') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans3" value="more-49" {{(old('ans3') == 'more-49') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.more-49') }} </strong> </label>
                                            @else
                                                <label class="checkbox-inline mx-4">  <strong> {{ trans('home.less-than-19') }}  </strong> </label>
                                                <input type="radio"  class="mx-2" name="ans3" value="less-than-19" tabindex=3><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.19-24') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans3" value="19-24" {{(old('ans3') == '19-24') ? 'checked' : ''}}><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.25-30') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans3" value="25-30" {{(old('ans3') == '25-30') ? 'checked' : ''}}><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.31-36') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans3" value="31-36" {{(old('ans3') == '31-36') ? 'checked' : ''}}><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.37-42') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans3" value="37-42" {{(old('ans3') == '37-42') ? 'checked' : ''}}><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.43-47') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans3" value="43-47" {{(old('ans3') == '43-47') ? 'checked' : ''}}><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.more-49') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans3" value="more-49" {{(old('ans3') == 'more-49') ? 'checked' : ''}}>


                                            @endif

                                            @error('ans3')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>

                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question4')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio"  class="mx-2" name="ans4" value="arabic-best" tabindex=4 {{(old('ans4') == 'arabic-best') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.arabic-best') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans4" value="arabic-with-english" {{(old('ans4') == 'arabic-with-english') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.arabic-with-english') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans4" value="arabic-with-french" {{(old('ans4') == 'arabic-with-french') ? 'checked' : ''}} >
                                            <label class="mx-4">  <strong> {{ trans('home.arabic-with-french') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans4" value="english-best" {{(old('ans4') == 'english-best') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.english-best') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans4" value="french-best" {{(old('ans4') == 'french-best') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.french-best') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans4" value="other-language" {{(old('ans4') == 'other-language') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.other-language') }} </strong> </label>
                                            @else

                                                <label class="mx-4">  <strong> {{ trans('home.arabic-best') }} </strong> </label>
                                                <input type="radio"  class="mx-2" name="ans4" value="arabic-best" tabindex=4 {{(old('ans4') == 'arabic-best') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.arabic-with-english') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans4" value="arabic-with-english" {{(old('ans4') == 'arabic-with-english') ? 'checked' : ''}}><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.arabic-with-french') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans4" value="arabic-with-french" {{(old('ans4') == 'arabic-with-french') ? 'checked' : ''}} ><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.english-best') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans4" value="english-best" {{(old('ans4') == 'english-best') ? 'checked' : ''}}><br/>

                                                <label class="mx-4">  <strong> {{ trans('home.french-best') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans4" value="french-best" {{(old('ans4') == 'french-best') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.other-language') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans4" value="other-language" {{(old('ans4') == 'other-language') ? 'checked' : ''}}>

                                            @endif

                                            @error('ans4')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>

                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question5')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio" class="mx-2" name="ans5" value="no" tabindex=5 {{(old('ans5') == 'no') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.no') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans5" value="yes" {{(old('ans5') == 'yes') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.yes') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans5" value="some-thing" {{(old('ans5') == 'some-thing') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.some-thing') }} </strong> </label>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.no') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans5" value="no" tabindex=5 {{(old('ans5') == 'no') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.yes') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans5" value="yes" {{(old('ans5') == 'yes') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.some-thing') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans5" value="some-thing" {{(old('ans5') == 'some-thing') ? 'checked' : ''}}>

                                             @endif
                                            @error('ans5')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>


                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question6')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio" class="mx-2" name="ans6" value="yes" tabindex=6 {{(old('ans6') == 'yes') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.yes') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans6" value="no" {{(old('ans6') == 'no') ? 'checked' : ''}}>
                                            <label class="mx-4">  <strong> {{ trans('home.no') }} </strong> </label>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.yes') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans6" value="yes" tabindex=6 {{(old('ans6') == 'yes') ? 'checked' : ''}}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.no') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans6" value="no" {{(old('ans6') == 'no') ? 'checked' : ''}}>
                                            @endif

                                            @error('ans6')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror

                                        </div>
                                    </div>
                                </div>



                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question7')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio" class="mx-2" name="ans7" value="as-soon-as-possible" tabindex=7 {{ (old('ans7') == 'as-soon-as-possible') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.as-soon-as-possible') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans7" value="next-few-days" {{ (old('ans7') == 'next-few-days') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.next-few-days') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans7" value="no-particular-preference" {{ (old('ans7') == 'no-particular-preference') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.no-particular-preference') }} </strong> </label>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.as-soon-as-possible') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans7" value="as-soon-as-possible" tabindex=7 {{ (old('ans7') == 'as-soon-as-possible') ? 'checked' : '' }}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.next-few-days') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans7" value="next-few-days" {{ (old('ans7') == 'next-few-days') ? 'checked' : '' }}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.no-particular-preference') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans7" value="no-particular-preference" {{ (old('ans7') == 'no-particular-preference') ? 'checked' : '' }}>
                                                @endif

                                            @error('ans7')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror



                                        </div>
                                    </div>
                                </div>


                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question8')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio" class="mx-2" name="ans8" value="reasonable-budget" {{ (old('ans8') == 'reasonable-budget') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.reasonable-budget') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans8" value="above-average-budget" {{ (old('ans8') == 'above-average-budget') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.above-average-budget') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans8" value="high-budget"  {{ (old('ans8') == 'high-budget') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.high-budget') }} </strong></label>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.reasonable-budget') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans8" value="reasonable-budget" {{ (old('ans8') == 'reasonable-budget') ? 'checked' : '' }}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.above-average-budget') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans8" value="above-average-budget" {{ (old('ans8') == 'above-average-budget') ? 'checked' : '' }}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.high-budget') }} </strong></label>
                                                <input type="radio" class="mx-2" name="ans8" value="high-budget"  {{ (old('ans8') == 'high-budget') ? 'checked' : '' }}>


                                            @endif
                                            @error('ans8')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror


                                        </div>
                                    </div>
                                </div>




                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question9')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio" class="mx-2" name="ans9" value="male"  tabindex=9 {{ (old('ans9') == 'male') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.male') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans9" value="female" {{ (old('ans9') == 'female') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.female') }} </strong> </label><br/>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.male') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans9" value="male"  tabindex=9 {{ (old('ans9') == 'male') ? 'checked' : '' }}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.female') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans9" value="female" {{ (old('ans9') == 'female') ? 'checked' : '' }}>
                                                @endif

                                            @error('ans9')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror


                                        </div>
                                    </div>
                                </div>


                                <div class="form-row dynamic-align">
                                    <div class="col-md-12 mb-3">
                                        <h5 for="validationDefault01"><strong> {{ trans('home.question10')  }}</h5>
                                        <div class="form-group mt-4 px-3">
                                            @if(config('app.locale') == "en")
                                            <input type="radio" class="mx-2" name="ans10" value="male"  tabindex=10 {{ (old('ans10') == 'male') ? 'checked' : '' }} >
                                            <label class="mx-4">  <strong> {{ trans('home.male') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans10" value="female" {{ (old('ans10') == 'female') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.female') }} </strong> </label><br/>
                                            <input type="radio" class="mx-2" name="ans10" value="no-prefer" {{ (old('ans10') == 'no-prefer') ? 'checked' : '' }}>
                                            <label class="mx-4">  <strong> {{ trans('home.no-prefer') }} </strong> </label>
                                            @else
                                                <label class="mx-4">  <strong> {{ trans('home.male') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans10" value="male"  tabindex=10 {{ (old('ans10') == 'male') ? 'checked' : '' }} ><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.female') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans10" value="female" {{ (old('ans10') == 'female') ? 'checked' : '' }}><br/>
                                                <label class="mx-4">  <strong> {{ trans('home.no-prefer') }} </strong> </label>
                                                <input type="radio" class="mx-2" name="ans10" value="no-prefer" {{ (old('ans10') == 'no-prefer') ? 'checked' : '' }}>
                                             @endif

                                            @error('ans10')
                                            <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror


                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12">
                                        <button type="submit" class="lgx-btn mb-4 w-25">
                                            {{ trans('home.send') }}
                                        </button>
                                    </div>
                                </div>



                            </form>



                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>



@endsection
