@extends('layouts.site')
@section('meta_tags')
    <title>{{ config('app.name', 'New Life') }} | {{ app()->getLocale()=='ar' ? $blog->title : $blog->title_en }}</title>

    <meta name="description" content="{{ strip_tags(app()->getLocale()=='ar' ? $blog->description : $blog->description_en) }}" />
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ config('app.name', 'New Life') }} | {{ app()->getLocale()=='ar' ? $blog->title : $blog->title_en }}">
    <meta itemprop="description" content="{{ strip_tags(app()->getLocale()=='ar' ? $blog->description : $blog->description_en) }}">
    <meta itemprop="image" content="{{asset($blog->picture)}}">
    <!-- Twitter Card data -->
    <meta name="twitter:card" content="{{ config('app.name', 'New Life') }} | {{ app()->getLocale()=='ar' ? $blog->title : $blog->title_en }}">
    <meta name="twitter:site" content="@{{ config('app.name', 'New Life') }} | {{ app()->getLocale()=='ar' ? $blog->title : $blog->title_en }}">
    <meta name="twitter:title" content="{{ config('app.name', 'New Life') }} | {{ app()->getLocale()=='ar' ? $blog->title : $blog->title_en }}">
    <meta name="twitter:description" content="{{ strip_tags(app()->getLocale()=='ar' ? $blog->description : $blog->description_en) }} ">
    <meta name="twitter:image" content="{{asset($blog->picture)}}">
    <!-- Open Graph data -->
    <meta property="og:title" content="{{ config('app.name', 'New Life') }} | {{ app()->getLocale()=='ar' ? $blog->title : $blog->title_en }}" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="{{ Request::fullUrl() }}" />
    <meta property="og:image" content="{{asset($blog->picture)}}" />
    <meta property="og:description" content="{{ strip_tags(app()->getLocale()=='ar' ? $blog->description : $blog->description_en) }}" />
    <style>
        .hidden{
            display:none!important;
        }
        .blog-desc p{
            text-align: justify;
            line-height: 40px;
        }

    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-5">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{ trans('home.home') }}</a></li>
                                        <li><a href="{{ route('blog') }}"><i class="icon-home6"></i>{{ trans('home.blog') }}</a></li>
                                        <li class="active">{{ \Illuminate\Support\Str::limit(app()->getLocale()=='ar' ? $blog->title : $blog->title_en,20) }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <section>
        <div class="lgx-blog lgx-blog-single">
            <div class="lgx-inner">
                <div class="container">
                    <div class="blog-area">
                        <div class="row">
                            <div class="col-xs-12">
                                <article class="lgx-card-single px-4">
                                    <header class="text-center row">
                                        {{--<figure>
                                            <a class="" href="#"><img style="width: 70%"  src="{{asset($blog->picture)}}" alt="{{$blog->title}}"/></a>
                                        </figure>--}}
                                        <div class="col-4">
                                            <img src="{{asset($blog->picture)}}" alt="{{app()->getLocale()=='ar' ? $blog->title : $blog->title_en}}"/>
                                        </div>
                                        <div class="text-area col-8">
                                            <h1 class="title">{{ app()->getLocale()=='ar' ? $blog->title : $blog->title_en}}</h1>
                                            <div class="hits-area">
                                                <span class="date">{{$blog->created_at->format('d F Y')}}</span>
                                            </div>
                                        </div>

                                    </header>
                                    <section class="blog-desc">
                                        {!! app()->getLocale()=='ar' ? $blog->description : $blog->description_en !!}
                                    </section>
                                    <footer>
{{--                                        <h4 class="title">{{ trans('home.share') }}</h4>--}}
{{--                                        <div class="lgx-share">--}}
{{--                                            <ul class="list-inline ">--}}
{{--                                                <li><a target="_blank" href="https://twitter.com/share?url={{ Request::fullUrl() }}"><i class="fab fa-twitter" aria-hidden="true"></i></a></li>--}}
{{--                                                <li><a target="_blank" href="http://www.facebook.com/sharer.php?u={{ Request::fullUrl() }}"><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>--}}
{{--                                                <li><a target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{ Request::fullUrl() }}"><i class="fab fa-linkedin" aria-hidden="true"></i></a></li>--}}

{{--                                            </ul>--}}
{{--                                        </div>--}}
                                    </footer>
                                </article>
                            </div>
                        </div>
                    </div>
                </div><!-- //.CONTAINER -->

            </div><!-- //.INNER -->

        </div>
    </section>
@endsection
@section('scriptSection')
    <script>
        $(document).ready(function(){
            $(document).on('click','#loadMore',function(e){
                $("#loader").removeClass('hidden');
                $("#loadMore").addClass('hidden')
                e.preventDefault();
                skip=$(".blog-area .lgx-card-single").length;
                $.ajax({
                    type: "GET",
                    url: "{{ route('get_more_blog') }}",
                    data: {"skip": skip},
                    success: function (msg) {
                        if(msg.success){
                            if(msg.html.length){
                                $(".blog-area .row").append(msg.html);
                                $("#loadMore").removeClass('hidden')
                            }else{
                                $("#loadMore").remove();
                            }

                        }
                        $("#loader").addClass('hidden');
                    }
                });
            });
        })
    </script>
@endsection
