@extends('layouts.site')
@section('headScript')
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        .daterange-filter {
            background: none repeat scroll 0 0 #FFFFFF;
            border: 1px solid #CCCCCC;
            cursor: pointer;
            padding: 5px 10px;
        }
    </style>
    <style>
        .bootstrap-datetimepicker-widget.dropdown-menu{
            font-size: 1.3rem!important;
        }
        .bootstrap-datetimepicker-widget ul.list-unstyled{
            padding-right: 0;
        }
        table.table-condensed tr td button.btn.btn-primary[data-action="togglePeriod"]{
            position: relative;
            left: -28px;
        }
        .timepicker .timepicker-picker table.table-condensed{
            direction: ltr;
            position: relative;
            left: 35px;
        }
        .table-condensed .fa.fa-clock-o{
            font-size: 15px;
        }
        .ui-dialog.ui-corner-all.ui-widget{
            padding: 0;
        }
        .ui-widget-header {
            border: 1px solid #dfb3ff;
            background: #73bffe;
            color: #ffffff;
            font-weight: bold;
        }
        .ui-button-icon-only.ui-dialog-titlebar-close{
            border-color: #b4b4b4;
            background: #ffffff;
            border-radius: 50%;
        }
        .nav-tabs .nav-link, .nav-tabs .nav-link:hover{
            border: none;
            border-bottom: 1px solid transparent;
            font-size: 15px;
            font-weight: bold;
        }
        .nav-tabs .nav-link.active{
            border-color:#b959fe;
        }
        .save-data, .save-schedule-data{
            border-radius: 18px;
            padding: 8px 30px 8px 30px;
            font-size: 15px!important;
        }
        .ui-dialog-title{
            font-size: 20px;
        }
        input[type='text']{
            height: 38px!important;
        }
        .hours-minutes .bootstrap-datetimepicker-widget table td i{
            width: 20px!important;
            height: 20px!important;
            line-height: 20px!important;
        }

        .hours-minutes table td {
            height: 30px;
            line-height: 30px;
            width: 30px;
        }
        .hours-minutes .bootstrap-datetimepicker-widget table td{
            padding:0px;
        }
        .hours-minutes .bootstrap-datetimepicker-widget table td span{
            height: 40px;
            line-height: 40px;
        }
        .hours-minutes div.bootstrap-datetimepicker-widget.bottom ul.list-unstyled li div.timepicker div.timepicker-picker,
        .start-time .bootstrap-datetimepicker-widget.bottom

        {
            /*box-shadow: 0 5px 5px -3px rgb(0 0 0 / 20%), 0 8px 10px 1px rgb(0 0 0 / 14%), 0 3px 14px 2px rgb(0 0 0 / 12%);*/
            box-shadow: 0 0 4px #0000001a;
        }
    </style>
@endsection
@section('content')


<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-5">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{trans('home.add-session')}}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>
@if (session('status'))
    <div class="alert alert-success text-center" role="alert">
        {{ session('status') }}
    </div>
@endif

<section>


    <div id="lgx-schedule" class="lgx-schedule">
        <div class="lgx-inner">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="lgx-tab" >
                            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" id="pills-previuos-sessions-tab" data-toggle="pill" href="#pills-previuos-sessions" role="tab" aria-controls="pills-previuos-sessions" aria-selected="true">{{trans('home.all-sessions')}}</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" id="pills-today-sessions-tab" data-toggle="pill" href="#pills-today-sessions" role="tab" aria-controls="pills-today-sessions" aria-selected="false">{{trans('home.calender')}}</a>
                                </li>
                            </ul>
                            <div class="tab-content lgx-tab-content" id="pills-tabContent" >
                                <!-- all Session -->
                                <div class="tab-pane fade dir-rtl" id="pills-previuos-sessions" role="tabpanel" aria-labelledby="pills-previuos-sessions-tab">
                                    @include('therapists.include.allSessions',['AllSessions'=>$AllSessions])
                                </div>
                                <!--  Calender -->
                                <div class="tab-pane fade show active dir-rtl" id="pills-today-sessions" role="tabpanel" aria-labelledby="pills-today-sessions-tab">
                                    <div class="row px-5 py-5 my-2">
                                        <div class="container">
                                            <div class="row">
                                                <div class="col-12 text-center">
                                                    <span style="margin-left: 40px;margin-top: 15px;padding: 0px 20px;border-radius: 10px;display: inline-block;color: white;" class="label label-red">@lang('home.Reserved')</span>
                                                    <span style="margin-left: 40px;margin-top: 15px;padding: 0px 20px;border-radius: 10px;display: inline-block;color: white;" class="label label-green">@lang('home.Not reserved')</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div id='calendar' class="p-5"></div>
                                        <!--day click dialog -->
                                        <div id="dialog" style="display: none;">
                                            <div id="dialog-body" class="add-session-dialog">
                                                <!-- TAB NAVIGATION -->
                                                <nav class="nav nav-tabs nav-stacked mb-4">
                                                    <a class="nav-link active col-6" href="#individually" role="tab" data-toggle="tab">@lang('home.Individually')</a>
                                                    <a class="nav-link col-6" href="#group" role="tab" data-toggle="tab">@lang('home.Group')</a>
                                                </nav>
                                                <!-- TAB CONTENT -->
                                                <div class="tab-content">
                                                    <div class="tab-pane fade in active show" id="individually">
                                                        <form id="individuallyForm" method="post" action="" id="ajaxform">
                                                            @csrf
                                                            <input type="hidden" name="event_id" id="event_id">
                                                            <input type="hidden" name="fun_type" id="fun_type">
                                                            <div class="form-group">
                                                                <label> {{ trans('home.period') }} : </label>
                                                                <label class="mx-5">
                                                                    <input type="radio" name="type" value="30"  id="price30"
                                                                           data-parsley-required="true"
                                                                           data-parsley-required-message="{{trans('home.choose-one')}}"
                                                                           required
                                                                    >
                                                                    {{ trans('home.30minutes') }}
                                                                </label>
                                                                <label class="mx-5">
                                                                    <input type="radio"  name="type" value="60"  id="price60"
                                                                    >
                                                                    {{ trans('home.60minutes') }}
                                                                </label>

                                                                @error('type')
                                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">
                                                                    {{ $message }}
                                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </p>
                                                                @enderror
                                                            </div>

                                                            <div class="col-12 start-time">
                                                                <label> {{ trans('home.scdule') }} : </label>
                                                                <input type="hidden" id="start_time" class="form-control"  value="{{ old('start_time') }}" name="start_time"
                                                                       data-parsley-required="true"
                                                                       data-parsley-required-message="{{trans('home.input-required')}}"
                                                                       required data-date-format="YYYY/MM/DD hh:mm A"
                                                                >
                                                                @error('start_time')
                                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">
                                                                    {{ $message }}
                                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>inline: true,
                                                                </p>
                                                                @enderror
                                                            </div>

                                                            <div class="form-group text-center">
                                                                <button type="submit" class="lgx-btn mt-5 save-data">
                                                                    {{ trans('home.resgister_session') }}
                                                                </button>
                                                            </div>
                                                            <span class="message"></span>

                                                        </form>
                                                    </div>
                                                    <div class="tab-pane fade" id="group">
                                                        <form id="scheduleForm" method="post" action="" id="ajaxform">
                                                            @csrf
                                                            <div class="form-row">
                                                                <div class="form-group col-lg-6">
                                                                    <label> {{ trans('home.Date') }} : </label>
                                                                    <input type="text" id="start_date" class="form-control datetimepicker-right"  value="{{ old('start_date') }}" name="start_date" placeholder="@lang('home.Choose a start date')" data-date-format="YYYY/MM/DD">
                                                                    @error('start_date')
                                                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">
                                                                        {{ $message }}
                                                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </p>
                                                                    @enderror
                                                                </div>
                                                                <div class="form-group col-lg-6">
                                                                    <label style="height: 17px;width: 100%;display: inline-block;"></label>
                                                                    <input type="text" id="end_date" class="form-control datetimepicker-left"  value="{{ old('end_date') }}" name="end_date" placeholder="@lang('home.Choose an end date')" data-date-format="YYYY/MM/DD">
                                                                    @error('end_date')
                                                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">
                                                                        {{ $message }}
                                                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </p>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                            <div class="col-12 hours-minutes">
                                                                <label>@lang('home.Hours: minutes')</label>
                                                                <input type="hidden" id="timeSlotTime" class="form-control timepickerinline"  value="{{ old('timeSlotTime') }}" name="timeSlotTime"  data-date-format="hh:mm A">
                                                                @error('timeSlotTime')
                                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">
                                                                    {{ $message }}
                                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </p>
                                                                @enderror
                                                            </div>


                                                            <div class="form-group mt-4">
                                                                <label> {{ trans('home.period') }} : </label>
                                                                <label class="mx-5">
                                                                    <input type="radio" name="type" value="30"  id="price30"
                                                                           data-parsley-required="true"
                                                                           data-parsley-required-message="{{trans('home.choose-one')}}"
                                                                           required
                                                                    >
                                                                    {{ trans('home.30minutes') }}
                                                                </label>
                                                                <label class="mx-5">
                                                                    <input type="radio"  name="type" value="60"  id="price60"
                                                                    >
                                                                    {{ trans('home.60minutes') }}
                                                                </label>

                                                                @error('type')
                                                                <p class="alert alert-danger alert-dismissible fade show" role="alert">
                                                                    {{ $message }}
                                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </p>
                                                                @enderror
                                                            </div>

                                                            <div class="form-group text-center">
                                                                <button type="submit" class="lgx-btn mt-5 save-schedule-data">
                                                                    {{ trans('home.resgister_session') }}
                                                                </button>
                                                            </div>
                                                            <span class="message"></span>

                                                        </form>
                                                    </div>

                                                </div>


                                            </div>

                                        </div>

                                    </div>
                                </div>
                            </div> <!-- pills-tabContent -->
                        </div> <!-- lgx-tab -->
                    </div>
                </div>
            </div>
            <!-- //.CONTAINER -->
        </div>
        <!-- //.INNER -->
    </div>





</section>

@endsection
@section('scriptSection')
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script type="text/javascript">
        $(document).ready( function () {
            $(document).on('change','[name="statues"]',function(){
                datatable.draw();
            })
            $(document).on('change','.checkAll',function(){
                console.log($(this).is(':checked'))
                $(".sessionCheckbox").prop('checked',$(this).is(':checked'));
            })
            $('.delete_all').on('click', function(e) {
                var allVals = [];
                $(".sub_chk:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });
                if(allVals.length <=0) {
                    swal({
                        title: "حذف الجلسات",
                        text: "يرجي اختيار الجلسات المراد حذفها",
                        type: "warning",
                    })
                }
                else{
                    swal({
                        title: "حذف الجلسات",
                        text: "هل انت متاكد من حذف ذلك؟",
                        type: "warning",
                        confirmButtonText: "نعم",
                    }).then(function (e) {
                        var join_selected_values = allVals.join(",");
                        $.ajax({
                            url:"{{url('delete_checked_sessions')}}",
                            type: 'DELETE',
                            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                            data: 'ids='+join_selected_values,
                            success: function (data) {
                                $(".sub_chk:checked").each(function() {
                                    $(this).parents("tr").hide(200);
                                    $('#calendar').fullCalendar('refetchEvents');
                                    $('.message').html('<div class="alert dark alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + data.message + '</b></div>');
                                });
                            },
                            error: function (data) {
                                alert(data.responseText);
                            }
                        });
                    })
                }


            });
            $('#date-filter').daterangepicker({
                    startDate: moment().subtract('days', 29),
                    endDate: moment(),
                    minDate: '01/01/2020',
                    maxDate: '{{ date('m/d/Y') }}',
                    dateLimit: { days: 60 },
                    showDropdowns: true,
                    showWeekNumbers: true,
                    timePicker: false,
                    timePickerIncrement: 1,
                    timePicker12Hour: true,
                    ranges: {
                        '@lang('home.Today')': [moment(), moment()],
                        '@lang('home.Yesterday')': [moment().subtract('days', 1), moment().subtract('days', 1)],
                        '@lang('home.Last 7 Days')': [moment().subtract('days', 6), moment()],
                        '@lang('home.Last 30 Days')': [moment().subtract('days', 29), moment()],
                        '@lang('home.This Month')': [moment().startOf('month'), moment().endOf('month')],
                        '@lang('home.Last Month')': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')]
                    },
                    opens: 'left',
                    buttonClasses: ['btn btn-default'],
                    applyClass: 'btn-small btn-primary',
                    cancelClass: 'btn-small',
                    format: 'MM/DD/YYYY',
                    separator: ' to ',
                    locale: {
                        applyLabel: '@lang('home.Submit')',
                        fromLabel: '@lang('home.To')',
                        customRangeLabel: '@lang('home.Custom Range')',
                        daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr','Sa'],
                        monthNames: ['@lang('home.January')', '@lang('home.February')', '@lang('home.March')', '@lang('home.April')', '@lang('home.May')', '@lang('home.June')', '@lang('home.July')', '@lang('home.August')', '@lang('home.September')', '@lang('home.October')', '@lang('home.November')', '@lang('home.December')'],
                        firstDay: 1
                    }
                },
                function(start, end) {
                    console.log("Callback has been called!");
                    $('#date-filter').parent().find('.from_date').val(start.format('YYYY-MM-DD'));
                    $('#date-filter').parent().find('.to_date').val(end.format('YYYY-MM-DD'));
                    $('#date-filter span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                    datatable.draw();
                }
            );
            var datatable = $('#sessions_table').DataTable({
                processing: true,
                serverSide: true,
                "order": [[ 0, "DESC" ]],
                ajax: {
                    url:"{{ route('sessions_get') }}",
                    data:function(data){
                        var from_date=$("#date-filter").parent().find('.from_date').val();
                        var to_date=$("#date-filter").parent().find('.to_date').val();
                        data.from_date = from_date;
                        data.to_date = to_date;
                        statues=$('[name="statues"]:checked').val();
                        data.statues = statues;
                    },
                },
                "language": {
                    "url": "{{ (config('app.locale')=='ar')?asset('datatable/languages/arabic.json'):asset('datatable/languages/english.json') }}"
                },
                "lengthMenu": [
                    [10, 20, 50, 100, 150],
                    [10, 20, 50, 100, 150] // change per page values here
                ],
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'visitor_name', name: 'users.name'},
                    {data: 'date', name: 'date'},
                    {data: 'statues', name: 'visitor_id'},
                    {data: 'checkbox', name: 'checkbox',orderable: false, searchable: false},
                ]
            });
        } );
    </script>
    <script src="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/js/bootstrap-datetimepicker.min.js"></script>
    <script>
        var dateToday = new Date();
        //author: mohamed.khalf@almoasherbiz.com
        document.addEventListener('DOMContentLoaded', function() {
            /*$('#start_time').inputmask("datetime",{
                mask: "y-1-2 h:s",
                placeholder: "yyyy-mm-dd hh:mm",
                leapday: "-02-29",
                separator: "-",
                alias: "yyyy-mm-dd",
                hourFormat:12,
            });*/
            $(".timepickerinline").datetimepicker({
                //debug:true,
                inline: true,
            });
            $('.datetimepicker-right').datetimepicker({
                //debug:true,
                minDate:dateToday,
                widgetPositioning:{
                    horizontal: 'right',
                    vertical: 'bottom'
                }
            });
            $('.datetimepicker-left').datetimepicker({
                //debug:true,
                minDate:dateToday,
                widgetPositioning:{
                    horizontal: 'left',
                    vertical: 'bottom'
                }
            });
            $('#start_time').datetimepicker({
                //debug:true,
                inline: true,
                minDate:dateToday,
                widgetPositioning:{
                    horizontal: 'left',
                    vertical: 'bottom'
                }
            });
            function convert(str){
                const d = new Date(str);
                let month = '' + (d.getMonth() + 1);
                let day = '' + (d.getDate());
                let year = d.getFullYear();
                if(month.length < 2 )  month='0' + month;
                if(day.length < 2 )  day='0' + day;
                let hour = '' +d.getUTCHours();
                let minutes = '' +d.getUTCMinutes();
                let seconds = ''+d.getUTCSeconds();
                if(hour.length < 2 )  hour='0' + hour;
                if(minutes.length < 2 )  minutes='0' + minutes;
                if(seconds.length < 2 )  seconds='0' + seconds;

                return [year,month,day].join('-')+' '+[hour,minutes,seconds].join(':')
            }

            $('#calendar').fullCalendar({
                timeFormat: 'h(:mm) A',
                events:"{{ route('all-sessions') }}",
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
                },
                initialDate: '2021-01-01',
                navLinks: true, // can click day/week names to navigate views
                editable: true,
                dayMaxEvents: true, // allow "more" link when too many event
                dayClick: function(date, jsEvent, view){
                    $('#event_id').val('');
                    console.log(date._d);
                    console.log(new Date(date._d));
                    console.log(new Date());
                    //$('#start_time').val(convert(date._d));
                    $('#start_time').data("DateTimePicker").date(new Date(date._d))
                    $('.message').html('')
                    $("button.save-data").html('اضافة جلسة')
                    $('#dialog').dialog({
                        title:'@lang("home.add-session")',
                        width: ($(window).width()<400)?$(window).width()-20:400, // overcomes width:'auto' and maxWidth bug
                        maxWidth: 700,
                        height: 480,
                        modal: true,
                        fluid: true, //new option
                        resizable: false,
                        show:{effect:'clip',duration:350},
                        hide:{effect:'clip',duration:250},
                    });
                    $("#fun_type").val('add');
                }, //dayClick

                //Update Full Calender Ajax Request
                eventClick: function(event){
                    console.log(event.start)
                    console.log(new Date(event.start._i))
                    event.type == 30 ? $("#price30").prop("checked", true) : $("#price60").prop("checked", true);
                    //$('#start_time').val(convert(event.start))
                    $('#start_time').data("DateTimePicker").date(new Date(event.start._i))
                    //$('#start_time').val(convert(event.start));
                    $('#color').val(event.color);
                    $('#text_color').val(event.textColor);
                    $('#event_id').val(event.event_id);
                    $('.message').html('')
                    $("button.save-data").html('تعديل جلسة')
                    $('#dialog').dialog({
                        title:'تعديل جلسة',
                        width: ($(window).width()<400)?$(window).width()-20:400, // overcomes width:'auto' and maxWidth bug
                        maxWidth: 700,
                        height: 480,
                        modal:true,
                        show:{effect:'clip',duration:350},
                        hide:{effect:'clip',duration:250},
                    })
                    $("#fun_type").val('update');
                },//eventClick

            });


            $(document).on('click','.save-data',function(event){
                event.preventDefault();
                let type = $("#individuallyForm input[name=type]:checked").val();
                let start_time = $("#individuallyForm input[name=start_time]").val();
                let color = $("#individuallyForm input[name=color]").val();
                let text_color = $("#individuallyForm input[name=text_color]").val();
                let event_id = $("#individuallyForm input[name=event_id]").val();
                let _token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: "{{ route("calenderSession") }} ",
                    type: "POST",
                    data: {
                        type: type,
                        start_time: start_time,
                        color: color,
                        text_color: text_color,
                        _token: _token,
                        event_id: $("#event_id").val(),
                        fun_type: $("#fun_type").val(),
                    },
                    success: function (response) {

                        if(response.success){
                            //location.reload();
                            $('.message').html('<div class="alert dark alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + response.message + '</b></div>');
                            $('#calendar').fullCalendar('refetchEvents');
                            $('#dialog').dialog("close");
                            $('.message').html('')

                        }else{
                            $('.message').html('<div class="alert dark alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + response.message + '</b></div>');
                        }
                    },
                    error: function (xhr) {
                        $('.message').html('');
                        $.each(xhr.responseJSON.errors, function (key, value) {
                            $('.message').append('<div class="alert dark alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + value + '</b></div>');
                        });
                    },
                });
            });
            $(document).on('click','.save-schedule-data',function(event){
                event.preventDefault();
                let type = $("#scheduleForm input[name=type]:checked").val();
                let start_date = $("input[name=start_date]").val();
                let end_date = $("input[name=end_date]").val();
                let timeSlotTime = $("input[name=timeSlotTime]").val();
                let color = $("input[name=color]").val();
                let text_color = $("input[name=text_color]").val();
                let event_id = $("input[name=event_id]").val();
                let _token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: "{{ route("scheduleCalenderSession") }} ",
                    type: "POST",
                    data: {
                        type: type,
                        start_date: start_date,
                        end_date: end_date,
                        timeSlotTime: timeSlotTime,
                        color: color,
                        text_color: text_color,
                        _token: _token,
                    },
                    success: function (response) {

                        if(response.success){
                            //location.reload();
                            $('.message').html('<div class="alert dark alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + response.message + '</b></div>');
                            $('#calendar').fullCalendar('refetchEvents');
                            $('#dialog').dialog("close");
                            $('.message').html('')

                        }else{
                            $('.message').html('<div class="alert dark alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + response.message + '</b></div>');
                        }
                    },
                    error: function (xhr) {
                        $('.message').html('');
                        $.each(xhr.responseJSON.errors, function (key, value) {
                            $('.message').append('<div class="alert dark alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + value + '</b></div>');
                        });
                    },
                });
            });

        });
    </script>
@endsection




