@extends('layouts.site')
<style>

.fa-star
    {
        color: #ffca08;
    }
    .fa-star-half
    {
        transform: rotate(180deg);
        color: #ffca08;
    }
    .btn-accord{
        padding-left: 50px !important;
        padding-right: 50px !important;
        padding-bottom: 5px;
        padding-top: 5px;
        border-radius: 18px;
        background: #ccc;
        margin-left: 25px;
    }
    .btnactive{
        background: #3da8c0;
    }
    .formlabel{
        color: #4d4d4f;
        font-size: 14px;
        font-weight: bolder;
    }
    .forminputdiv{
        padding-right: 5px;
        font-size: 14px;
        color: #666669;;
    }
    .formelement{
        min-height: 110px;
    }
    .btnReset{
        font-size: 16px!important;
        border: 1px solid #f4794c !important;
        color: #f4794c !important;
        background: #fff !important;
        padding-right: 30px!important;
        padding-left: 30px!important;
        padding-top: 8px;
        padding-bottom: 8px;
        border-radius: 23px !important;
        display: none;
    }
    .btnSubmit{
        font-size: 16px!important;
        background: #3da8c0 !important;
        color: #fff !important;
        padding-right: 30px!important;
        padding-left: 30px!important;
        padding-top: 8px;
        padding-bottom: 8px;
        border-radius: 23px !important;
        display: none;
    }
    .formelement .forminput{
        display: none;
    }

    @media only screen and(max-width: 768px){

    }
    .ck-editor__editable {
        height: 200px;
        min-height: 200px;
        max-height: 200px;
    }

    .forminputt
    {
        padding: 20px 6px !important;
        font-size: 14px !important;
    }

</style>

@section('headScript')
<link rel="stylesheet" href="{{ asset('select2/distt/css/select2.css')}}">

<style type="text/css">
 /*   .select2-container
{
    display: none;
}*/
</style>

@endsection

@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-4">
                                        <ul class="breadcrumb">
                                            @if(config('app.locale') == "ar")
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            <li class="active"> {{ config('app.locale') == "ar" ?  $data->name_a : $data->name_e }} </li>
                                            @else
                                                <li class="active"> {{ config('app.locale') == "ar" ?  $data->name_a : $data->name_e }} </li>
                                                <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            @endif
                                        </ul>

                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="POST" action="{{route('sessions_add')}}" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{trans('home.add')}}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="type" id="exampleRadios1" value="30" checked>
                                <label class="form-check-label" for="exampleRadios1">
                                    30 {{trans('home.minutes')}}
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="type" id="exampleRadios2" value="60">
                                <label class="form-check-label" for="exampleRadios2">
                                    60 {{trans('home.minutes')}}
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="text" name="start_time" class="form-control" placeholder="start_time" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (session('status'))
        <div class="alert alert-success" role="alert">
            {{ session('status') }}
        </div>
    @endif
    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2 mx-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            @if(!empty($data->picture))
                            <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                            @else
                                <img src="{{asset('avatars/therapists/default_image.png')}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                            @endif
                            <h4 class="mt-5 colorsite"> {{ config('app.locale') == "ar" ?  $data->name_a : $data->name_e }} </h4>
                            <p class="text-sm-center mb-3">
                                {{$data->main_specialty}}
                            </p>
                            <div>
                                <?php

                            $reviews = [
                                (object)['rate' => round($avg_rating,1)],
                            ];
                            foreach ($reviews as $review) {
                                for ($i = 0; $i <= 5; ++$i) {
                                    echo '<i class="fa fa-star' ,
                                        ($review->rate == $i + .1 ? '-half' : '') ,
                                        ($review->rate == $i + .2 ? '-half' : '') ,
                                        ($review->rate == $i + .3 ? '-half' : '') ,
                                        ($review->rate == $i + .4 ? '-half' : '') ,
                                        ($review->rate == $i + .5 ? '-half' : '') ,
                                        ($review->rate == $i + .6 ? '-half' : '') ,
                                        ($review->rate == $i + .7 ? '-half' : '') ,
                                        ($review->rate == $i + .8 ? '-half' : '') ,
                                        ($review->rate == $i + .9 ? '-half' : '') ,
                                        ($review->rate <= $i ? '-o' : '') ,
                                        '" aria-hidden="true"></i>';
                                    echo "\n";
                                }
                                echo "\n";
                            }

                        ?>
                        <br>
                        <label>(@lang('home.Evaluation') {{ round($avg_rating,1) }} )</label>
                            </div>
                            <div class="mb-3">
                                <label>@lang('home.sessions-count'): {{$data->sessions->whereIn('session_status',['reserved','closed'])->count() + 25}}</label>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_sessions')}}">
                                <i class="fas fa-play"></i><br />
                                {{trans('auth.therapists.sessions')}}
                            </a>
                        </div>

                        <div class="col-6 mb-4">
                            <a href="{{route('clients-files')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients_files')}}
                            </a>
                        </div>

                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_clients')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_invoice')}}">
                                <i class="fas fa-file-invoice"></i><br />
                                {{trans('auth.therapists.invoices')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_profile_basic')}}">
                                <i class="fas fa-user-md"></i><br />
                                {{trans('auth.therapists.profile')}}
                            </a>
                        </div>

                        @if (auth()->check()&&auth()->user()->type != 'visitors')
                           <div class="col-6">
                                <a href="{{route('page_view',getStaticPageValue(10,'url')) }}"><i class="fas fa-archive"></i> <br>{{ getStaticPageValue(10) }}</a>
                            </div>
                        @endif

                    </div>
                </div>
                <div class="col-md-9 boxing bg-white">
                    <div class="mr1">
                        <h3 class="mt-5 colorsite font-weight-bold">{{trans('home.myAccount')}}</h3>
                    </div>

                    @if (session()->has('error'))
                        <div class="alert alert-dismissable alert-success">
                            <strong>
                                {!! session()->get('error') !!}
                            </strong>

                            <button type="button" class="close mx-3" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    @if (session()->has('success'))
                        <div class="alert alert-dismissable alert-success">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <strong>
                                {!! session()->get('success') !!}
                            </strong>
                        </div>
                    @endif

                    <div class="row d-flex justify-content-around p-5 ">

                            <a class="col-md-3 text-center bg-off-white text-dark3 no-hover-underline bg-blue text-white btn-accord btnactive my-1" href="{{ config('app.locale') == "ar" ?  url('therapists/profile/basic_info') : url('en/therapists/profile/basic_info')}} " >
                               {{trans('home.basic-info')}}
                            </a>
                            <!-- <a class="col-md-3 text-center bg-off-white text-dark3 no-hover-underline bg-blue text-white btn-accord  d-flex justify-content-center align-items-center my-1" href="{{url('therapists/profile/experience')}}" >
                                الخبرات
                            </a>
                            <a class="col-md-3 text-center bg-off-white text-dark3 no-hover-underline bg-blue text-white btn-accord my-1" href="{{url('therapists/profile/session')}}" >
                                مصاريف الجلسات
                            </a> -->
                            <div class="col-md-12 text-right" style="padding-top:25px;">
                                <a style="text-decoration: underline;color: #110ee6;font-size:15px" href="{{route('gettherapistsrequests')}}" >{{trans('home.viewallrequests')}}<i class="fa  fa-arrow-left"></i></a>
                            </div>
                        <!-- <div class="col-md-12 text-left" style="padding-top:25px;">
                            <a href="javascript:void(0)" id="edit_basic_info" style="text-decoration: underline;color: #f4794c;" >  {{trans('home.edit-info')}} <i class="fa fa-edit"></i></a>
                        </div> -->
                        <div class="col-md-12" style="padding-top:10px;">
                            <span> {{trans('home.personal-info')}} </span>
                            <hr />
                        </div>


                        <div class="col-md-12 my-4">
                            <div class="alert alert-dismissible">
                                <ul id="notification" style="margin-bottom: 0;">
                                </ul>
                            </div>
                        </div>

                        <div class="col-md-12">
                            
                            <form id="saveBasicRequests" method="post" onsubmit="return false;">
                                <div class="row">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                
                                    <div class="col-md-6">
                                        <div class="formelementt">
                                            <div class="formlabel"> {{trans('home.name-arabic')}} <span style="color: red;">*</span></div>
                                            <div class="forminputdivv">
                                                <input class="forminputt form-control @error('name_a') is-invalid @enderror" type="text" name="title_ar" id="name_a" value="{{ $data->name_a  }}">
                                                <label for="error-name_a"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel">  {{trans('home.name-english')}} <span style="color: red;">*</span> </div>
                                            <div class="forminputdiv">
                                                <input class="forminputt form-control text-left" type="text" name="title_en" id="name_e" value="{{ $data->name_e  }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.Main Focus')}} </div>
                                            <div class="forminputdiv">
                                                @php $ids=\App\TherapistsMainFocus::where('therapist_id',$data->id)->pluck('main_focus_id')->toArray(); @endphp
                                                <select class="form-control forminputt select2 @error('main_focus') is-invalid @enderror" name="main_focus[]" multiple id="main_focus">
                                                    @foreach(\App\MainFocus::active()->pluck('title_'.config('app.locale'),'id')->toArray() as $id=>$name)
                                                        <option @if(in_array($name, explode(',', $data->main_focus))) selected @endif value="{{ $name }}">{{ $name }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="error-main_focus"></label>

                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.summery-arabic')}}  </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt text-right" id="summery_ar"  name="summery_ar" >{!! $data->summery_ar !!}</textarea>
                                                <label for="error-summery_ar"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.summery-english')}}  </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt" id="summery_en" name="summery_en" > {!! $data->summery_en !!} </textarea>
                                                <label for="error-summery_en"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.more-information-arabic')}} </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt " id="description_ar" rows="10" name="description_ar" > {!! $data->description_ar !!} </textarea>

                                            </div>
                                            <label for="error-description_ar"></label>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.more-information-english')}} </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt" id="description_en" rows="10" name="description_en" > {!! $data->description_en !!} </textarea>
                                            </div>
                                            <label for="error-description_en"></label>
                                        </div>
                                    </div>


                                    <div class="col-md-4">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.gender')}} </div>
                                            <div class="forminputdiv">
                                                <select name="gender" id="gender" class="form-control forminputt">
                                                    <option value="male"  @if($data->gender== 'male') selected @endif>
                                                        @lang('home.male')
                                                    </option>
                                                    <option value="female"  @if($data->gender== 'female') selected @endif>
                                                        @lang('home.female')
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.licence-number')}} </div>
                                            <div class="forminputdiv">
                                                <input id="license_no" class="forminputt form-control text-right" type="text" name="license_no" value="{{$data->license_no}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.licence-organization')}} </div>
                                            <div class="forminputdiv">
                                                <input id="license_org" class="forminputt form-control text-right" type="text" name="license_org" value="{{$data->license_org}}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.language')}} </div>
                                            <div class="forminputdiv">
                                                @if(!empty($data->language))
                                                    <select name="language_id" id="language_id" class="form-control forminputt">
                                                        @foreach(\App\Languages::get() as $language)
                                                            <option value="{{ $language->id }}"  @if($data->language->id == $language->id) selected @endif>
                                                                {{  config('app.locale') == "ar" ? $language->title_ar : $language->title_en }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                @else
                                                    <select name="language_id" id="language_id" class="form-control forminputt">
                                                        @foreach(\App\Languages::get() as $language)
                                                            <option value="{{ $language->id }}">
                                                                {{  config('app.locale') == "ar" ? $language->title_ar : $language->title_en }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                 @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.Specialization')}}  <span style="color: red;">*</span></div>
                                            <div class="forminputdiv">
                                                <select id="specialties" name="specialties[]" class="form-control forminputt select2" multiple>
                                                    @foreach($specialties as $id=>$title)
                                                        <option value="{{$id}}" @if(in_array($id,$therapist_specialties)) selected @endif>{{$title}}</option>
                                                    @endforeach
                                                </select>
                                                <label for="error-specialties"></label>

                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.email')}}  <span style="color: red;">*</span></div>
                                            <div class="forminputdiv">
                                                <input class="forminputt form-control text-left" type="text" name="email" id="email" value="{{$data->user->email}}">
                                            </div>
                                            <label for="error-email" class="error-email"></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.Country')}} </div>
                                            <div class="forminputdiv">
                                                <select name="country_id" id="country_id" class="form-control forminputt">
                                                    @foreach(\App\Countries::get() as $country)
                                                        <option
                                                    @if(!empty($country))

                                                        {{ ($country->id==$data->country_id)?'selected="selected"':'' }} value="{{ $country->id }}">{{  config('app.locale') == "en" ? $country->title_en : $country->title_ar}}</option>
                                                        @endif
                                                        @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.price30')}}</div>
                                            <div class="forminputdiv">
                                                <input id="price30" class="forminputt form-control text-left @if (config('app.locale') == "en") text-left @else  text-right  @endif" type="text" name="price30" value="{{$data->price30}}"  >
                                                <label for="error-price30"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.price60')}} </div>
                                            <div class="forminputdiv">
                                                <input id="price60" class="forminputt form-control @if (config('app.locale') == "en") text-left @else  text-right  @endif " type="text" name="price60" value="{{$data->price60}}">
                                                <label for="error-price60"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.thirty_price_dollar')}} </div>
                                            <div class="forminputdiv">
                                                <input id="thirty_price_dollar" class="forminputt form-control text-left @if (config('app.locale') == "en") text-left @else  text-right  @endif" type="text" name="thirty_price_dollar" value="{{$data->thirty_price_dollar}}"  >
                                                <label for="error-thirty_price_dollar"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.sixty_price_dollar')}} </div>
                                            <div class="forminputdiv">
                                                <input id="sixty_price_dollar" class="forminputt form-control @if (config('app.locale') == "en") text-left @else  text-right  @endif " type="text" name="sixty_price_dollar" value="{{$data->sixty_price_dollar}}">
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.certificates-arabic')}}  </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt" id="certifacations_ar" rows="10" name="certifacations_ar" > {!! $data->certifications_ar !!} </textarea>
                                                <label for="error-certifacations_ar"></label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.certificates-english')}} </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt" id="certifacations_en" rows="10" name="certifacations_en" > {!! $data->certifications_en !!} </textarea>
                                                <label for="error-certifacations_en"></label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.experience-arabic')}} </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt" id="experience_ar" rows="10" name="experience_ar" > {!! $data->experience_ar !!} </textarea>
                                                <label for="error-experience_ar"></label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-5">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.experience-english')}} </div>
                                            <div class="forminputdiv">
                                                <textarea class="form-control forminputt" id="experience_en" rows="10" name="experience_en" > {!! $data->experience_en !!} </textarea>
                                                <label for="error-experience_en"></label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.position-arabic')}}  </div>
                                            <div class="forminputdiv">
                                                <input class="forminputt form-control" type="text" id="main_specialty_ar"  name="main_specialty_ar" value="{{ $data->main_specialty_ar  }}" placeholder="مثال:اخصائي نفسي ومعالج روحاني">
                                                <label for="error-main_specialty_ar"></label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="formelement">
                                            <div class="formlabel">  {{trans('home.position-english')}}  </div>
                                            <div class="forminputdiv">
                                                <input class="forminputt form-control text-left" type="text" id="main_specialty_en" name="main_specialty_en" value="{{ $data->main_specialty_en  }}" placeholder="Psychological and marriage therapist">
                                                <label for="error-main_specialty_en"></label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.profile-image')}} </div>
                                            <div class="mt-2">
                                                <input class="forminputt text-left" type="file" id="picture" name="picture" value="">
                                                <label for="error-picture"></label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-4 form-input-value">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.resume')}} </div>
                                            <div class="mt-2">
                                                <a href="{{ route('get-resume',$data->id).'?v='.rand(0,999)   }}" class="form-input-value btn btn-info btn-lg">
                                                    {{ trans('home.preview-resume')  }} </a>
                                                <input class="forminputt" type="file" id="resume" name="resume" value="">
                                                <lebel for="error-resume"></lebel>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 formelement">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.licence')}} </div>
                                            <div class="mt-2">
                                                 <a href="{{ route('get-licence',$data->id).'?v='.rand(0,999)  }}" class="form-input-value btn btn-info btn-lg">
                                                          {{ trans('home.preview-licence')  }} </a>
                                                <input class="forminputt" type="file" id="licence" name="licence" value="">
                                                <label for="error-licence"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="formelement">
                                            <div class="formlabel"> {{trans('home.certificates')}} </div>
                                            <div class="mt-2">
                                                <a href="{{ route('get-certificates',$data->id).'?v='.rand(0,999)   }}" class="form-input-value btn btn-info btn-lg">
                                                    {{ trans('home.preview-certificates')  }} </a>
                                                <input class="forminputt" type="file" id="zip_certificates" name="zip_certificates" value="">
                                                <label for="error-zip_certificates"></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12 text-center" style="padding:30px;">
                                        <input class="btn btnReset" type="reset"  value="{{trans('home.cancel')}}">
                                        <input class="btn btnSubmit" type="submit"  value="{{trans('home.save')}}">
                                    </div>


                                </div>
                            </form>
                            
                        </div>

                      

                       
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scriptSection')
    <script src="https://cdn.ckeditor.com/ckeditor5/25.0.0/classic/ckeditor.js"></script>
    <script>

        $(document).ready( function () {
            $('.profileImg').hide();
           
           $(".select2").select2();
        } );

           // Add the following code if you want the name of the file appear on select
            $(".custom-file-input").on("change", function() {
            var fileName = $(this).val().split("\\").pop();
            $(this).siblings(".custom-file-label").addClass("selected").html(fileName);
            });


    </script>

<script src="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/js/bootstrap-datetimepicker.min.js"></script>
<script>

    //arabic characters
    jQuery.validator.addMethod("arabicLetters", function(value, element) {
        return this.optional(element) || /^([\u0600-\u06ff ]|[\u0750-\u077f ]|[\ufb50-\ufbc1 ]|[\ufbd3-\ufd3f ]|[\ufd50-\ufd8f ]|[\ufd92-\ufdc7 ]|[\ufe70-\ufefc ]|[\ufdf0-\ufdfd ]|[.]|[/]|[-]|[،])*$/g.test(value);
    }, "arabicLetters only please");

    //English characters
    jQuery.validator.addMethod("englishLetters", function(value, element) {
        return this.optional(element) || /^([a-z ]|[.]|[/]|[-]|[,])+$/i.test(value);
    }, "englishLetters only please");

    //arabic with english mix
    jQuery.validator.addMethod("letters", function(value, element) {
        return this.optional(element) || /^[a-zA-Z\u0600-\u06FF,-][\sa-zA-Z\u0600-\u06FF,-]*$/.test(value);
    }, "Letters only please");

    jQuery.validator.addMethod("specialties", function(value, element) {
       if(value.length==3&&$.inArray("24",value)!=-1&&$.inArray("25",value)!=-1&&$.inArray("27",value)!=-1){
           return true;
       }else if(value.length==2||value.length==1||value.length==0){
           return true;
       }
       return false;
    }, "يمكنك فقط اختيار تخصصين او (استشارات المقبلين على الزواج، علاج المشاكل الزواجية والأسرية، التأهيل النفسي بعد الطلاق)");
    $.validator.addMethod("greaterThan",
        function (value, element, param) {
            var $otherElement = $(param);
            return parseInt(value, 10) > parseInt($otherElement.val(), 10);
        });

    $.validator.addMethod("lessThan",
        function (value, element, param) {
            var $otherElement = $(param);
            return parseInt(value, 10) < parseInt($otherElement.val(), 10);
        });
    $(document).ready(function() {
        
        var description_ar,description_en,summery_ar,summery_en,experience_ar,experience_en,certifacations_ar,certifacations_en;
        
           
            ClassicEditor.create(document.querySelector('#description_ar')).then( editor => {console.log(editor);description_ar=editor;}).catch( error => {console.error(error);});
            ClassicEditor.create(document.querySelector('#description_en')).then( editor => {console.log(editor);description_en=editor;}).catch( error => {console.error(error);});
            ClassicEditor.create(document.querySelector('#summery_ar')).then( editor => {console.log(editor);summery_ar=editor;}).catch( error => {console.error(error);});
            ClassicEditor.create(document.querySelector('#summery_en')).then( editor => {console.log(editor);summery_en=editor;}).catch( error => {console.error(error);});
            ClassicEditor.create(document.querySelector('#experience_ar')).then( editor => {console.log(editor);experience_ar=editor;}).catch( error => {console.error(error);});
            ClassicEditor.create(document.querySelector('#experience_en')).then( editor => {console.log(editor);experience_en=editor;}).catch( error => {console.error(error);});
            ClassicEditor.create(document.querySelector('#certifacations_ar')).then( editor => {console.log(editor);certifacations_ar=editor;}).catch( error => {console.error(error);});
            ClassicEditor.create(document.querySelector('#certifacations_en')).then( editor => {console.log(editor);certifacations_en=editor;}).catch( error => {console.error(error);});

             
            

        
        $('.btnReset').click(function (){
            location.reload();
        })
        $(document).on('change','[name="specialties[]"]',function(){
            $("#save_therapists_profile_basic").valid();
        });
        $("#saveBasicRequests").validate({
            ignore: false,
            errorPlacement: function (error, element) {               
                $(element)
                    .closest("form")
                    .find("label[for='error-" + element.attr("id") + "']")
                    .append(error);
            },
            errorElement: "span",
            rules: {
                title_ar: {
                    required: true,
                    minlength: 2,
                    arabicLetters: true,
                },
                title_en: {
                    required: true,
                    minlength: 2,
                  //  englishLetters: true
                },

                
                "specialties[]": {
                    required: true,
                    specialties: true,
                },
                email: {
                    required: true,
                },
                @if(!$data->picture)
                picture: {
                    required: true,
                },
                @endif
            },
            messages: {
                title_ar: {
                    required: "@lang('home.required_field')",
                    minlength: "@lang('home.minlength_2_field')",
                    arabicLetters: "@lang('home.arabic_only')",
                },
                title_en: {
                    required: "@lang('home.required_field')",
                    minlength: "@lang('home.minlength_2_field')",
                    englishLetters: "@lang('home.english_only')",
                },
                
                
               
                email: {
                    required: "@lang('home.required_field')",
                },
                picture: {
                    required: "@lang('home.required_field')",
                },

                "specialties[]": {
                    required: "@lang('home.required_field')",
                    maxlength: "@lang('home.please_enter_2_select')",
                },


            },
            submitHandler(form){
                $(form).find(".btnSubmit").attr('disabled','disabled')
                
                var dataForm = new FormData(form);
                dataForm.append('description_ar',description_ar.getData());
                dataForm.append('description_en',description_en.getData());
                dataForm.append('summery_ar',summery_ar.getData());
                dataForm.append('summery_en',summery_en.getData());
                dataForm.append('experience_ar',experience_ar.getData());
                dataForm.append('experience_en',experience_en.getData());
                dataForm.append('certifacations_ar',certifacations_ar.getData());
                dataForm.append('certifacations_en',certifacations_en.getData());

                $.ajax({
                    type: "POST",
                    url: "{{ route('save_therapists_profile_basic_requests') }}",
                    data: dataForm,
                    processData: false,
                    contentType: false,
                    beforeSend:function(){
                        $(form).find(".btnSubmit").html(' جاري الحفظ ..... ')
                    },
                    success: function (response) {
                        $(form).find(".btnSubmit").removeAttr('disabled')
                        $(form).find(".btnSubmit").html(' حفظ ')
                        if(!response){
                            $('#notification').parent().removeClass('alert-danger');
                            $('#notification').parent().addClass('alert-success');
                            $('#notification').html('<li>تم التعديل بنجاح</li>');
                            $([document.documentElement, document.body]).animate({
                                scrollTop:0
                            }, 2000);
                            return false;
                        }else{


                            //New
                            // $('.forminput, .ck-editor').hide();
                            // $('.btnReset').hide();
                            // $('.btnSubmit').hide();
                            // $('.form-input-value').show();
                            // $(this).show();
                            // $('.resume-upload').hide();
                            // $(this).hide();
                            // $('.profileImg').hide();
                            
                            window.location.href = '{{ route("update_my_profile_message") }}';

                            //new

                            // $('#notification').parent().removeClass('alert-danger');
                            // $('#notification').parent().addClass('alert-success');
                            //$('#notification').html('<li>يتم مراجعه البيانات والموافقه عليها في اسرع وقت</li>');
                            // $('#notification').html('<li>'+response.message+'</li>');
                            // $([document.documentElement, document.body]).animate({
                            //     scrollTop:0
                            // }, 2000);
                            // return false;
                        }
                    },
                    error: function (response) {

                        $.each(response.responseJSON.errors, function (key, value) {
                            html = '<li>' + value + '</li>';
                            
                            $('#notification').html(html)
                            $('#notification').parent().addClass('alert-danger')
                            

                            $([document.documentElement, document.body]).animate({
                                scrollTop:0
                            }, 2000);
                            

                        });


                       /* $('#notification').parent().removeClass('alert-success');
                        $('#notification').parent().addClass('alert-danger');
                        var html = '';

                        $.each(response.responseJSON.errors, function (key, value) {
                            // $('#notification').html('<li>يتم مراجعه البيانات والموافقه عليها في اسرع وقت</li>');
                            html += '<li>' + value + '</li>';


                        });
                        if(response.responseJSON.message == undefined)
                            html += '<li>' + 'يتم مراجعه البيانات والموافقه عليها في اسرع وقت'+ '</li>';
                        $('#notification').html();
                        if(response.responseJSON.message != undefined)

                            // html += '<li>' + response.responseJSON.message + '</li>';

                            if(response.message != undefined)

                                html += '<li>' + response.message + '</li>';
                        $('#notification').html(html);
                        window.scrollTo({top: 0, behavior: 'smooth'});
                        return false;*/
                       scrollTo=false;
                        $(form).find(".btnSubmit").removeAttr('disabled')
                        $(form).find(".btnSubmit").html(' حفظ ')
                        $.each(response.responseJSON.errors, function (key, value) {
                            console.log("#save_therapists_profile_basic [name='"+key+"']")
                            el= $("#save_therapists_profile_basic [name='"+key+"']");
                            console.log(el.length)
                            if(!el.length){
                                el=$("#save_therapists_profile_basic [name='"+key+"[]']");
                            }
                            console.log("label[for='error-"+el.attr('id')+"']")
                            el.parent().find("label[for='error-"+el.attr('id')+"']").html('<span id="error-'+el.attr('id')+'" class="error">'+value+'</span>');
                            if(!scrollTo){
                                scrollTo=true;
                                $([document.documentElement, document.body]).animate({
                                    scrollTop:el.offset().top-150
                                }, 2000);
                            }
                        });

                    }
                });
            },
        });
    });
    $(document).ready(function() {
        $('.select2').select2();
    });
    $(document).on('keyup','.not-under-one',function(){
        if($(this).val()<=0){
            $(this).val(1)
        }
    })
    $('.datepickerymd').datetimepicker({
        //debug:true,
    });
    //author@mohammed.khalf@almoasherbiz.com
    filesLabel={
        "picture":"@lang('home.Attach a personal photo')",
        "resume":"@lang('home.Attach the CV')",
        //"licence":"@lang('home.Attach the license')",
        "zip_certificates":"@lang('home.Attach certificates')",
    };
    $('.custom-file input').change(function (e) {
        var files = [];
        for (var i = 0; i < $(this)[0].files.length; i++) {
            files.push($(this)[0].files[i].name);
        }
        console.log('files');
        console.log(files);
        console.log(filesLabel[$(this).attr('name')]);
        $(this).parent().find('.custom-file-label').html(((files.length)?files.join(' , '):filesLabel[$(this).attr('name')]));
    });
    $( function() {
        $( ".datepicker" ).datepicker({
            dateFormat: "yy-mm-dd"
        });
    });
</script>
@endsection
