@extends('layouts.site')

@section('content')
<style type="text/css">
    .fa-star
    {
        color: #ffca08;
    }
    .fa-star-half
    {
        transform: rotate(180deg);
        color: #ffca08;
    }
    .myBtn
    {
        font-size: 25px !important;
        padding: 8px 3px;
        margin: 25px 2px;
        color: #c26aff;
        font-weight: 700;
            background: none;
    }
    .myBtn:hover
    {
        color: #c26aff;
    }

    [data-title]:hover:after {
    opacity: 1;
    transition: all 0.1s ease 0.5s;
    visibility: visible;
}
[data-title]:after {
    content: attr(data-title);
    background-color: #181818;
    color: #f9f9f9;
    font-size: 12px;
    position: absolute;
    padding: 1px 5px 2px 5px;
    top: -17px;
    left: -10px;
    white-space: nowrap;
    box-shadow: 1px 1px 3px #222222;
    opacity: 0;
    border: 1px solid #111111;
    z-index: 99999;
    visibility: hidden;
}
[data-title] {
    position: relative;
}
.fa-plus
{
        background: #e7e7e7;
    padding: 5px;
    border-radius: 50%;
    color: #c26aff;
}

</style>
        <section>
            <div class="lgx-banner lgx-banner-inner">
                <div class="lgx-inner-bg">
                    <div class="lgx-inner">
                        <div class="container bartopline">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="lgx-heading-area mt-3">
                                        <ul class="breadcrumb">
                                            @if(config('app.locale') == "ar")
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            <li class="active"> {{trans('home.client-files')}}</li>
                                            @else
                                                <li class="active"> {{trans('home.client-files')}}</li>
                                                <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div><!--//.ROW-->
                        </div><!-- //.CONTAINER -->
                    </div><!-- //.INNER -->
                </div>
            </div>
        </section>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if(Session::has('status'))
            <p class="alert alert-success alert-dismissible fade show mt-2 text-center" role="alert">{{ Session::get('status') }}
                <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </p>
        @endif

        <div class="mt-5 mb-5">
            <div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <div class="boxing bg-white border row ml-2  mx-2">
                            <div class="col-md-12 float-right pt-5 text-center">
                                <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                                <h4 class="mt-5 colorsite">{{ config('app.locale') == "en" ? $data->name_e : $data->name_a }}</h4>
                                <p class="text-sm-center my-4">
                                    {{ $data->main_specialty }}
                                </p>
                                <div>

                                    <?php

                            $reviews = [
                                (object)['rate' => round($avg_rating,1)],
                            ];
                            foreach ($reviews as $review) {
                                for ($i = 0; $i <= 5; ++$i) {
                                    echo '<i class="fa fa-star' ,
                                        ($review->rate == $i + .1 ? '-half' : '') ,
                                        ($review->rate == $i + .2 ? '-half' : '') ,
                                        ($review->rate == $i + .3 ? '-half' : '') ,
                                        ($review->rate == $i + .4 ? '-half' : '') ,
                                        ($review->rate == $i + .5 ? '-half' : '') ,
                                        ($review->rate == $i + .6 ? '-half' : '') ,
                                        ($review->rate == $i + .7 ? '-half' : '') ,
                                        ($review->rate == $i + .8 ? '-half' : '') ,
                                        ($review->rate == $i + .9 ? '-half' : '') ,
                                        ($review->rate <= $i ? '-o' : '') ,
                                        '" aria-hidden="true"></i>';
                                    echo "\n";
                                }
                                echo "\n";
                            }

                        ?>
                        <br>
                        <label>(@lang('home.Evaluation') {{ round($avg_rating,1) }} )</label>



                                </div>
                                <div class="mb-4">
                                    <label>@lang('home.sessions-count'): {{$data->sessions->whereIn('session_status',['reserved','closed'])->count() + 25}}</label>
                                </div>
                            </div>
                        </div>
                        <div class="mt-5 row clearfix text-center ml-2">
                            <div class="col-6 mb-4">
                                <a href="{{route('therapists_sessions')}}">
                                    <i class="fas fa-play"></i><br />
                                    {{trans('auth.therapists.sessions')}}
                                </a>
                            </div>
                            <div class="col-6 mb-4">
                                <a href="{{route('clients-files')}}">
                                    <i class="fas fa-users"></i><br />
                                    {{trans('auth.therapists.clients_files')}}
                                </a>
                            </div>

                            <div class="col-6 mb-4">
                                <a href="{{route('therapists_clients')}}">
                                    <i class="fas fa-users"></i><br />
                                    {{trans('auth.therapists.clients')}}
                                </a>
                            </div>
                            <div class="col-6">
                                <a href="{{route('therapists_invoice')}}">
                                    <i class="fas fa-file-invoice"></i><br />
                                    {{trans('auth.therapists.invoices')}}
                                </a>
                            </div>
                            <div class="col-6">
                                <a href="{{route('therapists_profile_basic')}}">
                                    <i class="fas fa-user-md"></i><br />
                                    {{trans('auth.therapists.profile')}}
                                </a>
                            </div>
                            @if (auth()->check()&&auth()->user()->type != 'visitors')
                           <div class="col-6">
                                <a href="{{route('page_view',getStaticPageValue(10,'url')) }}"><i class="fas fa-archive"></i> <br>{{ getStaticPageValue(10) }}</a>
                            </div>
                        @endif
                        </div>
                    </div>

                    <div class="col-md-9 boxing bg-white">
                        <div class="table-responsive mt-5">
                            <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="client_files">
                                <thead>
                                <tr class="text-center bg-blue table-row">
                                    <th> # </th>
                                    <th>  {{ trans('home.client-name') }} </th>
                                    <th>  {{trans('home.first-session')}}  </th>
                                    <th> {{trans('home.last-session')}} </th>
                                    <!-- <th> {{trans('home.Status approval')}}  </th> -->
                                    <!-- <th> {{trans('home.inbox')}}  </th> -->
                                    <th width="25%"> {{trans('home.action')}}  </th>
                                </tr>
                                </thead>
                                    <tbody>
                                    <?php $x=1;?>
                                    @foreach($therapistSessions  as $therapist_session)
                                            <tr class="text-center text-black">
                                                <td> {{$x}} </td>
                                                <?php
                                                   $visitor = \App\Visitor::find($therapist_session->visitor_id);
                                                   if(isset($visitor))
                                                   {
                                                    $user = \App\User::find($visitor->user_id);
                                                   }
                                                ?>
                                                <td> @if(isset($user)) {{ $user->name }} @endif</td>
                                                <td> <strong style="color:#00bacf" class="mx-3"> {{ date('Y-m-d h:i A',strtotime($therapist_session->start_time)) }} </strong><br> ( <span>  {{ $therapist_session->type  }} {{ trans('home.minutes') }} </span>)</td>
                                                <td> <strong style="color:#00bacf" class="mx-3"> {{ date('Y-m-d h:i A',strtotime(\App\Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->start_time)) }} </strong><br> ( <span>  {{ \App\Sessions::latest()->where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->type }} {{ trans('home.minutes') }} </span>)</td>
                                                <!-- <td>
                                                    @if( \App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->count() > 0 )

                                                        @if(\App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->first()->agreement_client == 1)
                                                            <i class="fa fa-check mt-5" aria-hidden="true"></i>
                                                        @else
                                                            <span class="badge badge-primary mt-3 p-3"> {{trans('home.approval-pinding')}} </span>
                                                        @endif

                                                    @endif
                                                </td> -->
                                                <td>
                                                    @if( \App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->count() > 0 )
                                                            <a data-title="{{trans('home.inbox')}}" class="myBtn" href="{{route('get-messages',$therapist_session->id)}}" >
                                                                <span>  <i class="fa fa-sms"></i> </span>
                                                                <!-- @if($messageCount=\App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id,'session_id'=>$therapist_session->id])->first())
                                                                    @if($messageCount->messages_count)
                                                                        <span class="badge">
                                                                            {{ $messageCount }}
                                                                        </span>
                                                                     @endif
                                                                @endif -->
                                                            </a>
                                                    @endif


                                                    @if( \App\TreatmentPlan::where(['therapist_id'=>$therapist_session->therapist_id,'visitor_id'=>$therapist_session->visitor_id])->count() > 0 )
                                                        <a  href="{{ route('view-plan',$therapist_session) }}" class=" myBtn" data-title="{{trans('home.view')}}">  <i class="fa fa-eye"></i>  </a>
                                                        <a data-title="{{trans('home.update')}}" href="{{ route('edit-plan',$therapist_session) }}" class=" myBtn"> <i class="fa fa-edit"></i></a>
                                                        <button  onclick="generatePDF({{ $therapist_session->id }})" class=" myBtn"><i class="fa fa-file-pdf" ></i></button>
                                                        @include('auth.download_report',['client_session'=>$therapist_session])
                                                    @else
                                                        <a data-title="{{trans('home.add')}}" href="{{ route('create-plan',$therapist_session) }}" class=" myBtn"> <i class="fa fa-plus"></i> </a>
                                                    @endif


                                                </td>
                                                
                                            </tr>
                                            <?php $x++;?>
                                        @endforeach
                                    </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
@endsection

<script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
<script src="{{ asset('assets/html2pdf.bundle.min.js') }}"></script>
<script type="text/javascript">
    function generatePDF(id) {
        $("#logo").css('display', 'block');

        // var pdf1 = $(".client_name_pdf").attr('data-id');
        // var pdf2 = $(".age_pdf").attr('data-id');
        // var pdf3 = $(".gender_pdf").attr('data-id');
        // var pdf4 = $(".problem_pdf").attr('data-id');
        // var pdf5 = $(".problem_description").attr('data-id');
        // var pdf6 = $(".diagnostic_pdf").attr('data-id');
        // var pdf7 = $(".therap_evaluation_pdf").attr('data-id');
        // var pdf8 = $(".table_pdf").attr('data-id');
        // var pdf9 = $(".long_term_pdf").attr('data-id');
        // var pdf10 = $(".short_term_pdf").attr('data-id');
        // var pdf11 = $(".therapeutic_intervention_pdf").attr('data-id');
        // var pdf12 = $(".transfer_pdf").attr('data-id');
        // var pdf13 = $(".current_status_pdf").attr('data-id');
        // var pdf14 = $(".last_visit_pdf").attr('data-id');
        // var pdf15 = $(".homework_pdf").attr('data-id');
        //
        // if(pdf1 == '0')
        // {
        //     $(".client_name_pdf").parent().css('display', 'none');
        // }
        // if(pdf2 == '0')
        // {
        //     $(".age_pdf").parent().css('display', 'none');
        // }
        // if(pdf3 == '0')
        // {
        //     $(".gender_pdf").parent().css('display', 'none');
        // }
        // if(pdf4 == '0')
        // {
        //     $(".problem_pdf").parent().css('display', 'none');
        // }
        //
        // if(pdf5 == '0')
        // {
        //     $(".problem_description").parent().css('display', 'none');
        // }
        // if(pdf6 == '0')
        // {
        //     $(".diagnostic_pdf").parent().css('display', 'none');
        // }
        // if(pdf7 == '0')
        // {
        //     $(".therap_evaluation_pdf").parent().css('display', 'none');
        // }
        // if(pdf8 == '0')
        // {
        //     $(".table_pdf").parent().css('display', 'none');
        // }
        //
        // if(pdf9 == '0')
        // {
        //     $(".long_term_pdf").parent().css('display', 'none');
        // }
        // if(pdf10 == '0')
        // {
        //     $(".short_term_pdf").parent().css('display', 'none');
        // }
        // if(pdf11 == '0')
        // {
        //     $(".therapeutic_intervention_pdf").parent().css('display', 'none');
        // }
        // if(pdf12 == '0')
        // {
        //     $(".transfer_pdf").parent().css('display', 'none');
        // }
        // if(pdf13 == '0')
        // {
        //     $(".current_status_pdf").parent().css('display', 'none');
        // }
        // if(pdf14 == '0')
        // {
        //     $(".last_visit_pdf").parent().css('display', 'none');
        // }
        // if(pdf15 == '0')
        // {
        //     $(".homework_pdf").parent().css('display', 'none');
        // }



        $("#report_title").text(' تقرير الخطه العلاجية ');
        // Choose the element that our report_PDF is rendered in.
        const element = document.getElementById("report_PDF_from_table_"+id);
        // Choose the element and save the PDF for our user.
        html2pdf()
            .from(element)
            .save();
    }
    $(document).ready( function () {
        $('#client_files').DataTable({
            responsive: true,
            "order": [[ 3, "desc" ]],
        });

    } );
</script>
