@extends('layouts.site')

@section('content')
<style type="text/css">
    .fa-star
    {
        color: #ffca08;
    }
    .fa-star-half
    {
        transform: rotate(180deg);
        color: #ffca08;
    }

</style>
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        @if(config('app.locale') == "ar")
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active"> {{trans('home.customer-archive')}} </li>
                                        @else
                                            <li class="active"> {{trans('home.customer-archive')}} </li>
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if (session('status'))
            <div class="alert alert-success" role="alert">
                {{ session('status') }}
            </div>
        @endif



    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2  mx-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                            <h4 class="mt-5 colorsite">{{ config('app.locale') == "en" ? $data->name_e : $data->name_a }}</h4>
                            <p class="text-sm-center my-4">
                                {{ $data->main_specialty }}
                            </p>
                            <div>
                               <?php

                            $reviews = [
                                (object)['rate' => round($avg_rating,1)],
                            ];
                            foreach ($reviews as $review) {
                                for ($i = 0; $i <= 5; ++$i) {
                                    echo '<i class="fa fa-star' ,
                                        ($review->rate == $i + .1 ? '-half' : '') ,
                                        ($review->rate == $i + .2 ? '-half' : '') ,
                                        ($review->rate == $i + .3 ? '-half' : '') ,
                                        ($review->rate == $i + .4 ? '-half' : '') ,
                                        ($review->rate == $i + .5 ? '-half' : '') ,
                                        ($review->rate == $i + .6 ? '-half' : '') ,
                                        ($review->rate == $i + .7 ? '-half' : '') ,
                                        ($review->rate == $i + .8 ? '-half' : '') ,
                                        ($review->rate == $i + .9 ? '-half' : '') ,
                                        ($review->rate <= $i ? '-o' : '') ,
                                        '" aria-hidden="true"></i>';
                                    echo "\n";
                                }
                                echo "\n";
                            }

                        ?>
                        <br>
                        <label>(@lang('home.Evaluation') {{ round($avg_rating,1) }} )</label>

                            </div>
                            <div class="mb-4">
                                <label>@lang('home.sessions-count'): {{$data->sessions->whereIn('session_status',['reserved','closed'])->count() + 25}}</label>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_sessions')}}">
                                <i class="fas fa-play"></i><br />
                                {{trans('auth.therapists.sessions')}}
                            </a>
                        </div>

                        <div class="col-6 mb-4">
                            <a href="{{route('clients-files')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients_files')}}
                            </a>
                        </div>
                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_clients')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_invoice')}}">
                                <i class="fas fa-file-invoice"></i><br />
                                {{trans('auth.therapists.invoices')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_profile_basic')}}">
                                <i class="fas fa-user-md"></i><br />
                                {{trans('auth.therapists.profile')}}
                            </a>
                        </div>
                        @if (auth()->check()&&auth()->user()->type != 'visitors')
                           <div class="col-6">
                                <a href="{{route('page_view',getStaticPageValue(10,'url')) }}"><i class="fas fa-archive"></i> <br>{{ getStaticPageValue(10) }}</a>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white">

                    <div class="table-responsive mt-5">
                        <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="client_table">
                            <thead>
                            <tr class="text-center bg-blue table-row">
                                <th> {{ trans('home.client-name') }} </th>
                                <th>  {{ trans('home.registration-date') }}  </th>
                                <th> {{trans('home.last-session-time')}} </th>
                                <th>{{trans('home.sessions-count')}}</th>
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($ClientInfo as $key=>$value)
                                    <tr class="text-center text-black">
                                        <td>

                                            <?php
                                                   $visitor = \App\Visitor::find($value);
                                                   if(isset($visitor))
                                                   {
                                                    $user = \App\User::find($visitor->user_id);
                                                   }
                                                ?>
                                               @if(isset($user)) {{ $user->name }} @endif
                                         </td>
                                        <td>@if(isset($user)) {{ $user->created_at }} @endif </td>
                                        <td style="color:#00bacf"> {{  \App\Sessions::latest()->where('visitor_id',$value)->first()->start_time }} </td>
                                        <td> {{ \App\Sessions::where(['therapist_id'=>$therapistID,'visitor_id'=>$value])->count()}}</td>
                                    </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                </div>
        </div>
    </div>
@endsection

<script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready( function () {
        $('#client_table').DataTable({
            responsive: true,
            "order": [[ 2, "desc" ]]
        });
    } );
</script>
