@extends('layouts.site')

@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>  {{trans('home.home')}} </a></li>
                                        <li class="active"> {{trans('home.registration-steps')}} </li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <!-- Freequently Asked Questions section -->
    <div class="xs-section-padding">
        <div class="row xs-faq-group">

            <div class="col-md-6">

                <div class="xs-single-faq">
                    <img class="regimage" src="{{ asset('images/session.jpg')}}" alt="verify">
                </div><!-- .xs-single-faq END -->

            </div>

            <div class="col-md-6">
                    <div class="xs-single-faq" style="text-align: center;padding: 200px 10px 33px 10px;/*! color: #ff2e8a; */">
                        <h3 style="color:#ff2e8a;">  {{ trans('home.data-revision')  }}  </h3>
                        @if($therapist=$userData->therapist)
                            @if($therapist->picture&&$therapist->name_a&&$therapist->name_e&&$therapist->gender&&$therapist->price30&&$therapist->price60)
                            <p> {{ trans('home.reply-soon-not-activated')  }}</p>
                           @else
                                <p> <a href="{{ route('therapists_profile_basic') }}">{{ trans('home.Go to profile to update your information')  }}</a></p>
                           @endif
                        @else
                        <p> {{ trans('home.reply-soon')  }}</p>
                            <p id="resend-message">
                                @lang('home.If you did not receive the email')
                                <a href="#" class="resendEmail">@lang('home.ClickHere')</a>
                            </p>
                            <div class="loading d-none">
                                <img src="{{ asset('img/loading.gif') }}" style="width:70px;" alt="">
                            </div>
                        @endif
                    </div><!-- .xs-single-faq END -->
            </div>

        </div><!-- .row END -->
    </div><!-- end Freequently Asked Questions section -->


@endsection
@section('scriptSection')
    <script>
        token= '{{ csrf_token() }}';
        $(document).on('click','.resendEmail',function(){
            $('.loading').removeClass('d-none');
            $.ajax({
                type: "POST",
                url: "{{ URL('resendVerify') }}",
                data: {_token:token},
                success: function (msg) {
                    $("#resend-message").html('<div class="alert alert-success">@lang('home.The email has been sent successfully')</div>')
                    $('.loading').addClass('d-none');
                }
            });
        });
    </script>
@endsection
