@extends('layouts.site')
<style>
    .btn-accord{
        padding-left: 50px !important;
        padding-right: 50px !important;
        padding-bottom: 5px;
        padding-top: 5px;
        border-radius: 18px;
        background: #ccc;
        margin-left: 25px;
    }
    .btnactive{
        background: #3da8c0;
    }
    .formlabel{
        color: #4d4d4f;
        font-size: 14px;
        font-weight: bolder;
    }
    .forminputdiv{
        padding-right: 5px;
        font-size: 14px;
        color: #666669;;
    }
    .formelement{
        min-height: 110px;
    }
    .btnReset{
        font-size: 16px!important;
        border: 1px solid #f4794c !important;
        color: #f4794c !important;
        background: #fff !important;
        padding-right: 30px!important;
        padding-left: 30px!important;
        padding-top: 8px;
        padding-bottom: 8px;
        border-radius: 23px !important;
        display: none;
    }
    .btnSubmit{
        font-size: 16px!important;
        background: #3da8c0 !important;
        color: #fff !important;
        padding-right: 30px!important;
        padding-left: 30px!important;
        padding-top: 8px;
        padding-bottom: 8px;
        border-radius: 23px !important;
        display: none;
    }
    .formelement .forminput{
        display: none;
    }
    .modal-open {
        overflow: hidden
    }
    .modal-open .modal {
        overflow-x: hidden;
        overflow-y: auto
    }
    .modal {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        display: none;
        width: 100%;
        height: 100%;
        overflow: hidden;
        outline: 0
    }
    .modal-dialog {
        position: relative;
        width: auto;
        margin: .5rem;
        pointer-events: none
    }
    .modal.fade .modal-dialog {
        transition: transform .3s ease-out;
        transform: translateY(-50px)
    }
    @media (prefers-reduced-motion:reduce) {
        .modal.fade .modal-dialog {
            transition: none
        }
    }
    .modal.show .modal-dialog {
        transform: none
    }
    .modal-dialog-scrollable {
        display: flex;
        max-height: calc(100% - 1rem)
    }
    .modal-dialog-scrollable .modal-content {
        max-height: calc(100vh - 1rem);
        overflow: hidden
    }
    .modal-dialog-scrollable .modal-footer,
    .modal-dialog-scrollable .modal-header {
        flex-shrink: 0
    }
    .modal-dialog-scrollable .modal-body {
        overflow-y: auto
    }
    .modal-dialog-centered {
        display: flex;
        align-items: center;
        min-height: calc(100% - 1rem)
    }
    .modal-dialog-centered:before {
        display: block;
        height: calc(100vh - 1rem);
        content: ""
    }
    .modal-dialog-centered.modal-dialog-scrollable {
        flex-direction: column;
        justify-content: center;
        height: 100%
    }
    .modal-dialog-centered.modal-dialog-scrollable .modal-content {
        max-height: none
    }
    .modal-dialog-centered.modal-dialog-scrollable:before {
        content: none
    }
    .modal-content {
        position: relative;
        display: flex;
        flex-direction: column;
        width: 100%;
        pointer-events: auto;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid rgba(0, 0, 0, .2);
        border-radius: .3rem;
        outline: 0
    }
    .modal-backdrop {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1040;
        width: 100vw;
        height: 100vh;
        background-color: #000
    }
    .modal-backdrop.fade {
        opacity: 0
    }
    .modal-backdrop.show {
        opacity: .5
    }
    .modal-header {
        display: flex;
        align-items: flex-start;
        justify-content: space-between;
        padding: 1rem;
        border-bottom: 1px solid #dee2e6;
        border-top-left-radius: .3rem;
        border-top-right-radius: .3rem
    }
    .modal-header .close {
        padding: 1rem;
        margin: -1rem -1rem -1rem auto
    }
    .modal-title {
        margin-bottom: 0;
        line-height: 1.5
    }
    .modal-body {
        position: relative;
        flex: 1 1 auto;
        padding: 1rem
    }
    .modal-footer {
        display: flex;
        align-items: center;
        justify-content: flex-end;
        padding: 1rem;
        border-top: 1px solid #dee2e6;
        border-bottom-right-radius: .3rem;
        border-bottom-left-radius: .3rem
    }
    .modal-footer > :not(:first-child) {
        margin-left: .25rem
    }
    .modal-footer > :not(:last-child) {
        margin-right: .25rem
    }
    .modal-scrollbar-measure {
        position: absolute;
        top: -9999px;
        width: 50px;
        height: 50px;
        overflow: scroll
    }
    @media (min-width:576px) {
        .modal-dialog {
            max-width: 500px;
            margin: 1.75rem auto
        }
        .modal-dialog-scrollable {
            max-height: calc(100% - 3.5rem)
        }
        .modal-dialog-scrollable .modal-content {
            max-height: calc(100vh - 3.5rem)
        }
        .modal-dialog-centered {
            min-height: calc(100% - 3.5rem)
        }
        .modal-dialog-centered:before {
            height: calc(100vh - 3.5rem)
        }
        .modal-sm {
            max-width: 300px
        }
    }
    @media (min-width:992px) {
        .modal-lg,
        .modal-xl {
            max-width: 800px
        }
    }
    @media (min-width:1200px) {
        .modal-xl {
            max-width: 1140px
        }
    }

</style>
@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area">
                                    <h2 class="lgx-heading lgx-heading-brand">
                                        <span class="back-heading"><i class="fa fa-map-marker" aria-hidden="true"></i></span>
                                        <span class="heading">{{$data->title}}</span>
                                    </h2>
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{$data->title}}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="POST" action="{{route('sessions_add')}}" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">إضافة</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="type" id="exampleRadios1" value="30" checked>
                                <label class="form-check-label" for="exampleRadios1">
                                    30 دقيقة
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="type" id="exampleRadios2" value="60">
                                <label class="form-check-label" for="exampleRadios2">
                                    60 دقيقة
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="text" name="start_time" class="form-control" placeholder="start_time" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (session('status'))
        <div class="alert alert-success" role="alert">
            {{ session('status') }}
        </div>
    @endif
    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 150px; height: 150px;" />
                            <h4 class="mt-5 colorsite">{{$data->title}}</h4>
                            <p class="text-sm-right mt-3">
                                {{$data->summery}}
                            </p>
                            <div>
                                @for($x=1;$x<=$data->rating;$x++)
                                    <span class="fa fa-star text-warning"></span>
                                @endfor
                                @for($y=$x;$y<=5;$y++)
                                    <span class="fa fa-star"></span>
                                @endfor
                                <label>(@lang('home.Evaluation') {{ $data->rating }} )</label>
                            </div>
                            <div>
                                <label>@lang('home.sessions-count'): {{$data->sessions->where('session_status','reserved')->count()}}</label>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6">
                            <a href="">
                                <i class="fas fa-play"></i><br />
                                {{trans('auth.therapists.sessions')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="">
                                <i class="fas fa-file-invoice"></i><br />
                                {{trans('auth.therapists.invoices')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="">
                                <i class="fas fa-chart-line"></i><br />
                                {{trans('auth.therapists.statistics')}}
                            </a>
                        </div>
                        <div class="col-12">
                            <a href="{{route('therapists_profile_basic')}}">
                                <i class="fas fa-user-md"></i><br />
                                {{trans('auth.therapists.profile')}}
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-md-9 boxing bg-white">
                    <div class="mr1 text-right">
                        <h3 class="mt-5 colorsite font-weight-bold">{{'حسابى'}}</h3>
                    </div>
                    <div class="row p-5 ">
                        <p>
                            <a class="col-md-2 text-center bg-off-white text-dark3 no-hover-underline bg-blue text-white btn-accord" href="{{url('therapists/profile/basic_info')}}" >
                                معلومات اساسية
                            </a>
                            <a class="col-md-2 text-center bg-off-white text-dark3 no-hover-underline bg-blue text-white btn-accord btnactive" href="{{url('therapists/profile/experience')}}" >
                                الخبرات
                            </a>
                            <a class="col-md-2 text-center bg-off-white text-dark3 no-hover-underline bg-blue text-white btn-accord" href="{{url('therapists/profile/session')}}" >
                                مصاريف الجلسات
                            </a>
                        </p>
                        <div class="col-md-12" style="padding-top:50px;">
                            <span>الخبرات</span>
                        </div>
                        <div class="col-md-12 row" style="padding-top:10px;">
                            <div class="col-md-12 experiences_section">
                                @foreach($data->experiences as $experience)
                                    {{__trans($experience->id, 'title', 'experiences','ar')}} - {{__trans($experience->id, 'organization', 'experiences','ar')}} <br />
                                @endforeach
                            </div>
                            <div class="col-md-12 text-left"><a style="cursor: pointer" data-target="#Experience" data-toggle="modal">اضافه <i class="fa fa-plus"></i></a></div>
                            <hr class="col-md-12" />
                        </div>
                        <div class="col-md-12" style="padding-top:10px;">
                            <span>الشهادات</span>
                        </div>
                        <div class="col-md-12 row" style="padding-top:10px;">
                            <div class="col-md-12 experiences_section">
                                @foreach($data->certificates as $certificate)
                                    {{__trans($certificate->id, 'name', 'certificates','ar')}} - {{__trans($certificate->id, 'organization', 'certificates','ar')}} <br />
                                @endforeach
                            </div>
                            <div class="col-md-12 text-left"><a href="#">اضافه <i class="fa fa-plus"></i></a></div>
                            <hr class="col-md-12" />
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="Experience" class="modal" >
{{--        <div class="modal-dialog modal-md animated BounceIn">--}}
{{--            <div class="modal-content no-border mt90">--}}
{{--                <div class="bg-blue text-white text-center fz18 pt16 pb16 brs-top5">Add new experience</div>--}}
{{--                <div class="p16">--}}
{{--                    <form novalidate="" class="ng-pristine ng-invalid ng-touched">--}}
{{--                        <div class="d-flex justify-content-between">--}}
{{--                            <div class="mr16"><label class="fz14 text-dark3 fsemi-bold">Organization (English) *</label>--}}
{{--                                <input name="organizationAr" type="text" class="form-control bg-offwhite1 ng-pristine ng-invalid ng-touched" placeholder="Enter Organization(En)" required=""></div>--}}
{{--                            <div>--}}
{{--                                <label class="fz14 text-dark3 fsemi-bold">Organization (Arabic) *</label>--}}
{{--                                <input name="organizationEn" type="text" class="form-control bg-offwhite1 ng-pristine ng-invalid ng-touched" placeholder="Enter Organization(Ar)" required=""></div>--}}
{{--                        </div>--}}
{{--                        <div class="d-flex justify-content-between mt20">--}}
{{--                            <div class="mr16"><label class="fz14 text-dark3 fsemi-bold">Title (English) *</label>--}}
{{--                                <input name="titleEn" type="text" class="form-control bg-offwhite1 ng-untouched ng-pristine ng-invalid" placeholder="Enter Title(EN)" required=""></div>--}}
{{--                            <div>--}}
{{--                                <label class="fz14 text-dark3 fsemi-bold">Title (Arabic) *</label>--}}
{{--                                <input name="titleAr" type="text" class="form-control bg-offwhite1 ng-untouched ng-pristine ng-invalid" placeholder="Enter Title(Ar)" required=""></div>--}}
{{--                        </div>--}}
{{--                        <label class="fz14 text-dark3 fsemi-bold mt20">Date *</label>--}}
{{--                        <div class="d-flex justify-content-between">--}}
{{--                            <div class="flex-grow-1">--}}
{{--                                <div class="input-group"><input name="dateFrom" class="form-control bg-offwhite1 ng-untouched ng-pristine ng-invalid" placeholder="From Date" required="" aria-haspopup="true">--}}
{{--                                    <owl-date-time _nghost-nhw-c115=""></owl-date-time><!---->--}}
{{--                                    <div class="input-group-append"><span class="input-group-text bg-offwhite1"><i class="fa fa-calendar"></i></span></div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                            <div class="ml16 ng-star-inserted">--}}
{{--                                <div class="input-group"><input name="dateTo" class="form-control bg-offwhite1 ng-untouched ng-pristine ng-invalid" placeholder="To Date" required="" aria-haspopup="true">--}}
{{--                                    <owl-date-time _nghost-nhw-c115=""></owl-date-time><!---->--}}
{{--                                    <div class="input-group-append"><span class="input-group-text bg-offwhite1"><i class="fa fa-calendar"></i></span></div>--}}
{{--                                </div>--}}
{{--                            </div><!----></div>--}}
{{--                        <div class="mt20">--}}
{{--                            <mat-checkbox name="present" type="checkbox" class="mat-checkbox mat-accent ng-untouched ng-pristine ng-valid" id="mat-checkbox-1">--}}
{{--                                <label class="mat-checkbox-layout" for="mat-checkbox-1-input">--}}
{{--                                    <div class="mat-checkbox-inner-container"><input type="checkbox" class="mat-checkbox-input cdk-visually-hidden" id="mat-checkbox-1-input" tabindex="0" name="present" aria-checked="false">--}}
{{--                                        <div matripple="" class="mat-ripple mat-checkbox-ripple mat-focus-indicator">--}}
{{--                                            <div class="mat-ripple-element mat-checkbox-persistent-ripple"></div>--}}
{{--                                        </div>--}}
{{--                                        <div class="mat-checkbox-frame"></div>--}}
{{--                                        <div class="mat-checkbox-background">--}}
{{--                                            <div class="mat-checkbox-mixedmark"></div>--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                    <span class="mat-checkbox-label"><span style="display: none;">&nbsp;</span>Till Now </span></label>--}}
{{--                            </mat-checkbox>--}}
{{--                        </div>--}}
{{--                        <div class="mt20">--}}
{{--                            <div class="fz14 text-dark3 fsemi-bold">Country</div>--}}
{{--                        </div>--}}
{{--                        <div class="d-flex justify-content-between mt20">--}}
{{--                            <div class="mr16"><label class="fz14 text-dark3 fsemi-bold">City (English)</label><input name="cityEn" type="text" class="form-control bg-offwhite1 ng-untouched ng-pristine ng-valid" placeholder="Enter City(En)"></div>--}}
{{--                            <div><label class="fz14 text-dark3 fsemi-bold">City (Arabic)</label><input name="cityAr" type="text" class="form-control bg-offwhite1 ng-untouched ng-pristine ng-valid" placeholder="Enter City(Ar)"></div>--}}
{{--                        </div>--}}
{{--                        <div class="d-flex justify-content-end mt20"><input type="submit" class="btn bg-blue text-white pt8 pb8 pl32 pr32 brs18" value="Save" disabled=""></div>--}}
{{--                    </form><!----></div>--}}
{{--            </div>--}}
{{--        </div>--}}
    </div>
@endsection
@section('scriptSection')
    <script>
        $(function (){
            $('#edit_basic_info').click(function (){
                $('.forminput').show();$('.btnReset').show();$('.btnSubmit').show();
                $('.form-input-value').hide();$(this).hide();
            })
            $('.btnReset').click(function (){
                location.reload();
            })
            $('#save_therapists_profile_basic').submit(function (){
                var dataForm = new FormData(this);
                $.ajax({
                    type: "POST",
                    url: "{{ route('save_therapists_profile_basic') }}",
                    data: dataForm,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        console.log(response);
                        $('#notification').parent().removeClass('alert-danger');
                        $('#notification').parent().addClass('alert-success');
                        $('#notification').html('<li>Updated Successfully!</li>');
                        return false;
                    },
                    error: function (response) {
                        $('#notification').parent().removeClass('alert-success');
                        $('#notification').parent().addClass('alert-danger');
                        var html = '';
                        $.each(response.responseJSON.errors, function (key, value) {
                            html += '<li>' + value + '</li>';
                        });
                        if(response.responseJSON.message != undefined)
                            html += '<li>' + response.responseJSON.message + '</li>';
                        if(response.message != undefined)
                            html += '<li>' + response.message + '</li>';
                        $('#notification').html(html);
                        return false;
                    }
                });
                return false;
            });
        })
    </script>
@endsection
