@extends('layouts.site')
@section('headScript')
    <style>
        .session-item-block{
            min-height: 190px;
        }
        #timeZone li{
            list-style: none;
        }
        #timeZone li a{
            color:black;
        }

        @media (min-width: 576px){
            .modal-dialog {
                max-width: 550px;
            }
        }
    </style>
@endsection
@section('content')
<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-3">
                                <ul class="breadcrumb">

                                    @if(config('app.locale') == "ar")
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">@lang('home.sessions')</li>
                                     @else
                                        <li class="active">@lang('home.sessions')</li>
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
@if (session('status'))
    <div class="alert alert-success" role="alert">
        {{ session('status') }}
    </div>
@endif
<div class="mt-5 mb-5">
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <div class="boxing bg-white border row ml-2  mx-2">
                    <div class="col-md-12 float-right pt-5 text-center">
                        <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                        <h4 class="mt-5 colorsite">{{ config('app.locale') == "en" ? $data->name_e : $data->name_a }}</h4>
                        <p class="text-sm-center my-4">
                            {{ $data->main_specialty }}
                        </p>
                        <div>
                            @for($x=1;$x<=$data->rating;$x++)
                            <span class="fa fa-star text-warning"></span>
                            @endfor
                            @for($y=$x;$y<=5;$y++)
                              <span class="fa fa-star"></span>
                            @endfor
                            <label>(@lang('home.Evaluation') {{ $data->rating }} )</label>
                        </div>
                        <div class="mb-4">
                            <label>@lang('home.sessions-count'): {{$data->sessions->where('session_status','reserved')->count()}}</label>
                        </div>
                    </div>
                </div>
                <div class="mt-5 row clearfix text-center ml-2">
                    <div class="col-6 mb-4">
                        <a href="{{route('therapists_sessions')}}">
                            <i class="fas fa-play"></i><br />
                            {{trans('auth.therapists.sessions')}}
                        </a>
                    </div>
                    <div class="col-6 mb-4">
                        <a href="{{route('clients-files')}}">
                            <i class="fas fa-users"></i><br />
                            {{trans('auth.therapists.clients_files')}}
                        </a>
                    </div>
                    <div class="col-6 mb-4">
                        <a href="{{route('therapists_clients')}}">
                            <i class="fas fa-archive"></i><br />
                            {{trans('auth.therapists.clients')}}
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="{{route('therapists_invoice')}}">
                            <i class="fas fa-file-invoice"></i><br />
                            {{trans('auth.therapists.invoices')}}
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="{{route('therapists_profile_basic')}}">
                            <i class="fas fa-user-md"></i><br />
                            {{trans('auth.therapists.profile')}}
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-md-9 boxing bg-white">
                <div class="mr1">
                    <div class="float-left">
                        <svg-icon _ngcontent-clu-c53="" src="assets/icons/timeslots/times.svg" class="mr5"><svg xmlns="http://www.w3.org/2000/svg" width="14.998" height="15" viewBox="0 0 14.998 15" _ngcontent-clu-c53="" style="width: 18px;"><defs _ngcontent-clu-c53=""><style _ngcontent-clu-c53="">.a{fill:#4d4d4f;}</style></defs><g transform="translate(-0.004)" _ngcontent-clu-c53=""><g transform="translate(0.004)" _ngcontent-clu-c53=""><path class="a" d="M21.111,4.982l-.224.071-1.2.106-.338.539-.245-.078-.951-.858-.138-.446-.185-.476-.6-.536-.705-.138-.016.323.691.674.338.4-.38.2-.309-.091-.464-.193.016-.374-.608-.25-.2.879-.613.139.061.49.8.154.138-.784.659.1.307.18h.492l.337.674.892.905L18.6,6.94l-.72-.092-1.243.628-.9,1.074-.117.476h-.321l-.6-.276-.582.276.145.614.253-.292.445-.014-.031.551.369.108.368.413.6-.169.687.108.8.214.4.047.675.766,1.3.766-.843,1.61-.89.413-.338.92-1.287.859-.137.5A7.49,7.49,0,0,0,21.111,4.982Z" transform="translate(-7.384 -1.655)" _ngcontent-clu-c53=""></path><path class="a" d="M8.365,15.355l-.546-1.013.5-1.045-.5-.15-.563-.565L6.009,12.3l-.414-.866v.514H5.412L4.337,10.494V9.3L3.55,8.016,2.3,8.239H1.456l-.424-.278.541-.429-.54.125A7.49,7.49,0,0,0,7.5,18.936a7.851,7.851,0,0,0,.941-.065l-.078-.909s.344-1.349.344-1.4S8.365,15.355,8.365,15.355Z" transform="translate(-0.004 -3.936)" _ngcontent-clu-c53=""></path><path class="a" d="M4.667,2.418,6,2.233,6.614,1.9l.691.2,1.1-.061.378-.594.551.091L10.677,1.4,11.046,1l.52-.348L12.3.761,12.571.72A7.475,7.475,0,0,0,3.6,2.727h0ZM9.7.746l.766-.422.492.284-.712.542-.68.068-.306-.2ZM7.428.807l.338.141L8.208.807l.241.418-1.022.268-.491-.287S7.417.9,7.428.807Z" transform="translate(-1.881)" _ngcontent-clu-c53=""></path></g></g></svg></svg-icon>
                        كل المواعيد
                        ({{ (Auth::user()->timezone)?Auth::user()->timezone:'Africa/Cairo' }})

                        <a data-toggle="modal" href="#changeTimezone">@lang('home.change')</a>
                        <div class="modal fade" id="changeTimezone">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                                            &times;
                                        </button>
                                        <h4 class="modal-title text-center" style="width: 100%">@lang('home.Change Time Zone')</h4>
                                    </div>
                                    <div class="modal-body">
                                     <div class="form-group">
                                         <input type="text" name="searchTimeZone" id="searchTimeZone" class="form-control" placeholder="@lang('home.Enter your timezone')">
                                     </div>

                                        <div id="timeZone" class="row">
                                            @foreach(DateTimeZone::listIdentifiers(DateTimeZone::ALL) as $key=>$timeZone)
                                                <li class="col-4"><a href="{{ route('changeTimeZone').'?timeZone='.$timeZone }}">{{ $timeZone }} @if((Auth::user()->timezone&&Auth::user()->timezone==$timeZone)||(!Auth::user()->timezone&&'Africa/Cairo'==$timeZone))<i class="fa fa-check"></i>@endif</a></li>
                                            @endforeach
                                        </div>
                                    </div>
                                </div><!-- /.modal-content -->
                            </div><!-- /.modal-dialog -->
                        </div><!-- /.modal -->
                    </div>
                    <h3 class="mt-5 colorsite font-weight-bold" >{{ trans('home.sessions') }}</h3>




                    <a href="{{route('sessions_get')}}" class="btn btn-success"> {{trans('home.add-session')}}  </a>
                </div>
                    <!--SCHEDULE-->
                    <section>
                        <div id="lgx-schedule" class="lgx-schedule">
                            <div class="lgx-inner">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="lgx-tab" >
                                                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <a class="nav-link" id="pills-previuos-sessions-tab" data-toggle="pill" href="#pills-previuos-sessions" role="tab" aria-controls="pills-previuos-sessions" aria-selected="true">{{trans('home.previuos-sessions')}}</a>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <a class="nav-link active" id="pills-today-sessions-tab" data-toggle="pill" href="#pills-today-sessions" role="tab" aria-controls="pills-today-sessions" aria-selected="false">{{trans('home.today-sessions')}}</a>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <a class="nav-link" id="pills-next-sessions-tab" data-toggle="pill" href="#pills-next-sessions" role="tab" aria-controls="pills-next-sessions" aria-selected="false">{{trans('home.next-sessions')}}</a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content lgx-tab-content" id="pills-tabContent" >
                                                    <!-- Previuos Session -->
                                                    <div class="tab-pane fade dir-rtl" id="pills-previuos-sessions" role="tabpanel" aria-labelledby="pills-previuos-sessions-tab">
                                                        <div class="row px-5 py-5 my-2">
                                                            @if(count($previousSessions))
                                                                @include('therapists.include.sessions_blocks',['sessionsBlocks'=>$previousSessions])
                                                            @else
                                                                <div class="text-center col-sm-12">@lang('home.There are no sessions')</div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- Today Sessions -->
                                                    <div class="tab-pane fade show active dir-rtl" id="pills-today-sessions" role="tabpanel" aria-labelledby="pills-today-sessions-tab">
                                                        <div class="row px-5 py-5 my-2">
                                                            @if(count($todaySessions))
                                                                @include('therapists.include.sessions_blocks',['sessionsBlocks'=>$todaySessions])
                                                            @else
                                                                <div class="text-center col-sm-12">@lang('home.There are no sessions')</div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- Next Sessions -->
                                                    <div class="tab-pane fade dir-rtl" id="pills-next-sessions" role="tabpanel" aria-labelledby="pills-next-sessions-tab">
                                                        <div class="row px-5 py-5 my-2 session-item-block">
                                                            @if(count($nextSessions))
                                                                @include('therapists.include.sessions_blocks',['sessionsBlocks'=>$nextSessions])
                                                            @else
                                                                <div class="text-center col-sm-12">@lang('home.There are no sessions')</div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div> <!-- pills-tabContent -->
                                            </div> <!-- lgx-tab -->
                                        </div>
                                    </div>
                                </div>
                                <!-- //.CONTAINER -->
                            </div>
                            <!-- //.INNER -->
                        </div>
                    </section>
                    <!--SCHEDULE END-->

            </div>
        </div>
    </div>
</div>
@endsection
@section('scriptSection')
    <script>
        $(document).on('keyup','#searchTimeZone',function(){
            var value = $(this).val();
            $("#timeZone > li > a").each(function() {
                if ($(this).text().toLowerCase().search(value.toLowerCase()) > -1) {
                    $(this).parent().show();
                }
                else {
                    $(this).parent().hide();
                }
            })
        })




    </script>
@endsection
