@extends('layouts.site')

@section('content')
<style type="text/css">
    .fa-star
    {
        color: #ffca08;
    }
    .fa-star-half
    {
        transform: rotate(180deg);
        color: #ffca08;
    }

</style>

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active"> {{ trans('home.client-files') }} </li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if(Session::has('status'))
        <p class="alert alert-success alert-dismissible fade show mt-2 text-center" role="alert">{{ Session::get('status') }}
            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </p>
    @endif

    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">

                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                            <h4 class="mt-5 colorsite">{{$data->user->name}}</h4>
                            <p class="text-sm-center my-4">
                                {{ $data->main_specialty }}
                            </p> 
                            <div>
                                <?php

                            $reviews = [
                                (object)['rate' => round($avg_rating,1)],
                            ];
                            foreach ($reviews as $review) {
                                for ($i = 0; $i <= 5; ++$i) {
                                    echo '<i class="fa fa-star' ,
                                        ($review->rate == $i + .1 ? '-half' : '') ,
                                        ($review->rate == $i + .2 ? '-half' : '') ,
                                        ($review->rate == $i + .3 ? '-half' : '') ,
                                        ($review->rate == $i + .4 ? '-half' : '') ,
                                        ($review->rate == $i + .5 ? '-half' : '') ,
                                        ($review->rate == $i + .6 ? '-half' : '') ,
                                        ($review->rate == $i + .7 ? '-half' : '') ,
                                        ($review->rate == $i + .8 ? '-half' : '') ,
                                        ($review->rate == $i + .9 ? '-half' : '') ,
                                        ($review->rate <= $i ? '-o' : '') ,
                                        '" aria-hidden="true"></i>';
                                    echo "\n";
                                }
                                echo "\n";
                            }

                        ?>
                        <br>
                        <label>(@lang('home.Evaluation') {{ round($avg_rating,1) }} )</label>
                            </div>
                            <div class="mb-4">
                                <label>@lang('home.sessions-count'): {{$data->sessions->whereIn('session_status',['reserved','closed'])->count() + 25}}</label>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_sessions')}}">
                                <i class="fas fa-play"></i><br />
                                {{trans('auth.therapists.sessions')}}
                            </a>
                        </div>
                        <div class="col-6 mb-4">
                            <a href="{{route('clients-files')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients_files')}}
                            </a>
                        </div>

                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_clients')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_invoice')}}">
                                <i class="fas fa-file-invoice"></i><br />
                                {{trans('auth.therapists.invoices')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_profile_basic')}}">
                                <i class="fas fa-user-md"></i><br />
                                {{trans('auth.therapists.profile')}}
                            </a>
                        </div>
                        @if (auth()->check()&&auth()->user()->type != 'visitors')
                           <div class="col-6">
                                <a href="{{route('page_view',getStaticPageValue(10,'url')) }}"><i class="fas fa-archive"></i> <br>{{ getStaticPageValue(10) }}</a>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white">
                    {{--<div class="table-responsive mt-5">
                        <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="client_files">
                            <thead>
                            <tr class="text-center bg-blue table-row">
                                <th> # </th>
                                <th>  {{trans('home.subject')}} </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $x=1;?>
                            @foreach($allMessages  as $messageInfo)
                                <tr class="text-center text-black">
                                    <td> {{$x}} </td>
                                    <td> {{ $messageInfo->message }} </td>
                                </tr>
                            <?php $x++;?>
                            @endforeach

                            </tbody>
                        </table>
                    </div>--}}
                    <div class="accordion mt-5" id="faqExample">
                        @if($treatInfo->allow_chat==0)
                            <form method="POST" class="mb-4" action="{{ route('allow_chat',$treatInfo->session_id) }}">
                                @csrf
                                <p>@lang('home.if you need to allow the client send messages to you click ')<button type="submit" class="btn btn-success">@lang('home.Allow Chat')</button></p>

                            </form>
                        @else
                            <form method="POST" class="mb-4" action="{{ route('disallow_chat',$treatInfo->session_id) }}">
                                @csrf
                                <p>@lang('home.if you need to disallow the client send messages to you click')<button type="submit" class="btn btn-danger">@lang('home.Dis Allow Chat')</button></p>

                            </form>
                        @endif
                        @foreach($allMessages  as $key=>$messageInfo)
                            <div class="card">
                                <div class="card-header p-2" style="background: #cccaca;" id="heading-{{ $messageInfo->id }}">
                                    <h5 class="mb-0" style="color:black;">
                                        <button style="color:black;" class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapse-{{ $messageInfo->id }}" aria-expanded="true" aria-controls="collapse-{{ $messageInfo->id }}">
                                            السؤال :
                                            {{ $messageInfo->message }}
                                        </button>
                                    </h5>
                                    <h6 style="position: absolute;left: 10px;top: 9px;color: black;">
                                        {{date('Y-m-d H:i:s', strtotime($messageInfo->created_at))}}
                                    </h6>
                                </div>

                                <div id="collapse-{{ $messageInfo->id }}" class="collapse @if($loop->first) show @endif" aria-labelledby="heading-{{ $messageInfo->id }}" data-parent="#faqExample">
                                    <div class="card-body">
                                        <b>الإجابة:</b>
                                        <div id="message-{{ $messageInfo->id }}">
                                            @if($messageInfo->answer)
                                                {{ $messageInfo->answer }}
                                            @else

                                                @if( $messageInfo->type =='therapist')
                                                 <p class="alert alert-info"> في انتظار رد  العميل </p>
                                                @else
                                                <div class="form-group">
                                                    <textarea name="answer_question" data-id="{{ $messageInfo->id }}" id="answer_question_{{ $messageInfo->id }}" class="form-control"></textarea>
                                                </div>
                                                <div class="text-center">
                                                    <button class="btn btn-success saveAnswer" data-id="{{ $messageInfo->id }}">ارسال الأجابة</button>
                                                </div>
                                                @endif
                                            @endif
                                        </div>

                                    </div>
                                </div>
                                
                            </div>
                            @endforeach
                            <!--container-->
                    </div>

                    @if($treatInfo->allow_chat)
                    <form method="POST" action="{{route('client-send-message',$client_session)}}" class="col align-self-center">
                                @csrf
                                <input type="hidden" name="type" value="therapist">
                                {{--                                                                        <input type="hidden" name="session_id" value="{{$client_session->id}}">--}}
                                <div class="form-group">
                                    <h4 for="validationDefault01" class="text-center"><strong> نص الرسالة</strong></h4>
                                    <div class="formelement">
                                        <div class="forminputdiv">
                                            <div class="form-group col-md-12">
                                                {{ Form::textarea('message',old('message'), ['placeholder' => 'اكتب نص رسالتك كاملة', 'class' => 'form-control forminput' , 'cols' => 20, 'rows' =>5, 'required' => 'required']) }}
                                            </div>
                                        </div>
                                    </div>
                                    @if ($errors->has('message'))
                                        <span class="alert alert-danger" role="alert">
                                     <strong>{{ $errors->first('message') }}</strong>
                                </span>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12 text-center">
                                        <button type="submit" class="lgx-btn mt-5" style="width:30%">
                                            {{ trans('auth.send') }}
                                        </button>
                                    </div>
                                </div>

                    </form>
                    @endif


                </div>
            </div>
        </div>
    </div>
@endsection
@section('scriptSection')
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            $(document).on('click','.saveAnswer',function(){
                el=$(this);
                el.attr('disabled','disabled');
                message_id=$(this).attr('data-id');
                answer=$('#answer_question_'+message_id).val();
                $.ajax({
                    type: "POST",
                    url: "{{ URL('client-messages/'.$treatInfo->session_id) }}",
                    data: {"answer": answer, "message_id": message_id,_token:token, 'type':'therapist'},
                    success: function (msg) {
                       if(msg.success){
                           $("#message-"+message_id).html(answer);
                       }
                       el.removeAttr('disabled');
                    }
                });
            })
        });
    </script>
@endsection
