@extends('layouts.site')
@section('headScript')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        .daterange-filter {
            background: none repeat scroll 0 0 #FFFFFF;
            border: 1px solid #CCCCCC;
            cursor: pointer;
            padding: 5px 10px;
        }
    .fa-star
    {
        color: #ffca08;
    }
    .fa-star-half
    {
        transform: rotate(180deg);
        color: #ffca08;
    }

    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        @if(config('app.locale') == "ar")
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active"> {{trans('home.invoices')}} </li>
                                        @else
                                            <li class="active"> {{trans('home.invoices')}} </li>
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (session('status'))
        <div class="alert alert-success" role="alert">
            {{ session('status') }}
        </div>
    @endif



    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2  mx-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                            <h4 class="mt-5 colorsite">{{ config('app.locale') == "en" ? $data->name_e : $data->name_a }}</h4>
                            <p class="text-sm-center my-4">
                                {{ $data->main_specialty }}
                            </p>
                            <div>
                                <?php

                            $reviews = [
                                (object)['rate' => round($avg_rating,1)],
                            ];
                            foreach ($reviews as $review) {
                                for ($i = 0; $i <= 5; ++$i) {
                                    echo '<i class="fa fa-star' ,
                                        ($review->rate == $i + .1 ? '-half' : '') ,
                                        ($review->rate == $i + .2 ? '-half' : '') ,
                                        ($review->rate == $i + .3 ? '-half' : '') ,
                                        ($review->rate == $i + .4 ? '-half' : '') ,
                                        ($review->rate == $i + .5 ? '-half' : '') ,
                                        ($review->rate == $i + .6 ? '-half' : '') ,
                                        ($review->rate == $i + .7 ? '-half' : '') ,
                                        ($review->rate == $i + .8 ? '-half' : '') ,
                                        ($review->rate == $i + .9 ? '-half' : '') ,
                                        ($review->rate <= $i ? '-o' : '') ,
                                        '" aria-hidden="true"></i>';
                                    echo "\n";
                                }
                                echo "\n";
                            }

                        ?>
                        <br>
                        <label>(@lang('home.Evaluation') {{ round($avg_rating,1) }} )</label>
                            </div>
                            <div class="mb-4">
                                <label>@lang('home.sessions-count'): {{$data->sessions->whereIn('session_status',['reserved','closed'])->count() + 25}}</label>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_sessions')}}">
                                <i class="fas fa-play"></i><br />
                                {{trans('auth.therapists.sessions')}}
                            </a>
                        </div>

                        <div class="col-6 mb-4">
                            <a href="{{route('clients-files')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients_files')}}
                            </a>
                        </div>

                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_clients')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_invoice')}}">
                                <i class="fas fa-file-invoice"></i><br />
                                {{trans('auth.therapists.invoices')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_profile_basic')}}">
                                <i class="fas fa-user-md"></i><br />
                                {{trans('auth.therapists.profile')}}
                            </a>
                        </div>
                        @if (auth()->check()&&auth()->user()->type != 'visitors')
                           <div class="col-6">
                                <a href="{{route('page_view',getStaticPageValue(10,'url')) }}"><i class="fas fa-archive"></i> <br>{{ getStaticPageValue(10) }}</a>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white  pt-5">

                    <style>
                        .month-total-block{
                            border: 1px solid #ccc;
                            border-radius: 5px;
                            padding: 10px
                        }
                        .month-money{
                            color: #3da8c0;font-size: 18px
                        }
                    </style>
                    <div class="row">
                        <div class="col-lg-2 col-md-3 col-sm-3 col-4 pl-0">
                            <div class="month-total-block">
                                <div class="month-name">@lang('home.'.date('F'))</div>
                                <div class="month-money">USD <span id="totalDollar">{{   number_format(floor($totalSessionThisMonthDollar*100)/100, 2) }}</span></div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-3 col-sm-3 col-4 pl-0">
                            <div class="month-total-block">
                                <div class="month-name">@lang('home.'.date('F'))</div>
                                <div class="month-money">EGP <span id="totalPound">
                                {{   number_format(floor($totalSessionThisMonth*100)/100, 2) }}</span></div>
                            </div>
                        </div>



                        <div class="col-md-8">
                            <div class="row text-center">
                                @if(isset($data->money_paid_egp))
                                <div class="col-lg-4 col-md-3 col-sm-3 col-4 pl-0">
                                    <div class="month-total-block" style="background-color:#d9e0e3;">
                                        <div class="month-namee">إجمالي المستحقات   بالجنية</div>
                                        <div class="month-moneyy">EGP <span style="font-size: 20px;color: #0f5a7a;">{{  $totalSessionThisMonth }}</span></div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-3 col-sm-3 col-4 pl-0">
                                    <div class="month-total-block" style="background-color:#d9e0e3;">
                                        <div class="month-namee">المبلغ المدفوع  بالجنية </div>
                                        <div class="month-moneyy">EGP <span style="font-size: 20px;color: #0f5a7a;">{{   $data->money_paid_egp }}</span></div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-3 col-sm-3 col-4 pl-0">
                                    <div class="month-total-block" style="background-color:#d9e0e3;">
                                        <div class="month-namee"> المبلغ المتبقي  بالجنية </div>
                                        <div class="month-moneyy">EGP <span style="font-size: 20px;color: #0f5a7a;">{{$totalSessionThisMonth - $data->money_paid_egp }}</span></div>
                                    </div>
                                </div>
                                @endif
                                @if(isset($data->money_paid_usd))
                                <div class="col-lg-4 col-md-3 col-sm-3 col-4 pl-0">
                                    <div class="month-total-block"  style="background-color:#d9e0e3;">
                                        <div class="month-namee">إجمالي المستحقات  بالدولار</div>
                                        <div class="month-moneyy">USD <span style="font-size: 20px;color: #0f5a7a;">{{  $totalSessionThisMonthDollar }}</span></div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-3 col-sm-3 col-4 pl-0">
                                    <div class="month-total-block"  style="background-color:#d9e0e3;">
                                        <div class="month-namee">المبلغ المدفوع بالدولار </div>
                                        <div class="month-moneyy">USD <span style="font-size: 20px;color: #0f5a7a;">{{  $data->money_paid_usd }}</span></div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-3 col-sm-3 col-4 pl-0">
                                    <div class="month-total-block"  style="background-color:#d9e0e3;">
                                        <div class="month-namee"> المبلغ المتبقي بالدولار </div>
                                        <div class="month-moneyy">USD <span style="font-size: 20px;color: #0f5a7a;">{{$totalSessionThisMonthDollar - $data->money_paid_usd  }}</span></div>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>


                        <div class="col-12"></div>
                        <div class="form-group mt-3 mr-4">
                            <div id="date-filter" class="daterange-filter reportrange">
                                <i class="fa fa-calendar"></i>
                                <span>{{ date('F d, Y',strtotime('first day of this month')) }} - {{ date('F d, Y',strtotime('last day of this month')) }}</span> <b class="caret"></b>
                            </div>
                            <input type="hidden" name="from_date" class="from_date" value="{{ date('Y-m-d',strtotime('first day of this month')) }}">
                            <input type="hidden" name="to_date" class="to_date" value="{{ date('Y-m-d',strtotime('last day of this month')) }}">
                        </div>
                    </div>
                    <div class="table-responsive">
                       {{--<span class="badge badge-info" style="font-size: 14px;padding: 10px;"> @lang('home.Total this Month') : {{ $totalSessionThisMonth }} @lang('home.pound') - {{ $totalSessionThisMonthDollar }} $</span>--}}


                        <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="invoice_table">
                            <thead>
                            <tr class="text-center table-row">
                                <th>#</th>
                                <th> {{ trans('home.client-name') }}</th>
                                <th> {{ trans('home.session-date') }}</th>
                                <th> {{trans('home.Therapist Amount')}} </th>
                                <th> {{ trans('home.paid-fees') }} </th>
                                <th> {{trans('home.discount-code')}} </th>
                                <th> {{trans('home.Discount Percentage')}} </th>
                                <th> {{trans('home.Discount Amount')}} </th>
                            </tr>
                            </thead>
                            <body>
                            </body>
                        </table>

                        {{--<span class="badge badge-info" style="font-size: 14px;padding: 10px;"> @lang('home.Total') : <span id="totalPound">{{ $totalSessionPound }}</span> @lang('home.pound') - <span id="totalDollar">{{ $totalSessionDollar }}</span> $</span>--}}
                    </div>

                </div>

            </div>
        </div>
    </div>
@endsection
@section('scriptSection')
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script type="text/javascript">
    $(document).ready( function () {

        function floorFigure(figure, decimals){
            if (!decimals) decimals = 2;
            var d = Math.pow(10,decimals);
            return (parseInt(figure*d)/d).toFixed(decimals);
        }

        function getTotal(from_date,to_date){
            console.log(from_date)
            console.log(to_date)
            q=$("#invoice_table_filter input").val();
            $.ajax({
                type: "GET",
                url: "{{ route('therapists_invoice') }}",
                data: {"returnSum": true,from_date:from_date,to_date:to_date,q:q},
                success: function (msg) {
                    $("#totalPound").html( floorFigure(msg.pound, 2))
                    $("#totalDollar").html( floorFigure(msg.dollar, 2))


                }
            });
        }

        var datatable = $('#invoice_table').DataTable({
            processing: true,
            serverSide: true,
            "order": [[ 2, "desc" ]],
            ajax: {
                url:"{{ route('therapists_invoice') }}",
                data:function(data){
                    var from_date=$("#date-filter").parent().find('.from_date').val();
                    var to_date=$("#date-filter").parent().find('.to_date').val();
                    data.from_date = from_date;
                    data.to_date = to_date;
                    getTotal(from_date,to_date);
                },
            },
            "language": {
                "url": "{{ (config('app.locale')=='ar')?asset('datatable/languages/arabic.json'):asset('datatable/languages/english.json') }}"
            },
            "lengthMenu": [
                [10, 20, 50, 100, 150],
                [10, 20, 50, 100, 150] // change per page values here
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'visitor_name', name: 'visitor_name'},
                {data: 'session_date', name: 'session_date'},
                {data: 'therapist_amount', name: 'therapist_amount'},
                {data: 'total_after_discount', name: 'total_after_discount'},
                {data: 'coupon_code', name: 'coupon_code'},
                {data: 'discount_percentage', name: 'discount_percentage'},
                {data: 'discount_amount', name: 'discount_amount'},
            ]
        });
        $('#date-filter').daterangepicker({
                startDate: moment().startOf('month'),
                endDate: moment().endOf('month'),
                minDate: '01/01/2020',
                maxDate: '{{ date('m/d/Y') }}',
                dateLimit: { days: 60 },
                showDropdowns: true,
                showWeekNumbers: true,
                timePicker: false,
                timePickerIncrement: 1,
                timePicker12Hour: true,
                ranges: {
                    '@lang('home.Today')': [moment(), moment()],
                    '@lang('home.Yesterday')': [moment().subtract('days', 1), moment().subtract('days', 1)],
                    '@lang('home.Last 7 Days')': [moment().subtract('days', 6), moment()],
                    '@lang('home.Last 30 Days')': [moment().subtract('days', 29), moment()],
                    '@lang('home.This Month')': [moment().startOf('month'), moment().endOf('month')],
                    '@lang('home.Last Month')': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')],
                    @for($x=1;$x<=date('m');$x++)
                    '@lang('home.'.date('F', mktime(0, 0, 0, $x, 10)))': [new Date('{{ date('Y-m-d H:i:s',strtotime('first day of '.date('F', mktime(0, 0, 0, $x, 10)))) }}'), new Date('{{ date('Y-m-d H:i:s',strtotime('last day of '.date('F', mktime(0, 0, 0, $x, 10)))) }}')],
                    @endfor
                },
                opens: 'left',
                buttonClasses: ['btn btn-default'],
                applyClass: 'btn-small btn-primary',
                cancelClass: 'btn-small',
                format: 'MM/DD/YYYY',
                separator: ' to ',
                locale: {
                    applyLabel: '@lang('home.Submit')',
                    fromLabel: '@lang('home.To')',
                    customRangeLabel: '@lang('home.Custom Range')',
                    daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr','Sa'],
                    monthNames: ['@lang('home.January')', '@lang('home.February')', '@lang('home.March')', '@lang('home.April')', '@lang('home.May')', '@lang('home.June')', '@lang('home.July')', '@lang('home.August')', '@lang('home.September')', '@lang('home.October')', '@lang('home.November')', '@lang('home.December')'],
                    firstDay: 1
                }
            },
            function(start, end) {
                console.log("Callback has been called!");
                $('#date-filter').parent().find('.from_date').val(start.format('YYYY-MM-DD'));
                $('#date-filter').parent().find('.to_date').val(end.format('YYYY-MM-DD'));
                $('#date-filter span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                datatable.draw();
                $('.month-name').hide();
            }
        );
    } );


    setTimeout(function() {
        $('.datepicker').datepicker();
    }, 1000);
</script>
@endsection
