@extends('layouts.site')
@section('content')
<style type="text/css">
    .fa-star
    {
        color: #ffca08;
    }
    .fa-star-half
    {
        transform: rotate(180deg);
        color: #ffca08;
    }

     @media (max-width: 767px)
    {
        .mr1
        {
            text-align: center;
        }
    }
 
</style>

<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-5">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{ config('app.locale') == "en" ? $data->name_e : $data->name_a }}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>
<div class="mt-5 mb-5">
    <div class="container">
        @if (session('status'))
        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-info text-right" role="alert">
                    {{ session('status') }}
                </div>
            </div>
        </div>
        @endif
            @if (session('error'))
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger text-right" role="alert">
                            {{ session('error') }}
                        </div>
                    </div>
                </div>
            @endif
        <div class="row" >
            <div class="col-sm-5">
                <div class="boxing bg-white border row col-md-12 mx-0">
                    <div class="col-md-5 float-right pt-5 text-center">

                        <img src="{{((file_exists(public_path('avatars/therapists/'.$data->picture)) && $data->picture)?asset('avatars/therapists/'.$data->picture):asset('avatars/therapists/default_image.png'))}}" class="rounded-circle card-img-top shadow mx-1" style="width: 130px; height: 140px;" />

                        <h4 class="text-sm-center mt-3  colorsite">
                            {{ config('app.locale') == "en" ? $data->name_e : $data->name_a  }}
                        </h4>
                        <p class="text-sm-right mt-3">
                            {!! Str::limit((config('app.locale') == "ar")?strip_tags($data->main_specialty_ar):strip_tags($data->main_specialty_en),85) !!}
                        </p>
                        <div>

                            <?php

                            $reviews = [
                                (object)['rate' => round($avg_rating,1)],
                            ];
                            foreach ($reviews as $review) {
                                for ($i = 0; $i <= 5; ++$i) {
                                    echo '<i class="fa fa-star' ,
                                        ($review->rate == $i + .1 ? '-half' : '') ,
                                        ($review->rate == $i + .2 ? '-half' : '') ,
                                        ($review->rate == $i + .3 ? '-half' : '') ,
                                        ($review->rate == $i + .4 ? '-half' : '') ,
                                        ($review->rate == $i + .5 ? '-half' : '') ,
                                        ($review->rate == $i + .6 ? '-half' : '') ,
                                        ($review->rate == $i + .7 ? '-half' : '') ,
                                        ($review->rate == $i + .8 ? '-half' : '') ,
                                        ($review->rate == $i + .9 ? '-half' : '') ,
                                        ($review->rate <= $i ? '-o' : '') ,
                                        '" aria-hidden="true"></i>';
                                    echo "\n";
                                }
                                echo "\n";
                            }

                        ?>
                        <label>( {{ round($avg_rating,1) }} )</label>



                        </div>
                        
                        <div>

                            <label>{{ $data->sessions->whereIn('session_status',['reserved','closed'])->count() + 25 }}+  {{config('app.locale') == "en" ? 'Session' : ' جلسة '}}</label>
                        </div>
                        
                    </div>
                    <div class="col-md-7 float-right">
                        <div class="mr1">
                            <h3 class="mt-5 colorsite font-weight-bold">{{trans('home.information')}}</h3>
                            <div>
                                <label class="font-weight-bold">{{trans('home.lang')}} :</label>
                                <label style="font-weight:400">
                                        @if(!empty($languages ))
                                            @foreach ($languages as $language)
                                            {{ config('app.locale') == "en" ? $language->title_en : $language->title_ar  }}
                                            @endforeach
                                        @endif
                                </label>
                            </div>
                            <div>
                                <label class="font-weight-bold">{{trans('home.residence-country')}} :</label>
                                <label style="font-weight:400">
                                    {{  config('app.locale') == "en" ? $data->country->title_en : $data->country->title_ar}}
                                </label>
                            </div>
                            <div>
                                <label class="font-weight-bold">{{trans('home.join-date')}} :</label>
                                <label style="font-weight:400">
                                    @if($data->created_at != null)
                                    {{ $data->created_at->diffForHumans() }}
                                    @endif

                                </label>
                            </div>

                            <div>
                                <label class="font-weight-bold">{{ config('app.locale') == "en" ? 'Main focus' : ' التركيز الأساسي ' }} :</label>
                                <label style="font-weight:400">
                                    @if($data->main_focus != '' || $data->main_focus != null)
                                     {{ $data->main_focus }}
                                    @else
                                     @foreach($data->specialties as $speciality)
                                        {{  config('app.locale') == "en" ? $speciality->title_en : $speciality->title_ar}},
                                     @endforeach 
                                    @endif

                                </label>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
                {{--     <div class="boxing bg-white border d-none mt-5 col-md-12 clearfix ">
                    <ul class="nav nav-tabs mt-3" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                          <a   class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true"> {{trans('home.personal-profile')}} </a>
                        </li>
                        <li class="nav-item" role="presentation">
                          <a   class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">{{trans('home.Evaluation')}}</a>
                        </li>
                    </ul>
                    <div class="tab-content border-top border-light w-100" id="myTabContent">
                        <div class="tab-pane fade show active p-3 text-right" id="home" role="tabpanel" aria-labelledby="home-tab">

                            <div class="dynamic-align  @if(config('app.locale') == "en") text-left  @else   text-right  @endif ">

                                <ul class="list-group list-group-flush dynamic-align">
                                    {!!  config('app.locale') == "en" ?  $data->description_en : $data->description_ar  !!}
                                </ul>

                                <h3 class="colorsite font-weight-bold "> {{trans('home.certificates')}} </h3>
                                <ul class="list-group list-group-flush">



                                    {!!  config('app.locale') == "en" ?  $data->certifications_en : $data->certifications_ar  !!}
                                </ul>

                                <h3 class="colorsite font-weight-bold">{{trans('home.experiences')}}</h3>
                                <ul class="list-group list-group-flush">


                                        {!!  config('app.locale') == "en" ?  $data->experience_en : $data->experience_ar  !!}
                                </ul>

                            </div>


                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">




                          <div class="row mt-5 p-5 ">
                                @foreach ($data->reviews as $timeOne)
                                <div class="col-sm-5 border m-4 float-right bg-light text-right">
                                    <p>{{$timeOne->comment}}</p>
                                    <div>
                                        <div class="col">
                                            <?php
                                                   $visitor = \App\Visitor::find($timeOne->visitor_id);
                                                   if(isset($visitor))
                                                   {
                                                    $user = \App\User::find($visitor->user_id);
                                                   }
                                                ?>

                                            @if(isset($user))  {{ str_limit($user->name, $limit = 3, $end = '...') }} @endif
                                        </div>
                                        <div class="col">
                                            @if($timeOne->rating == 1)
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 2)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 3)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 4)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @else
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @endif
                                        </div>
                                        <div class="col">
                                            {{$timeOne->created_at}}
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>



                        </div>
                    </div>
                </div>--}}
            </div>
            <div class="col-sm-7">
                <div class="boxing bg-white border">
                    <div class="mr1 text-right">
                        <h3 class="mt-5 colorsite font-weight-bold text-center"> {{trans('home.sessions')}} </h3>
                    </div>
                    <div class="m-auto text-center">
                        @if($location&&$location->countryName=='Egypt')
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>30 @lang('home.minute') : {{$data->price30}}   @lang('home.EGP')</label><br/>
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>60  @lang('home.minute') : {{$data->price60}}  @lang('home.EGP')</label>
                        @else
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>30  @lang('home.minute') :  {{$data->thirty_price_dollar}} $</label><br/>
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>60  @lang('home.minute') : {{$data->sixty_price_dollar}} $</label><br/>
                        @endif
                    </div>
                    <!-- slider -->
                    @include('therapists.include.slider2')
            </div>

        </div>
            <div class="boxing bg-white border mt-5 col-md-12 clearfix ">
                <ul class="nav nav-tabs mt-3" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a  class="nav-link active" id="home-tab" data-toggle="tab"  role="tab" href="#home" aria-controls="home" aria-selected="true"> {{trans('home.personal-profile')}} </a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a   class="nav-link" id="profile-tab" data-toggle="tab" href="#profile"  role="tab" aria-controls="profile" aria-selected="false">{{trans('home.Evaluation')}}</a>
                    </li>
                </ul>
                <div class="tab-content border-top border-light w-100" id="myTabContent">
                    <div class="tab-pane fade show active p-3 text-right" id="home" role="tabpanel" aria-labelledby="home-tab">

                        <div class="dynamic-align  @if(config('app.locale') == "en") text-left  @else   text-right  @endif ">

                            <ul class="list-group list-group-flush dynamic-align">
                                {!!  config('app.locale') == "en" ?  $data->description_en : $data->description_ar  !!}
                            </ul>
                            <h3 class="colorsite font-weight-bold "> {{ trans('home.main-focus')  }} </h3>

                            <ul class="list-group list-group-flush">
                                @foreach($data->specialties as $speciality)
                                    {{  config('app.locale') == "en" ? $speciality->title_en : $speciality->title_ar}},
                                @endforeach

                                <!-- {{ config('app.locale') == "en" ?$data->main_focus:$data->main_focus }} -->
                            </ul>
                            <h3 class="colorsite font-weight-bold">{{trans('home.experiences')}}</h3>
                            <ul class="list-group list-group-flush">
                                {{--                                    @foreach($data->experiences as $certificateInfo)--}}
                                {{--                                        <li class="list-group-item">{{ $certificateInfo->name_ar}}</li>--}}
                                {{--                                    @endforeach--}}

                                {!!  config('app.locale') == "en" ?  $data->experience_en : $data->experience_ar  !!}
                            </ul>

                            <h3 class="colorsite font-weight-bold "> {{trans('home.certificates')}} </h3>
                            <ul class="list-group list-group-flush">

                                {{--                                    @foreach($data->certificates as $certificateInfo)--}}
                                {{--                                        <li class="list-group-item">{{ $certificateInfo->name_ar}}</li>--}}
                                {{--                                    @endforeach--}}

                                {!!  config('app.locale') == "en" ?  $data->certifications_en : $data->certifications_ar  !!}
                            </ul>



                        </div>


                    </div>
                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="row mt-5 p-5 ">

@if(count($data->reviews) >0)
                            @foreach ($data->reviews->reverse() as $timeOne)
                                <div class="col-sm-5 border m-4 float-right bg-light text-right">
                                    
                                    <div>
                                        <div class="col">
                                            <?php
                                                   $visitor = \App\Visitor::find($timeOne->visitor_id);
                                                   if(isset($visitor))
                                                   {
                                                    $user = \App\User::find($visitor->user_id);
                                                   }
                                                   else
                                                   {
                                                    $user = '';
                                                   }
                                                ?>

                                           <i class="fa fa-user"></i> @if($user != '') {{ \Illuminate\Support\Str::limit($user->name, 3, $end='...') }} @else ...... @endif

                                        </div>
                                        <div class="col">
                                            @if($timeOne->rating == 1)
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 2)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 3)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 4)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @else
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @endif
                                        </div>
                                        <div class="col">
                                             {{ date('Y-m-d H:i:s', strtotime($timeOne->created_at))}}
                                        </div>
                                    </div>
                                    <p class="col">{{$timeOne->comment}}</p>
                                </div>
                            @endforeach
                            @else
                            <h3> {{ trans('home.no_reviews')  }} </h3>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
    </div>
</div>


  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.3.1/js/bootstrap.bundle.min.js"></script>



@endsection


