@extends('layouts.site')
@section('content')

<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-5">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{ config('app.locale') == "en" ? $data->name_e : $data->name_a }}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>

<div class="mt-5 mb-5">
    <div class="container">
        @if (session('status'))
        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-info text-right" role="alert">
                    {{ session('status') }}
                </div>
            </div>
        </div>
        @endif
        <div class="row" >
            <div class="col-sm-5">
                <div class="boxing bg-white border row col-md-12 mx-0">
                    <div class="col-md-5 float-right pt-5 text-center">
                        <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow mx-1" style="width: 130px; height: 140px;" />
                        <h4 class="text-sm-center mt-3  colorsite">
                            {{ config('app.locale') == "en" ? $data->name_e : $data->name_a  }}
                        </h4>
                        <h6 class="mb-4 colorsite">{{$data->main_specialty}}</h6>
                        <div>
                            @for($x=1;$x<=$data->rating;$x++)
                                <span class="fa fa-star text-warning"></span>
                            @endfor
                            @for($y=$x;$y<=5;$y++)
                                <span class="fa fa-star"></span>
                            @endfor
                            <label>(@lang('home.Evaluation') {{ $data->rating }} )</label>
                        </div>
                        <div>
                            <label>{{trans('home.sessions-count')}}: {{ $data->sessions->where('session_status','reserved')->count() }}</label>
                        </div>
                    </div>
                    <div class="col-md-7 float-right">
                        <div class="mr1 text-center">
                            <h3 class="mt-5 colorsite font-weight-bold">{{trans('home.information')}}</h3>
                            <div>
                                <label class="font-weight-bold">{{trans('home.lang')}} :</label>
                                <label>
                                        @if(!empty($languages ))
                                            @foreach ($languages as $language)
                                            {{ config('app.locale') == "en" ? $language->title_en : $language->title_ar  }}
                                            @endforeach
                                        @endif
                                </label>
                            </div>
                            <div>
                                <label class="font-weight-bold">{{trans('home.residence-country')}} :</label>
                                <label>
                                    {{  config('app.locale') == "en" ? $data->country->title_en : $data->country->title_ar}}
                                </label>
                            </div>
                            <div>
                                <label class="font-weight-bold">{{trans('home.join-date')}} :</label>
                                <label>
                                    {{ date('Y-m-d',strtotime($data->created_at)) }}

                                </label>
                            </div>

                            <div>
                                <label class="font-weight-bold"> {{ trans('home.main-focus')  }} </label>
                                <label>
                                    @foreach($data->specialties as $key=>$specialty)
                                        {{ (count($data->specialties)==$key+1) ? $specialty->title_ar:$specialty->title_ar.',' }}
                                    @endforeach

                                </label>
                            </div>

                            <p class="text-sm-right mt-3">

                            </p>
                        </div>
                    </div>
                </div>
                <div class="boxing bg-white border mt-5 col-md-12 clearfix ">
                    <ul class="nav nav-tabs mt-3" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                          <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true"> {{trans('home.personal-profile')}} </a>
                        </li>
                        <li class="nav-item" role="presentation">
                          <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">{{trans('home.Evaluation')}}</a>
                        </li>
                    </ul>
                    <div class="tab-content border-top border-light w-100" id="myTabContent">
                        <div class="tab-pane fade show active p-3 text-right" id="home" role="tabpanel" aria-labelledby="home-tab">

                            <div class="dynamic-align  @if(config('app.locale') == "en") text-left  @else   text-right  @endif ">

                                <ul class="list-group list-group-flush dynamic-align">
                                    {!!  config('app.locale') == "en" ?  $data->description_en : $data->description_ar  !!}
                                </ul>

                                <h3 class="colorsite font-weight-bold "> {{trans('home.certificates')}} </h3>
                                <ul class="list-group list-group-flush">

{{--                                    @foreach($data->certificates as $certificateInfo)--}}
{{--                                        <li class="list-group-item">{{ $certificateInfo->name_ar}}</li>--}}
{{--                                    @endforeach--}}

                                    {!!  config('app.locale') == "en" ?  $data->certifications_en : $data->certifications_ar  !!}
                                </ul>

                                <h3 class="colorsite font-weight-bold">{{trans('home.experiences')}}</h3>
                                <ul class="list-group list-group-flush">
{{--                                    @foreach($data->experiences as $certificateInfo)--}}
{{--                                        <li class="list-group-item">{{ $certificateInfo->name_ar}}</li>--}}
{{--                                    @endforeach--}}

                                        {!!  config('app.locale') == "en" ?  $data->experience_en : $data->experience_ar  !!}
                                </ul>

                            </div>


                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="row mt-5 p-5 ">
                                @foreach ($data->reviews as $timeOne)
                                <div class="col-sm-5 border m-4 float-right bg-light text-right">
                                    <p>{{$timeOne->comment}}</p>
                                    <div>
                                        <div class="col">
                                            {{\App\User::where('id',\App\Visitor::where('id',$timeOne->visitor_id)->first()->user_id)->first()->name}}
                                        </div>
                                        <div class="col">
                                            @if($timeOne->rating == 1)
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 2)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 3)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @elseif($timeOne->rating == 4)
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @else
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                                <span class="fa fa-star text-warning"></span>
                                            @endif
                                        </div>
                                        <div class="col">
                                            {{$timeOne->created_at}}
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-7">
                <div class="boxing bg-white border">
                    <div class="mr1 text-right">
                        <h3 class="mt-5 colorsite font-weight-bold text-center"> {{trans('home.sessions')}} </h3>
                    </div>
                    <div class="m-auto text-center">
                        @if( config('app.locale') == "ar")
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>30 دقيقة : {{$data->price30}} جنيه</label><br/>
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>60 دقيقة : {{$data->price60}} جنيه</label>
                        @else
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>30 minute :  {{$data->price30}} pound </label><br/>
                            <label><i class="fas fa-money-bill-alt text-success"></i></label>
                            <label>60 minute : {{$data->price60}} pound </label><br/>
                        @endif
                    </div>
                    <!-- slider -->
                    @if(count($theapistSessions))
                    <div id="carouselExampleControls" class="carousel slide pb-4 pr-4 pl-4" data-ride="carousel">
                        <div class="carousel-inner">
                         <?php $i = 0 ; ?>
                         @foreach($theapistSessions as $SessionsInfo)
                                   @if($loop->first)
                                   <div class="carousel-item active">
                                    @else
                                   <div class="carousel-item">
                                    @endif
                                       <div class="row">
                                       @foreach($SessionsInfo as $singleSession)
                                               <div class="col-md-4">
                                                   <div class="card">
                                                       <div class="row justify-content-center my-2 ">
                                                           <p class="boxing p-2 bg-success text-white text-center">
                                                               {{ Date::today()->addDays($i)->format('l') }} <br/>
                                                               {{ date('Y-m-d', strtotime("+0+$i day")) }}
                                                           </p>
                                                       </div>
                                                       <div class="row justify-content-start mx-2">
                                                           @foreach($timeTables as $dayInfo)
                                                               @if($dayInfo->myDate == date('Y-m-d', strtotime("+0+$i day")))
                                                                   @php
                                                                       $noTimes = 1
                                                                   @endphp
                                                                   <div class="col-12">
                                                                       <div class="p-3 float-right @if (is_null($dayInfo->visitor_id)) bg-light @else bg-info @endif text-center my-3" style="width:99%;" >
                                                                               <label> {{$dayInfo->type}} {{trans('home.minutes')}} </label><br />
                                                                               @if (is_null($dayInfo->visitor_id))
                                                                                   <a href="{{route('book',[$dayInfo->id])}}">{{$dayInfo->start_time}}</a><br/>
                                                                                   {{trans('home.from')}} : {{\Carbon\Carbon::parse($dayInfo->start_time)->format('H:i A')}} <br />
                                                                               {{trans('home.to')}} : {{\Carbon\Carbon::parse($dayInfo->start_time)->addMinutes($dayInfo->type)->format('H:i A')}}
                                                                               @else
                                                                                   {{$dayInfo->start_time}}
                                                                               @endif

                                                                               @if($dayInfo->visitor_id && $dayInfo->status == '2')
                                                                                   <label style="color:#fff"> {{trans('home.Session-Reserved')}} </label><br />
                                                                               @endif

                                                                       </div>
                                                                   </div>
                                                               @endif
                                                           @endforeach
                                                           @if($noTimes == 0)
                                                               <div class="col-12">
                                                                   <div class="p-3 float-right bg-light text-center my-3" style="width:99%;" >
                                                                       <label> {{trans('home.No-appointments-available')}} </label><br />
                                                                   </div>
                                                               </div>
                                                           @endif
                                                           @php
                                                               $noTimes = 0
                                                           @endphp
                                                       </div>
                                                   </div> <!-- card -->
                                               </div> <!-- col-md-4 -->
                                               <?php $i++ ; ?>
                                           @endforeach
                                       </div>
                                   </div>
                            @endforeach
                        </div>
                        <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                    </div>
                    <!-- End Slider -->

                </div>
                    @endif
            </div>

        </div>
    </div>
</div>
@endsection

<script>

</script>
