@extends('layouts.site')

@section('content')

<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area">
                                <h2 class="lgx-heading lgx-heading-brand">
                                    <span class="back-heading"><i class="fa fa-map-marker" aria-hidden="true"></i></span>
                                    <span class="heading">{{trans('auth.signup')}}</span>
                                </h2>
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{trans('auth.signup')}}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>

<div class="lgx-schedule">
    <div class="container-fluid">
        <div class="row justify-content-center lgx-inner">
            
            <div class="col-md-7">
                
                <div id="lgx-testimonials"  class="lgx-testimonials">
                    <div class="lgx-inner">
                        <div class="container">
                            <div class="lgx-content">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="lgx-testiowlarea">
                                            <div id="lgx-owltestimonial" class="owl-carousel lgx-owltestimonial">
                                                @foreach ($testimonial as $item)
                                                <div class="item lgx-fadeInLeft">
                                                    <figure class="lgx-client-image">
                                                        <figcaption class="lgx-zoomIn-q">
                                                            <i class="fa fa-quote-left"></i>
                                                        </figcaption>
                                                    </figure>
                                                    <div class="testi-info-area">
                                                        <p class="lgx-review">
                                                            {{$item->comment}}
                                                        </p>
                                                        <h4 class="lgx-client-name">{{$item->visitor->name}}</h4>
                                                    </div>
                                                </div> <!--//.Item-->
                                                @endforeach
                                            </div><!--l//#LGX-OWL TESTIMONIAL-->
                                        </div>
                                    </div> <!--//.COL 12 -->
                                </div> <!--//.ROW-->
                            </div> <!--//.LGX CONTENT-->
                        </div> <!--//.CONTAINER-->
                    </div><!--//.LGX INNER-->
                </div>
            </div>
            <div class="col-md-5">
                <div class="lgx-tab">
                    <div class="align-items-center pt-3 boxing">
                        
                        
                        <form method="POST" action="{{ route('register') }}" class="col align-self-center">
                            @csrf
    
                            <div class="form-group">
                                <input id="name" type="text" class="forminput form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus placeholder="{{trans('auth.name')}}">
                                @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                            <div class="form-group">
                                <input id="email" type="email" class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="{{trans('auth.email')}}">
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                            <div class="form-group">
                                <input id="password" type="password" class="forminput form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="{{trans('auth.password')}}">
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                            <div class="form-group">
                                <input id="password-confirm" type="password" class="forminput form-control" name="password_confirmation" required autocomplete="new-password" placeholder="{{trans('auth.passwordconfirm')}}">
                                @error('password_confirmation')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                            <div class="form-group">
                                <div class="col-md-12">
                                    <button type="submit" class="lgx-btn" style="width: 100%">
                                        {{ trans('auth.signup') }}
                                    </button>
                                </div>
                            </div>
                            <div>
                                <a href="{{route('login')}}#doctor-login">{{ trans('auth.login') }}</a>
                            </div>
                        </form>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
