@extends('layouts.site')

@section('content')
<style>
    div.cv {
        position: relative;
    overflow: hidden;
  //  margin: 10px;
    }

    #cv {
        position: absolute;
    top: 0;
    right: 0;
    margin: 0;
    padding: 0;
    font-size: 20px;
    cursor: pointer;
    opacity: 0;
    filter: alpha(opacity=0);

    }

    div.qualification {
        position: relative;
    overflow: hidden;
   // margin: 10px;
    }

    #qualification {
        position: absolute;
    top: 0;
    right: 0;
    margin: 0;
    padding: 0;
    font-size: 20px;
    cursor: pointer;
    opacity: 0;
    filter: alpha(opacity=0);

    }

    div.fakefile {
        /*position: absolute;
        top: 0;
        left: 0;
        z-index: 1;*/
       // width: 440px
    }
    .new p
    {
        font-size: 14px;
    }

    .pre 
    {
        white-space: pre-wrap;
        padding: 15px 0;
    }

    .new h3 
    {
        color: #b856ff;
        font-size: 20px;
    }
    .new .btn-success
    {
        margin: 30px 0;
        font-size: 17px;
    }
    .new .btn-success:hover
    {
        font-size: 17px;
    }
    .list-unstyled
    {
       padding-right: 0;
    }
    .list-unstyled li 
    {
        background: #fdfdfd;
        padding: 20px;
        direction: rtl;
        box-shadow: 0 0 5px #06b7cb;
        margin-bottom: 10px;
        transition: all 0.2s;
        height: 100%;
    }
    .list-unstyled li:hover
    {
        box-shadow: none;
        background: #ededed;
    }
    .list-unstyled li div 
    {
        font-size: 17px;
        color: #0ab7cb;
        margin-bottom: 4px;
    }
    .list-unstyled li div i 
    {
        margin-left: 8px;
        font-size: 35px;
    }


</style>
<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-4">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{trans('auth.signup')}}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>

<div class="lgx-schedule registerstyle">
    <div class="container my-5">
        <div class="row justify-content-center lgx-inner dynamic-form" >
            <div class="col-md-4">
                <div class="lgx-tab">
                    <div class="align-items-center p-md-5 p-3 boxing">
                        <img src="{{ asset('images/register.jpg') }}" width="100%">
                    </div>
                </div>
            </div>
            <div class="col-md-8 new">
                <h3> @lang('home.Welcome Our dear advisor') </h3>
                <p dir="rtl" class="pre">@lang('home.welcome_message')</p>

                @if(config('app.locale') == "en")
                <a class="btn btn-success btn-lg" href="{{ url('/en/therapist/registration/form') }}">  @lang('home.join_us')  </a>
                @else
                <a class="btn btn-success btn-lg" href="{{ url('/therapist/registration/form') }}">  @lang('home.join_us')  </a>
                @endif
                <!-- adv -->
            
            </div>

            <div class="col-md-12 new">
                <h3 style="    font-size: 23px;text-align: center;margin: 38px 0;">@lang('home.Benefits')</h3>

                <ul class="list-unstyled row" dir="rtl">

                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-users"></i>  @lang('home.Spread')</div>
                        <p class="desc">@lang('home.a')</p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-address-card"></i>   @lang('home.professional development') </div>
                        <p class="desc"> @lang('home.b')</p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-building"></i>  @lang('home.Virtual clinic closer to reality') </div>
                        <p class="desc"> @lang('home.c')  </p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-chart-line"></i>  @lang('home.programmed psychological scales') </div>
                        <p class="desc"> @lang('home.d')</p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-bullseye"></i> @lang('home.marketing')</div>
                        <p class="desc"> @lang('home.e')</p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-pound-sign"></i> @lang('home.Sufficient income')</div>
                        <p class="desc"> @lang('home.f') </p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-headphones"></i> @lang('home.Effective professional communication with clients') </div>
                        <p class="desc"> @lang('home.g')</p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">

                    <li>
                        <div class="title"> <i class="fa fa-briefcase"></i>  @lang('home.Specialty')</div>
                        <p class="desc"> @lang('home.h')</p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-network-wired"></i>  @lang('home.work flexibility')  </div>
                        <p class="desc"> @lang('home.i')</p>
                    </li>
                    </div>
                    <div class="col-md-4 mb-5">
                    <li>
                        <div class="title"> <i class="fa fa-ellipsis-v"></i> @lang('home.More') </div>
                        <p class="desc">  @lang('home.j')</p>
                    </li>
                    </div>
                    
                </ul>
            </div>

            
        </div>
    </div>
</div>
@endsection
@section('scriptSection')
    <script>
        jQuery.validator.addMethod("noSpace", function(value, element) {
            return value.indexOf(" ") < 0 && value != "";
        }, "No space please and don't leave it empty");

        jQuery.validator.addMethod("NoSpecialCharacter", function(value, element) {
            return this.optional(element) || /^[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]+[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]*$/.test(value);
        }, "No Special Characters");
        $.validator.addMethod(
            "phoneUS",
            function(value, element, regexp) {
                var re = new RegExp("(01)[0-9]{9}");
                return this.optional(element) || re.test(value);
            },
            "@lang('home.phone_validation')"
        );
        $(document).ready(function(){
            $(document).on('change','#country_id',function(){
                $("#registerForm").valid();
            })
            $("#registerForm").validate({
                errorPlacement: function(error, element) {
                    // Append error within linked label
                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                success: function(label,element) {
                    console.log('asdasdas')
                    //var parent = $('.success').parent().get(0); // This would be the <a>'s parent <li>.
                    //$(parent).addClass('has-success');
                },
                rules : {
                    name:{
                        required:true,
                        minlength : 2,
                        NoSpecialCharacter: true,
                    },
                    email : {
                        email:true,
                        required:true,
                        minlength : 4,
                    },
                    phone:{
                        required:true,
                       // minlength : 11,
                        // phoneUS:true,
                        noSpace:true
                    },
                    country_id:{
                        required:true,
                    },
                    password:{
                        required:true,
                        minlength : 8,
                        noSpace:true
                    },
                    password_confirmation:{
                        required:true,
                        minlength : 8,
                        equalTo:"#password",
                    },
                    agreement:{
                        required:true,
                    },
                },
                messages: {
                    name:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_2_field')",
                        NoSpecialCharacter: "@lang('home.no_numbers_and_SpecialCharacter')",
                    },
                    email : {
                        email:"@lang('home.email_valid_field')",
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                    phone:{
                        required:"@lang('home.phone_valid_field')",
                        minlength : "@lang('home.minlength_11_field')",
                        phoneUS:"@lang('home.phone_validation')",
                        noSpace:"@lang('home.prevent_space')",
                    },
                    country_id:{
                        required:"@lang('home.required_field')",
                    },
                    password:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_8_field')",
                        noSpace:"@lang('home.prevent_space')",
                    },
                    password_confirmation:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_8_field')",
                        equalTo:"@lang('home.equalTo_field')",
                    },
                    agreement:{
                        required:"@lang('home.agreement_field')",
                    },
                },
            });
        });
    </script>
@endsection
