@extends('layouts.site')

@section('content')
<style>
    div.cv {
        position: relative;
    overflow: hidden;
  //  margin: 10px;
    }

    #cv {
        position: absolute;
    top: 0;
    right: 0;
    margin: 0;
    padding: 0;
    font-size: 20px;
    cursor: pointer;
    opacity: 0;
    filter: alpha(opacity=0);

    }

    div.qualification {
        position: relative;
    overflow: hidden;
   // margin: 10px;
    }

    #qualification {
        position: absolute;
    top: 0;
    right: 0;
    margin: 0;
    padding: 0;
    font-size: 20px;
    cursor: pointer;
    opacity: 0;
    filter: alpha(opacity=0);

    }

    div.fakefile {
        /*position: absolute;
        top: 0;
        left: 0;
        z-index: 1;*/
       // width: 440px
    }
</style>
<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-4">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{trans('auth.signup')}}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>

<div class="lgx-schedule registerstyle">
    <div class="container-fluid">
        <div class="row justify-content-center lgx-inner dynamic-form" >
            <div class="col-md-7">

                 <div id="lgx-testimonials"  class="lgx-testimonials">
                    <div class="lgx-inner">
                        <div class="container">
                            <div class="lgx-content">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="lgx-testiowlarea">
                                            <div id="lgx-owltestimonial" class="owl-carousel lgx-owltestimonial">
                                                @foreach ($services as $item)
                                                <div class="item lgx-fadeInLeft">
                                                    <figure class="lgx-client-image">
                                                        <figcaption class="lgx-zoomIn-q">
                                                            <i class="fa fa-quote-left"></i>
                                                        </figcaption>
                                                    </figure>
                                                    <div class="testi-info-area">
                                                        <p class="lgx-review">
                                                            {{  config('app.locale') == "ar" ?  $item->title_ar:$item->title_en}}
                                                        </p>
                                                    </div>
                                                </div> 
                                                @endforeach
                                            </div>
                                        </div>
                                    </div> 
                                </div> 
                            </div> 
                        </div>
                    </div>
                </div> 

            </div>
            <div class="col-md-5">
                <div class="lgx-tab">
                    <div class="align-items-center p-md-5 p-3 boxing">
                        <form method="POST" id="registerForm" action="{{ route('therapist_reg') }}" class="row align-self-center" enctype="multipart/form-data" data-parsley-validate="">
                            @csrf
                            <div class="form-group col-lg-12">
                                <input id="name" type="text" class="forminput form-control" name="name" value="{{ old('name') }}"  autocomplete="name" autofocus
                                       placeholder="{{trans('auth.name')}} *"
                                data-parsley-required="true"
                                data-parsley-required-message="{{trans('home.input-required')}}"
                                >
                                <label for="error-name"></label>
                                @error('name')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">
                                        {{ $message }}
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>
                                @enderror
                            </div>

                            <div class="form-group col-lg-12">
                                <input id="email" type="email" class="forminput form-control" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="{{trans('auth.email')}} *"
                                data-parsley-required="true"
                                data-parsley-required-message="{{trans('home.input-required')}}"
                                >
                                <label for="error-email"></label>
                                @error('email')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                    </button>
                                  </p>
                                @enderror
                            </div>

                            <div class="form-group col-lg-8">
                                <input id="phone" type="number" min="0" class="forminput form-control" name="phone"   placeholder="{{trans('auth.phone')}} *"
                                data-parsley-required="true"
                                data-parsley-required-message="{{trans('home.input-required')}}"
                                >
                                <label for="error-phone"></label>
                                @error('phone')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert" style="color:red">{{ $message }}
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>
                                @enderror
                            </div>
                            <div class="form-group col-lg-4 mt-2">
                                <select name="country_id" class="form-control select2" id="country_id">
                                    <option value="">@lang('home.Select Country') *</option>
                                    @foreach(\Illuminate\Support\Facades\DB::table('country')->get() as $country)
                                        <option data-code="{{ $country->code }}" value="{{ $country->id }}">{{ (app()->getLocale()=='ar')?$country->arab_name:$country->name }} {{ $country->code }}</option>
                                    @endforeach
                                </select>
                                <label for="error-country_id"></label>
                            </div>


                            <div class="form-group cv  col-lg-12">


                                <input id="cv" type="file" class="forminput form-control" name="cv"   placeholder="{{trans('auth.cv')}}">



                                    <div class="fakefiles form-group">
                                        <input readonly id="filename"   placeholder="{{trans('auth.cv')}}" class="forminput form-control" />
                                    </div>

                                <label for="error-cv"></label>
                                @error('cv')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                    </button>
                                  </p>
                                @enderror
                            </div>

                            <div class="form-group qualification col-lg-12">

                                <input id="qualification" type="file" class="forminput form-control" name="qualification" value="{{ old('qualification') }}"  placeholder="{{trans('auth.qualification')}}"
                                data-parsley-required="true"
                                data-parsley-required-message="{{trans('home.input-required')}}"
                                >

                                    <div class="fakefile2 form-group">
                                        <input readonly id="uploadq"  placeholder="{{trans('auth.qualification')}}" class="forminput form-control" />
                                    </div>

                                <label for="error-qualification"></label>
                                @error('qualification')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                    </button>
                                  </p>
                                @enderror
                            </div>



                            <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
                            <script>
                                document.getElementById('cv').onchange = uploadOnChange;

                                function uploadOnChange() {
                                    var filename = this.value;
                                    var lastIndex = filename.lastIndexOf("\\");
                                    if (lastIndex >= 0) {
                                      filename = filename.substring(lastIndex + 1);
                                    }
                                    document.getElementById('filename').value = filename;
                                  }
                                  document.getElementById('qualification').onchange = uploadOnChange2;

                                  function uploadOnChange2() {
                                      var filename = this.value;
                                      var lastIndex = filename.lastIndexOf("\\");
                                      if (lastIndex >= 0) {
                                        filename = filename.substring(lastIndex + 1);
                                      }
                                      document.getElementById('uploadq').value = filename;
                                    }
                                </script>

                            <div class="form-group col-lg-12">
                                <input id="password" type="password" class="forminput form-control" name="password"  autocomplete="new-password" placeholder="{{trans('auth.password')}} *"
                                data-parsley-required="true"
                                data-parsley-required-message="{{trans('home.input-required')}}"
                                >
                                <label for="error-password"></label>
                                @error('password')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert" style="color:red">{{ $message }}
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>
                                @enderror
                            </div>


                            <div class="form-group col-lg-12">

                                <input id="password-confirm" type="password" class="forminput form-control" name="password_confirmation"  autocomplete="new-password" placeholder="{{trans('auth.password-confirm')}} *"
                                data-parsley-required="true"
                                data-parsley-required-message="{{trans('home.input-required')}}"
                                >
                                <label for="error-password-confirm"></label>
                            </div>




                            <div class="form-group col-lg-12">
                                <div class="form-check d-flex justify-content-start p-4"  @if(config('app.locale') == "en") dir="ltr" @else  dir="rtl"  @endif>
                                    <input type="checkbox" class="form-check-input mx-2" id="agreement" value="1" name="agreement" >
                                    <label class="mx-5" for=r"exampleCheck1">
                                        {{trans('home.agreement')}}
                                        <a target="_blank" href="{{route('page_view',trans('home.Terms_Conditions_url'))}}"> {{trans('auth.here')}} </a>

                                    </label>
                                </div>
                                <label for="error-agreement"></label>
                                @if($errors->has('agreement'))
                                    <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">
                                        {{ $errors->first('agreement') }}
                                        <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>

                                @endif

                            </div>

                            <div class="form-group col-lg-12">
                                <div class="col-md-12 px-0">
                                    <button type="submit" class="lgx-btn" style="width: 100%">
                                        {{ trans('auth.signup') }}
                                    </button>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <a href="{{route('login')}}#doctor-login">{{ trans('auth.login') }}</a>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scriptSection')
    <script>
        jQuery.validator.addMethod("noSpace", function(value, element) {
            return value.indexOf(" ") < 0 && value != "";
        }, "No space please and don't leave it empty");

        jQuery.validator.addMethod("NoSpecialCharacter", function(value, element) {
            return this.optional(element) || /^[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]+[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]*$/.test(value);
        }, "No Special Characters");
        $.validator.addMethod(
            "phoneUS",
            function(value, element, regexp) {
                var re = new RegExp("(01)[0-9]{9}");
                return this.optional(element) || re.test(value);
            },
            "@lang('home.phone_validation')"
        );
        $(document).ready(function(){
            $(document).on('change','#country_id',function(){
                $("#registerForm").valid();
            })
            $("#registerForm").validate({
                errorPlacement: function(error, element) {
                    // Append error within linked label
                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                success: function(label,element) {
                    console.log('asdasdas')
                    //var parent = $('.success').parent().get(0); // This would be the <a>'s parent <li>.
                    //$(parent).addClass('has-success');
                },
                rules : {
                    name:{
                        required:true,
                        minlength : 2,
                        NoSpecialCharacter: true,
                    },
                    email : {
                        email:true,
                        required:true,
                        minlength : 4,
                    },
                    phone:{
                        required:true,
                       // minlength : 11,
                        // phoneUS:true,
                        noSpace:true
                    },
                    country_id:{
                        required:true,
                    },
                    password:{
                        required:true,
                        minlength : 8,
                        noSpace:true
                    },
                    password_confirmation:{
                        required:true,
                        minlength : 8,
                        equalTo:"#password",
                    },
                    agreement:{
                        required:true,
                    },
                },
                messages: {
                    name:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_2_field')",
                        NoSpecialCharacter: "@lang('home.no_numbers_and_SpecialCharacter')",
                    },
                    email : {
                        email:"@lang('home.email_valid_field')",
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                    phone:{
                        required:"@lang('home.phone_valid_field')",
                        minlength : "@lang('home.minlength_11_field')",
                        phoneUS:"@lang('home.phone_validation')",
                        noSpace:"@lang('home.prevent_space')",
                    },
                    country_id:{
                        required:"@lang('home.required_field')",
                    },
                    password:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_8_field')",
                        noSpace:"@lang('home.prevent_space')",
                    },
                    password_confirmation:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_8_field')",
                        equalTo:"@lang('home.equalTo_field')",
                    },
                    agreement:{
                        required:"@lang('home.agreement_field')",
                    },
                },
            });
        });
    </script>
@endsection
