@extends('layouts.site')
@section('headScript')
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/css/bootstrap-datetimepicker.min.css">
    <style>
        .timepicker .timepicker-picker table.table-condensed{
            direction: ltr;
            position: relative;
            left: 35px;
        }
    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-4">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('auth.signup')}}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header text-center">
                    <h5 class="modal-title w-100" id="exampleModalLabel"> {{trans('home.image-rule')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <ol style="list-style: none" class="mx-3">
                            <li>
                                <h6>
                                    <strong>  {{trans('home.for-women')}} </strong>
                                    {{trans('home.women-desc')}}
                                </h6>
                            </li>
                            <li>
                                <h6>
                                    <strong> {{trans('home.for-mens')}}</strong>

                                    {{trans('home.mens-desc')}}
                                </h6>
                            </li>
                            <li></li>
                        </ol>
                    </div> <!-- form-row -->
                </div> <!-- modal-body -->
            </div>
        </div>
    </div>
    <div>
        <div class="container-fluid">
            <div class="row justify-content-center lgx-inner">
                <div class="col-md-8">
                    <div class="lgx-tab">
                        <div class="align-items-center pt-3 boxing">
                            {{--   @if(isset($therapist)&&$therapist)
                                   <div class="alert alert-info">
                                       @lang('home.The data has already been added')
                                   </div>
                               @else--}}
                            <form method="POST" id="step2RegisterForm" action="{{ route('sendEmailTherapist_post',['email'=>$email,'verifyToken'=>$verifyToken]) }}" data-parsley-validate="" class="col align-self-center dir-rtl" enctype='multipart/form-data' style="margin-bottom: 24px;">
                                @csrf
                                <input type="hidden" name="user_id" value="{{$user->id}}">
                                <div class="form-row">
                                    <div class="col-md-12 mb-3">
                                        <label for="validationDefault01"><strong>  @lang('home.Password') <span style="color:red;">*</span></strong></label>
                                        <input id="password" type="password" class="forminput form-control @error('password') is-invalid @enderror" name="password" value="{{ old('password') }}" autofocus autocomplete="password" placeholder="@lang('home.Password')"
                                               tabindex=1>
                                        <label for="error-password"></label>
                                        @error('password')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>
                                </div>

                                <button type="submit" class="lgx-btn my-4" style="width: -1%;">
                                    {{ trans('auth.login') }}
                                </button>
                            </form>
                            {{-- @endif--}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scriptSection')
    <script>
        //arabic characters

        $("#step2RegisterForm").validate({
            errorPlacement: function(error, element) {
                // Append error within linked label
                console.log('error')
                console.log(error)
                console.log(element)
                console.log(element.attr( "id" ))
                $( element )
                    .closest( "form" )
                    .find( "label[for='error-" + element.attr( "id" ) + "']" )
                    .append( error );
            },
            errorElement: "span",
            rules : {
                password : {
                    required:true,
                    minlength : 5,
                },

            },
            messages: {
                password : {
                    required:"@lang('home.required_field')",
                    minlength : "@lang('home.minlength_5_field')",
                },

            },
        });

    </script>
@endsection
