@extends('layouts.site')
@section('headScript')
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/css/bootstrap-datetimepicker.min.css">
    <style>
        .timepicker .timepicker-picker table.table-condensed{
            direction: ltr;
            position: relative;
            left: 35px;
        }
    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-4">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('auth.signup')}}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header text-center">
                    <h5 class="modal-title w-100" id="exampleModalLabel"> {{trans('home.image-rule')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <ol style="list-style: none" class="mx-3">
                            <li>
                                <h6>
                                    <strong>  {{trans('home.for-women')}} </strong>
                                    {{trans('home.women-desc')}}
                                </h6>
                            </li>
                            <li>
                                <h6>
                                    <strong> {{trans('home.for-mens')}}</strong>

                                    {{trans('home.mens-desc')}}
                                </h6>
                            </li>
                            <li></li>
                        </ol>
                    </div> <!-- form-row -->
                </div> <!-- modal-body -->
            </div>
        </div>
    </div>
    <div>
        <div class="container-fluid">
            <div class="row justify-content-center lgx-inner">
                <div class="col-md-8">
                    <div class="lgx-tab">
                        <div class="align-items-center pt-3 boxing">
                         {{--   @if(isset($therapist)&&$therapist)
                                <div class="alert alert-info">
                                    @lang('home.The data has already been added')
                                </div>
                            @else--}}
                            <form method="POST" id="step2RegisterForm" action="{{ route('StepRegstrion') }}" data-parsley-validate="" class="col align-self-center dir-rtl" enctype='multipart/form-data' style="margin-bottom: 24px;">
                                @csrf
                                <input type="hidden" name="user_id" value="{{$user->id}}">
                                <div class="form-row">
                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong>  @lang('home.Name (in Arabic)') <span style="color:red;">*</span></strong></label>
                                        <input id="name_a" type="text" class="forminput form-control @error('name_a') is-invalid @enderror" name="name_a" value="{{ old('name_a') }}" autofocus autocomplete="name_a" placeholder="الاسم باللغة العربية"
                                               tabindex=1>
                                        <label for="error-name_a"></label>
                                        @error('name_a')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong> @lang('home.Name (in English)') <span style="color:red;">*</span></strong></label>
                                        <input id="name_e" type="text" class="forminput form-control @error('name_e') is-invalid @enderror" name="name_e" value="{{ old('name_e') }}" autocomplete="name_e" placeholder="الاسم باللغة الانجليزية"
                                              tabindex=2>
                                        <label for="error-name_e"></label>
                                        @error('name_e')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>

                                </div>
                                <div class="form-row">

                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault04"><strong> @lang('home.Type')  <span style="color:red;">*</span> </strong></label>
                                        <select  class="forminput form-control select2  @error('gender')is-invalid @enderror" name="gender"  aria-hidden="true" style="width:100%" id="gender"
                                                 tabindex=3
                                        >
                                            <option value=""> @lang('home.Select Type') </option>
                                            @foreach($genders as $key=>$val)
                                                <option value="{{$key}}"  @if($key == old('gender')) selected  @endif>{!!  $val  !!}</option>
                                            @endforeach
                                        </select>
                                        <label for="error-gender"></label>
                                        @error('gender')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>
                                    <div class="col-md-6  mb-3">
                                        <label for="validationDefault04"><strong>  @lang('home.Country')  <span style="color:red;">*</span>    </strong></label>
                                        <select  class="forminput form-control select2  @error('country_id') is-invalid @enderror" name="country_id"  aria-hidden="true" style="width:100%"  id="country_id"
                                                 tabindex=4
                                        >
                                            <option value="">@lang('home.Select Country')</option>
                                            @foreach($countries as $country)
                                                <option value="{{$country->id}}"  @if($country->id == old('country_id')) selected  @endif >{{config('app.locale')=='ar'?$country->title_ar:$country->title_en}}
                                                </option>
                                            @endforeach
                                        </select>
                                        <label for="error-country_id"></label>
                                        @error('country_id')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-row">

                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong>@lang('home.license number') </strong></label>
                                        <input id="license_no" type="text" class="forminput form-control @error('license_no') is-invalid @enderror" name="license_no" value="{{ old('license_no') }}" autocomplete="license_no"  placeholder="رقم الرخصة"
                                               tabindex=5
                                        >
                                        <label for="error-license_no"></label>
                                        @error('license_no')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong> @lang('home.The authority issuing the license')</strong></label>
                                        <input id="license_org" type="text" class="forminput form-control @error('license_org') is-invalid @enderror" name="license_org" value="{{ old('license_org') }}" autocomplete="license_org"  placeholder="جهة إصدار الرخصة"
                                               tabindex=6
                                        >
                                        <label for="error-license_org"></label>
                                        @error('license_org')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong>@lang('home.Years of experience in electronic therapy and counseling (via the Internet)')  <span style="color:red;">*</span> </strong></label>
                                        <input id="years" min="1" type="text" class="not-under-one forminput form-control @error('years') is-invalid @enderror" name="years" value="{{ old('years') }}" autocomplete="years"  placeholder="{{trans('auth.years')}}"
                                               data-parsley-maxlength="15"
                                               tabindex=7>
                                        <label for="error-years"></label>
                                        @error('years')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong>@lang('home.Date of Birth')   <span style="color:red;">*</span>   </strong></label>
                                        {{-- <input class="form-control datepicker forminput" placeholder="Select Date" name="date" type="text"> --}}
                                        <input name="birth" id="birth" class="forminput form-control   @error('birth') is-invalid @enderror" type="text" value="{{ old('birth') }}" 
                                               placeholder="Y-m-d"
                                               tabindex=8
                                        >
                                        <label for="error-birth"></label>
                                        @error('birth')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong> {{trans('home.price30')}}   <span style="color:red;">*</span> </strong></label>
                                        <input id="price30" type="text" min="1" class="not-under-one forminput form-control @error('price30') is-invalid @enderror" name="price30" value="{{ old('price30') }}" autocomplete="years"  placeholder="{{trans('home.price30')}}"
                                               data-parsley-maxlength="15"
                                               tabindex=9>
                                        <label for="error-price30"></label>
                                        @error('price30')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault01"><strong> {{trans('home.price60')}}  <span style="color:red;">*</span> </strong></label>
                                        <input id="price60" type="text" min="1" class="not-under-one forminput form-control @error('price60') is-invalid @enderror" name="price60" value="{{ old('price60') }}" autocomplete="years"  placeholder="{{trans('home.price60')}}"
                                               data-parsley-maxlength="15"   tabindex=10>
                                        <label for="error-price60"></label>
                                        @error('price60')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault04"><strong> @lang('home.language')  <span style="color:red;">*</span>  </strong></label>
                                        <select  class="forminput form-control select2 @error('language_id') is-invalid @enderror" name="language_id"  aria-hidden="true" style="width:100%"  id="language_id"
                                                 tabindex=11
                                        >
                                            <option  value="">@lang('home.Select Language')</option>
                                            @foreach($langs as $lang)
                                                <option value="{{$lang->id}}"  @if($lang->id == old('language_id')) selected  @endif > {{config('app.locale')=='ar'?$lang->title_ar:$lang->title_en}} </option>
                                            @endforeach
                                        </select>
                                        <label for="error-language_id"></label>
                                        @error('language_id')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>


                                    <div class="col-md-6 mb-3">
                                        <label for="validationDefault04"><strong> @lang('home.Specialization')   </strong></label>
                                        <select id="speciality_id" class="forminput form-control select2  @error('speciality_id') is-invalid @enderror" multiple name="speciality_id[]" style="width:100%"
                                                tabindex=12
                                        >
                                            @foreach($prfixs as $prfix)
                                                <option value="{{$prfix->id}}"  @if(old('speciality_id')&&in_array($prfix->id,old('speciality_id'))) selected  @endif > {{$prfix->title}}</option>
                                            @endforeach
                                        </select>
                                        <label for="error-speciality_id"></label>

                                        @error('speciality_id')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                        @enderror

                                    </div>

                                </div>
                                <div class="form-row" style="margin-top: 20px;">
                                    <!-- Resume -->

                                    <!-- profile-picture -->

                                    <div class="col-lg-5 col-md-5 col-xs-10 col-sm-10 col-10 mb-5">

                                        <label style="position: absolute;top: -28px;color:red"><strong>@lang('home.uploadmoreimage') </strong></label>


                                        <div class="custom-file">
                                            <input type="file" name="picture[]" class="custom-file-input" multiple  value="{{ old('picture') }}"
                                                   tabindex=13>
                                            <label for="error-picture"></label>
                                            @error('picture')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                            <label class="custom-file-label"  for="customFile">
                                                @lang('home.Attach a personal photo')
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-1 col-md-1 col-xs-2 col-sm-2 col-2 mb-5">
                                        <button type="button" class="btn btn-primary btn-block" style="height: 42px;" data-toggle="modal" data-target="#exampleModal">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle" viewBox="0 0 16 16">
                                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                                <path d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286zm1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94z"/>
                                            </svg>
                                        </button>
                                    </div>
                                    {{--
                                    <div class="col-md-6 mb-5">
                                        <div class="custom-file">
                                            <input type="file" name="resume" class="custom-file-input"  value="{{ old('resume') }}"
                                                   tabindex=14
                                            >
                                            <label for="error-resume"></label>
                                            @error('resume')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                            <label class="custom-file-label"  for="customFile">
                                                @lang('home.Attach the CV')
                                            </label>
                                        </div>
                                    </div>
                                            --}}

                                </div>
                                <div class="form-row">

                                    <!-- licence -->
                                    <div class="col-md-6 mb-5">
                                        <div class="custom-file">
                                            <input type="file" name="licence" class="custom-file-input"   value="{{ old('licence') }}"
                                                   tabindex=15>
                                            <label for="error-licence"></label>
                                            @error('licence')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                            <label class="custom-file-label"  for="customFile">
                                                @lang('home.Attach the license')
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-5">
                                        <div class="custom-file">
                                            <input type="file" name="zip_certificates" class="custom-file-input" value="{{ old('zip_certificates') }}"
                                                   tabindex=16>
                                            <label for="error-zip_certificates"></label>
                                            @error('zip_certificates')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                            <label class="custom-file-label"  for="customFile">
                                                @lang('home.Attach certificates')
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="lgx-btn my-4" style="width: -1%;">
                                    {{ trans('auth.completeReg') }}
                                </button>
                            </form>
                            {{-- @endif--}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scriptSection')
    <script src="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/js/bootstrap-datetimepicker.min.js"></script>
    <script>

        //arabic characters
        jQuery.validator.addMethod("arabicLetters", function(value, element) {
            return this.optional(element) || /^([\u0600-\u06ff ]|[\u0750-\u077f ]|[\ufb50-\ufbc1 ]|[\ufbd3-\ufd3f ]|[\ufd50-\ufd8f ]|[\ufd92-\ufdc7 ]|[\ufe70-\ufefc ]|[\ufdf0-\ufdfd ]|[.]|[/]|[-]|[،])*$/g.test(value);
        }, "arabicLetters only please");

        //English characters
        jQuery.validator.addMethod("englishLetters", function(value, element) {
            return this.optional(element) || /^[a-z ]|[.]|[/]|[-]|[,]+$/i.test(value);
        }, "englishLetters only please");

        //arabic with english mix
        jQuery.validator.addMethod("letters", function(value, element) {
            return this.optional(element) || /^[a-zA-Z\u0600-\u06FF,-][\sa-zA-Z\u0600-\u06FF,-]*$/.test(value);
        }, "Letters only please");
        jQuery.validator.addMethod("speciality_id", function(value, element) {
           if(value.length==3&&$.inArray("24",value)!=-1&&$.inArray("25",value)!=-1&&$.inArray("27",value)!=-1){
               return true;
           }else if(value.length==2||value.length==1||value.length==0){
               return true;
           }
           return false;
        }, "يمكنك فقط اختيار تخصصين او (استشارات المقبلين على الزواج، علاج المشاكل الزواجية والأسرية، التأهيل النفسي بعد الطلاق)");
        $("#step2RegisterForm").validate({
            errorPlacement: function(error, element) {
                // Append error within linked label
                console.log('error')
                console.log(error)
                console.log(element)
                console.log(element.attr( "id" ))
                $( element )
                    .closest( "form" )
                    .find( "label[for='error-" + element.attr( "id" ) + "']" )
                    .append( error );
            },
            errorElement: "span",
            rules : {
                name_a : {
                    required:true,
                    minlength : 2,
                    arabicLetters: true,
                },
                name_e : {
                    required:true,
                    minlength : 2,
                    englishLetters:true
                },
                gender : {
                    required:true,
                },
                country_id : {
                    required:true,
                },
                // license_no  : {
                //     digits:true,
                // },
                // license_org : {
                //     letters:true,
                // },
                birth : {
                    required:true,
                },
                price30 : {
                    required:true,
                    digits:true,
                },
                price60 : {
                    required:true,
                    digits:true,
                },
                years : {
                    required:true,
                    digits:true,
                },
                language_id : {
                    required:true,
                },
                "speciality_id[]" : {
                    required:true,
                    //maxlength:2
                    speciality_id:true,
                },
                picture : {
                    //required:true,
                },
                resume : {
                    //required:true,
                },
              /*  licence : {
                    //required:true,
                },*/
                zip_certificates : {
                    //required:true,
                },
            },
            messages: {
                name_a : {
                    required:"@lang('home.required_field')",
                    minlength : "@lang('home.minlength_2_field')",
                    arabicLetters:"@lang('home.arabic_only')",
                },
                name_e : {
                    required:"@lang('home.required_field')",
                    minlength : "@lang('home.minlength_2_field')",
                    englishLetters:"@lang('home.english_only')",
                },
                gender : {
                    required:"@lang('home.required_field')",
                },
                country_id : {
                    required:"@lang('home.required_field')",
                },
                license_no : {
                    digits:"@lang('home.required_digits')",
                },
                license_org : {
                    letters:"@lang('home.required_letters')",
                },
                birth : {
                    required:"@lang('home.required_field')",
                },
                price30 : {
                    required:"@lang('home.required_field')",
                    digits:"@lang('home.required_digits')",
                    min:"@lang('home.required_digits')",
                },
                price60 : {
                    required:"@lang('home.required_field')",
                    digits:"@lang('home.required_digits')",
                    min:"@lang('home.required_digits')",
                },
                years : {
                    required:"@lang('home.required_field')",
                    digits:"@lang('home.required_digits')",
                    min:"@lang('home.required_digits')",
                },
                language_id : {
                    required:"@lang('home.required_field')",
                },
                "speciality_id[]" : {
                    required:"@lang('home.required_field')",
                    maxlength:"@lang('home.please_enter_2_select')",
                },
                picture : {
                    required:"@lang('home.required_field')",
                },
                resume : {
                    required:"@lang('home.required_field')",
                },
              /*  licence : {
                    required:"@lang('home.required_field')",
                },*/
                zip_certificates : {
                    required:"@lang('home.required_field')",
                },
            },
        });
        $(document).ready(function() {
            $('.select2').select2();
        });
        $(document).on('keyup','.not-under-one',function(){
            if($(this).val()<=0){
                $(this).val(1)
            }
        })
        $('.datepickerymd').datetimepicker({
            //debug:true,
        });
        //author@mohammed.khalf@almoasherbiz.com
        filesLabel={
            "picture":"@lang('home.Attach a personal photo')",
            "resume":"@lang('home.Attach the CV')",
           // "licence":"@lang('home.Attach the license')",
            "zip_certificates":"@lang('home.Attach certificates')",
        };
        $('.custom-file input').change(function (e) {
            var files = [];
            for (var i = 0; i < $(this)[0].files.length; i++) {
                files.push($(this)[0].files[i].name);
            }
            console.log('files');
            console.log(files);
            console.log(filesLabel[$(this).attr('name')]);
            $(this).parent().find('.custom-file-label').html(((files.length)?files.join(' , '):filesLabel[$(this).attr('name')]));
        });
        $( function() {
            $( ".datepicker" ).datepicker({
                dateFormat: "yy-mm-dd"
            });
        });
    </script>
@endsection
