@extends('layouts.site')
@section('headScript')
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/css/bootstrap-datetimepicker.min.css">
    <style>
        .timepicker .timepicker-picker table.table-condensed{
            direction: ltr;
            position: relative;
            left: 35px;
        }
        .select2.select2-container{
            padding-top: 5px;
        }
    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-4">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('auth.signup')}}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header text-center">
                    <h5 class="modal-title w-100" id="exampleModalLabel"> {{trans('home.image-rule')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <ol style="list-style: none" class="mx-3">
                            <li>
                                <h6>
                                    <strong>  {{trans('home.for-women')}} </strong>
                                    {{trans('home.women-desc')}}
                                </h6>
                            </li>
                            <li>
                                <h6>
                                    <strong> {{trans('home.for-mens')}}</strong>

                                    {{trans('home.mens-desc')}}
                                </h6>
                            </li>
                            <li></li>
                        </ol>
                    </div> <!-- form-row -->
                </div> <!-- modal-body -->
            </div>
        </div>
    </div>
    <div>
        <div class="container-fluid">
            <div class="row justify-content-center lgx-inner">
                <div class="col-md-8">
                    <div class="lgx-tab">
                        <div class="align-items-center pt-3 boxing">
                            @if(isset($therapistQuestion)&&$therapistQuestion)
                                <div class="alert alert-info">
                                    @lang('home.The data has already been added')
                                </div>
                            @else
                                <form method="POST" id="therapistQuestionsForm" action="{{ route('therapistQuestionsAnswers',['email'=>$user->email,'verifyToken'=>$user->verifyToken]) }}" data-parsley-validate="" class="col align-self-center dir-rtl" enctype='multipart/form-data' style="margin-bottom: 24px;">
                                    @csrf
                                    <input type="hidden" name="user_id" value="{{$user->id}}">
                                    <div class="form-row">
                                        <div class="col-md-6 mb-3">
                                            <label for="validationDefault01"><strong>  @lang('home.How many hours of work on the site are you available per week?') <span style="color:red;">*</span></strong></label>
                                            <input id="works_hours" min="1" type="number" class="forminput form-control @error('works_hours') is-invalid @enderror" name="works_hours" value="{{ old('works_hours') }}" autofocus autocomplete="works_hours"
                                                   tabindex=1>
                                            <label for="error-works_hours"></label>
                                            @error('works_hours')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <label for="validationDefault01"><strong> @lang('home.Have you ever offered electronic psychological counseling via the Internet?') <span style="color:red;">*</span></strong></label>
                                            <select name="offered_psychological_internet" class="forminput form-control select2" id="offered_psychological_internet">
                                                <option value="">@lang('home.select')</option>
                                                <option @if(old('offered_psychological_internet')==1) selected="selected" @endif value="1">@lang('home.yes')</option>
                                                <option @if(old('offered_psychological_internet')==0) selected="selected" @endif value="0">@lang('home.no')</option>

                                            </select>
                                            <label for="error-offered_psychological_internet"></label>
                                            @error('offered_psychological_internet')
                                            <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </p>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3 d-none" id="offered_psychological_internet_yes">
                                        <label for="validationDefault01"><strong> @lang('home.How long is this experience?') <span style="color:red;">*</span></strong></label>
                                        <input id="experience" min="1" type="number" class="forminput form-control @error('experience') is-invalid @enderror" name="experience" value="{{ old('experience') }}"/>
                                        <label for="error-experience"></label>
                                        @error('experience')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror
                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <label for="validationDefault04"><strong> @lang('home.Specialization')  <span style="color:red;">*</span>  </strong></label>
                                        <select class="forminput form-control select2  @error('speciality_id') is-invalid @enderror" multiple name="speciality_id[]" style="width:100%"
                                                tabindex=12
                                        >
                                            <option value="">@lang('home.Select Specialization')</option>
                                            @foreach($prfixs as $prfix)
                                                <option value="{{$prfix->id}}"  @if(old('speciality_id')&&in_array($prfix->id,old('speciality_id'))) selected  @endif > {{$prfix->title}}</option>
                                            @endforeach
                                        </select>
                                        <label for="error-speciality_id"></label>

                                        @error('speciality_id')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror

                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <label for="validationDefault04"><strong> @lang('home.What are the defects that you encountered in the previous treatment sites and would like the NEW HAYAH website to solve them?')   </strong></label>
                                        <textarea name="defects" id="defects" class="form-control" cols="30" rows="10">{{ old('defects') }}</textarea>
                                        <label for="error-defects"></label>

                                        @error('defects')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror

                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <label for="validationDefault04"><strong> @lang('home.What can you contribute to the success of our website?') </strong></label>
                                        <textarea name="contribute" id="contribute" class="form-control" cols="30" rows="10">{{ old('contribute') }}</textarea>
                                        <label for="error-contribute"></label>

                                        @error('contribute')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror

                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <label for="validationDefault04"><strong> @lang('home.What are the most effective counseling and therapy techniques for family counseling and remote family therapy from your perspective?') </strong></label>
                                        <textarea name="most_effective" id="most_effective" class="form-control" cols="30" rows="10">{{ old('most_effective') }}</textarea>
                                        <label for="error-most_effective"></label>

                                        @error('most_effective')
                                        <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </p>
                                        @enderror

                                    </div>
                                    <div class="text-center">
                                        <button type="submit" class="lgx-btn my-4" style="width: -1%;">
                                            {{ trans('home.End') }}
                                        </button>
                                    </div>

                                </form>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scriptSection')

    <script>
        $(document).ready(function(){
            $(".select2").select2();
            $(document).on('change','#offered_psychological_internet',function(){
                if($(this).val()==1){
                    $("#offered_psychological_internet_yes").removeClass('d-none');
                }else{
                    $("#offered_psychological_internet_yes").addClass('d-none');
                }
            })
            $("#therapistQuestionsForm").validate({
                errorPlacement: function(error, element) {
                    // Append error within linked label
                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                rules : {
                    works_hours : {
                        required:true,
                    },
                    offered_psychological_internet : {
                        required:true,
                    },
                    speciality_id : {
                        required:true,
                    },
                    experience : {
                        required:true,
                    },
                },
                messages: {
                    works_hours : {
                        required:"@lang('home.required_field')",
                    },
                    offered_psychological_internet : {
                        required:"@lang('home.required_field')",
                    },
                    speciality_id : {
                        required:"@lang('home.required_field')",
                    },
                    experience : {
                        required:"@lang('home.required_field')",
                    },
                },
            });
        });
    </script>
@endsection
