@extends('layouts.site')
<style>
    .btn-accord{
        padding-left: 50px !important;
        padding-right: 50px !important;
        padding-bottom: 5px;
        padding-top: 5px;
        border-radius: 18px;
        background: #ccc;
        margin-left: 25px;
    }
    .btnactive{
        background: #3da8c0;
    }
    .formlabel{
        color: #4d4d4f;
        font-size: 14px;
        font-weight: bolder;
    }
    .forminputdiv{
        padding-right: 5px;
        font-size: 14px;
        color: #666669;;
    }
    .formelement{
        min-height: 110px;
    }
    .btnReset{
        font-size: 16px!important;
        border: 1px solid #f4794c !important;
        color: #f4794c !important;
        background: #fff !important;
        padding-right: 30px!important;
        padding-left: 30px!important;
        padding-top: 8px;
        padding-bottom: 8px;
        border-radius: 23px !important;
        display: none;
    }
    .btnSubmit{
        font-size: 16px!important;
        background: #3da8c0 !important;
        color: #fff !important;
        padding-right: 30px!important;
        padding-left: 30px!important;
        padding-top: 8px;
        padding-bottom: 8px;
        border-radius: 23px !important;
        display: none;
    }
    .formelement .forminput{
        display: none;
    }

    @media only screen and(max-width: 768px){

    }
    .ck-editor__editable {
        height: 200px;
        min-height: 200px;
        max-height: 200px;
    }
</style>
@section('content')
<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-4">
                                    <ul class="breadcrumb">
                                        @if(config('app.locale') == "ar")
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active"> {{ config('app.locale') == "ar" ?  $data->name_a : $data->name_e }} </li>
                                        @else
                                            <li class="active"> {{ config('app.locale') == "ar" ?  $data->name_a : $data->name_e }} </li>
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @endif
                                    </ul>

                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>




  <div class="mt-12 mb-12">
    <div class="container">
        <div class="row">

            <div class="col-md-12 boxing bg-white">
                <div class="mr1">
                </div>

                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
                <div class="row d-flex justify-content-around p-5 ">

                        <a class="col-md-3 text-center bg-off-white text-dark3 no-hover-underline bg-blue text-white btn-accord btnactive my-1"  >
                           {{trans('home.therapistsrequests')}}
                        </a>



                    @if(count($therapistsrequests) >0)

                    <div class="container" style="margin-bottom: 50px; margin-top: 18px;">


                <table class="table table-bordered">
                    <thead>

                      <tr>
                        <th scope="col">#</th>
                        <th scope="col"> {{trans('home.column-name')}}</th>
                        <th scope="col"> {{trans('home.from')}}</th>
                        <th scope="col"> {{trans('home.to')}}</th>
                        <th scope="col"> {{trans('home.current-status')}}</th>
                        <th scope="col"> {{trans('home.action')}}</th>
                      </tr>

                    </thead>
                    <tbody>
                    @php
                    $titleCol='title_'.app()->getLocale();
                    @endphp
                        @foreach($therapistsrequests as $key=>$row)
                      <tr>
                        <th scope="row">{{$key+1}}</th>
                        <td>
                            @if($row->column_name == "speciality_id")
                                {{ Lang::get('home.specialties') }}
                            @else
                                {{ Lang::get('home.'.$row->column_name) }}
                            @endif
                        </td>
                        <td>
                            @if($row->column_name == "speciality_id")
                            {{ implode(',',$row->therapist->specialties()->pluck($titleCol)->toArray()) }}
                            @elseif($row->column_name == "language_id")
                                     @if($row->languagefrom !=null)
                                     {{ $row->languagefrom->$titleCol }}
                                     @endif
                            @elseif($row->column_name == "country_id")
                                     @if($row->countaryfrom !=null)
                                     {{ $row->countaryfrom->$titleCol }}
                                     @endif
                            @else
                            {!! $row->from !!}
                            @endif
                        </td>
                        <td>
                            @if($row->column_name == "speciality_id")
                            {{ implode(',',\App\Specialties::whereIn('id',(is_array($toIds=json_decode($row->to))?$toIds:[$toIds]))->pluck('title_'.app()->getLocale())->toArray()) }}
                            @elseif($row->column_name == "language_id")
                            @if($row->languageto !=null)
                            {{ $row->languageto->$titleCol }}
                            @endif
                         @elseif($row->column_name == "country_id")
                            @if($row->countaryto !=null)
                            {{ $row->countaryto->$titleCol }}
                            @endif

                            @else
                            {!! $row->to !!}
                            @endif
                        </td>
                        <td>{{ Lang::get('main.'.$row->status) }}</td>

                        <td>
                            @if($row->status =='pending')
                            <a href="{{route('canceltherapists',$row->id)}}" class="btn btn-danger btn-lg"> {{trans('home.cancel')}}</a>
                            @else
                            <button disabled>{{ Lang::get('main.'.$row->status) }}</button>
                            @endif

                        </td>
                      </tr>
                      @endforeach

                    </tbody>
                  </table>
                </div>
                  @else
                  <div class="container" style="text-align: center;
                  margin-bottom: 100px;
                  margin-top: 100px;
                  font-size: 33px;">
                    <h1> {{trans('home.no-changes')}} </h1>
                </div>
                  @endif



                </div>
            </div>
        </div>
    </div>
</div>


@endsection
