@extends('layouts.site')

@section('content')
<style type="text/css">
    .fa-star
    {
        color: #ffca08;
    }
    .fa-star-half
    {
        transform: rotate(180deg);
        color: #ffca08;
    }

</style>
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active"> {{trans('home.update-medical-plan')}} </li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    @if(Session::has('status'))
        <p class="alert alert-success alert-dismissible fade show mt-2 text-center" role="alert">{{ Session::get('status') }}
            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </p>
    @endif
    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">

                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2 mx-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            <img src="{{asset('avatars/therapists/'.$data->picture)}}" class="rounded-circle card-img-top shadow" style="width: 125px; height: 125px;" />
                            <h4 class="mt-5 colorsite">{{$data->user->name}}</h4>
                            <p class="text-sm-center my-4">
                                {{ $data->main_specialty }}
                            </p>
                            <div>
                                  <?php

                            $reviews = [
                                (object)['rate' => round($avg_rating,1)],
                            ];
                            foreach ($reviews as $review) {
                                for ($i = 0; $i <= 5; ++$i) {
                                    echo '<i class="fa fa-star' ,
                                        ($review->rate == $i + .1 ? '-half' : '') ,
                                        ($review->rate == $i + .2 ? '-half' : '') ,
                                        ($review->rate == $i + .3 ? '-half' : '') ,
                                        ($review->rate == $i + .4 ? '-half' : '') ,
                                        ($review->rate == $i + .5 ? '-half' : '') ,
                                        ($review->rate == $i + .6 ? '-half' : '') ,
                                        ($review->rate == $i + .7 ? '-half' : '') ,
                                        ($review->rate == $i + .8 ? '-half' : '') ,
                                        ($review->rate == $i + .9 ? '-half' : '') ,
                                        ($review->rate <= $i ? '-o' : '') ,
                                        '" aria-hidden="true"></i>';
                                    echo "\n";
                                }
                                echo "\n";
                            }

                        ?>
                        <br>
                        <label>({{ round($avg_rating,1) }} @lang('home.Evaluation'))</label>
                            </div>
                            <div class="mb-4">
                                <label>@lang('home.sessions-count'): {{$data->sessions->whereIn('session_status',['reserved','closed'])->count() + 25 }}</label>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_sessions')}}">
                                <i class="fas fa-play"></i><br />
                                {{trans('auth.therapists.sessions')}}
                            </a>
                        </div>
                        <div class="col-6 mb-4">
                            <a href="{{route('clients-files')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients_files')}}
                            </a>
                        </div>

                        <div class="col-6 mb-4">
                            <a href="{{route('therapists_clients')}}">
                                <i class="fas fa-users"></i><br />
                                {{trans('auth.therapists.clients')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_invoice')}}">
                                <i class="fas fa-file-invoice"></i><br />
                                {{trans('auth.therapists.invoices')}}
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{route('therapists_profile_basic')}}">
                                <i class="fas fa-user-md"></i><br />
                                {{trans('auth.therapists.profile')}}
                            </a>
                        </div>
                        @if (auth()->check()&&auth()->user()->type != 'visitors')
                           <div class="col-6">
                                <a href="{{route('page_view',getStaticPageValue(10,'url')) }}"><i class="fas fa-archive"></i> <br>{{ getStaticPageValue(10) }}</a>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white">

                    <div class="lgx-tab p-3">
                        <div class="align-items-center">
                            <form method="POST" action="{{route('update-plan',$editTreatmentPlan)}}" id="updatePlanForm" class="col align-self-center">
                                @csrf
                                <input type="hidden" name="session_id" value="{{$editTreatmentPlan->session_id}}">

                                <div class="row col-md-12">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h4 for="validationDefault01"><strong>  {{trans('home.serial-number')}} </strong></h4>
                                            <input id="serial_number" disabled type="text" class="forminput form-control @error('serial_number') is-invalid @enderror" name="serial_number" value="{{ $editTreatmentPlan->id }}" autocomplete="serial_number" autofocus
                                                   tabindex="1"
                                            >
                                            <label for="error-serial_number"></label>
                                            @error('serial_number')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01"><strong>{{ trans('home.client-name') }} </strong></h4>
                                            <input id="client_name" type="text" class="forminput form-control @error('client_name') is-invalid @enderror" name="client_name" value="{{\App\User::findOrFail(\App\Visitor::findOrFail($therapist_session->visitor_id)->user_id)->name }}" autocomplete="client_name" autofocus
                                                   tabindex="2"
                                                   readonly>
                                            <label for="error-client_name"></label>
                                            @error('client_name')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="client_name_pdf" @if($editTreatmentPlan->client_name_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                </div>

                                <div class="row col-md-12">
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{ trans('home.age') }}  </strong></h4>
                                            <input id="age" type="text" class="forminput form-control @error('age') is-invalid @enderror" name="age" value="{{$editTreatmentPlan->age }}" autocomplete="age" autofocus
                                                   tabindex="3"
                                                   
                                            >
                                            <label for="error-age"></label>
                                            @error('age')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="age_pdf" @if($editTreatmentPlan->age_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{ trans('home.gender') }}  </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <!-- <input type="text" class="forminput form-control " readonly  value="{{$last_Session->visitor->gender == 'male' ? 'ذكر' : 'أنثي'}}">

                                                    <input type="hidden" name="gender" value="{{$last_Session->visitor->gender == 'male' ? '1' : '0'}}"> -->

                                                    <select class="form-control newStyle text-right" name="gender">
                                                        <option {{  $editTreatmentPlan->gender == 1 ? 'selected' : ''   }} value="1">@lang('home.male')</option>
                                                        <option {{  $editTreatmentPlan->gender == 0 ? 'selected' : ''   }} value="0">@lang('home.female')</option>
                                                    </select>

                                                </div>
                                            </div>
                                            <label for="error-gender"></label>
                                            @error('gender')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>

                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="gender_pdf" @if($editTreatmentPlan->gender_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                </div>


                                <div class="row col-md-12">
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong>   {{ trans('home.problem-detail') }}  </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <select id="problem"  type="text" class="form-control newStyle" rows="5" name="problem"  tabindex="5"  data-parsley-required-message="{{trans('home.field-required')}}">
                                                        <option value="0">  {{trans('home.choose-problem')}}</option>
                                                        <option  value="1" {{  $editTreatmentPlan->problem == 1 ? 'selected' : ''   }}> {{trans('home.Marital-and-Family-Problems')}} </option>
                                                        <option  value="2" {{  $editTreatmentPlan->problem == 2 ? 'selected' : ''   }}> {{trans('home.Marital-Rehabilitation')}} </option>
                                                        <option  value="3" {{  $editTreatmentPlan->problem == 3 ? 'selected' : ''   }}>{{trans('home.Sexual-Therapy')}} </option>
                                                        <option  value="4" {{  $editTreatmentPlan->problem == 4 ? 'selected' : ''   }}> {{trans('home.Post-Divorce-Rehabilitation')}} </option>
                                                        <option  value="5" {{  $editTreatmentPlan->problem == 5 ? 'selected' : ''   }}> {{trans('home.Recovery-from-Divorce')}} </option>
                                                        <option  value="6" {{  $editTreatmentPlan->problem == 6 ? 'selected' : ''   }}>  {{trans('home.Children-Mental-Disorders')}} </option>
                                                        <option  value="7" {{  $editTreatmentPlan->problem == 7 ? 'selected' : ''   }}> {{trans('home.Children-Problems')}} </option>
                                                        <option  value="8" {{  $editTreatmentPlan->problem == 8 ? 'selected' : ''   }}>{{trans('home.Adolescent-Mental-Disorders')}} </option>
                                                        <option value="9" {{  $editTreatmentPlan->problem == 9 ? 'selected' : ''   }}>{{trans('home.Adolescent-Problems')}}</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <label for="error-problem"></label>
                                            @error('problem')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="problem_pdf" @if($editTreatmentPlan->problem_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group ">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{ trans('home.Psychological-evaluation') }}  </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv mb-3">
                                                    <select id="therap_evaluation"  type="text" class="form-control newStyle" name="therap_evaluation"  tabindex="8"  data-parsley-required-message="{{trans('home.field-required')}}">
                                                        <option value="0">  {{trans('home.choose-therap-evaluation')}}</option>
                                                        <option value="1" {{  $editTreatmentPlan->therap_evaluation == 1 ? 'selected' : ''   }}> {{trans('home.BASIC-ID')}} </option>
                                                        <option value="2" {{  $editTreatmentPlan->therap_evaluation == 2 ? 'selected' : ''   }}> {{trans('home.Holland-Test-for-Career-Tendencies')}} </option>
                                                        <option value="3" {{  $editTreatmentPlan->therap_evaluation == 3 ? 'selected' : ''   }}> {{trans('home.Beck-Depression-Inventory')}} </option>
                                                        <option value="4" {{  $editTreatmentPlan->therap_evaluation == 4 ? 'selected' : ''   }}> {{trans('home.EPQ')}} </option>
                                                        <option value="5" {{  $editTreatmentPlan->therap_evaluation == 5 ? 'selected' : ''   }}> {{trans('home.Yale–Brown-Y-BOCS')}} </option>
                                                        <option value="6" {{  $editTreatmentPlan->therap_evaluation == 6 ? 'selected' : ''   }}> {{trans('home.Family-Readiness-Scale')}} </option>
                                                        <option value="7" {{  $editTreatmentPlan->therap_evaluation == 7 ? 'selected' : ''   }}> {{trans('home.Taylor-manifest-anxiety-scale')}} </option>
                                                        <option value="8" {{  $editTreatmentPlan->therap_evaluation == 8 ? 'selected' : ''   }}> {{trans('home.Adolescent-Identity-Crisis-Scale')}} </option>
                                                        <option value="9" {{  $editTreatmentPlan->therap_evaluation == 9 ? 'selected' : ''   }}> {{trans('home.Domestic-Violence-Scale')}} </option>
                                                        <option value="10" {{  $editTreatmentPlan->therap_evaluation == 10 ? 'selected' : ''   }}> {{trans('home.Parenting-Style-Scale')}} </option>
                                                        <option value="11" {{  $editTreatmentPlan->therap_evaluation == 11 ? 'selected' : ''   }}> {{trans('home.Sexual-Orientation-Scale')}} </option>
                                                        <option value="12" {{  $editTreatmentPlan->therap_evaluation == 12 ? 'selected' : ''   }}> {{trans('home.Other')}} </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <label for="error-therap_evaluation"></label>
                                            @error('therap_evaluation')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="therap_evaluation_pdf" @if($editTreatmentPlan->therap_evaluation_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                </div>



                                <div class="row col-md-12">
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{ trans('home.diagnose') }} </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <select id="diagnostic" multiple data-placeholder="{{ trans('home.choose-diagnostic') }}" type="text" class="form-control select2 newStyle" rows="5" name="diagnostic[]" tabindex="7"  data-parsley-required="true"  data-parsley-required-message="{{trans('home.field-required')}}"
                                                            tabindex="7">
                                                        @php $diagnosisIds=\App\TreatmentPlansDiagnosis::where('treatment_plan_id',$editTreatmentPlan->id)->pluck('diagnosis_id')->toArray()@endphp
                                                        @foreach(\App\Diagnosis::where('active',1)->pluck('title_'.config('app.locale'),'id')->toArray() as $id=>$name)
                                                        <option value="{{ $id }}" {{  in_array($id,$diagnosisIds) ? 'selected' : ''   }}> {{ $name }} </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <label for="error-diagnostic"></label>
                                            @error('diagnostic')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="diagnostic_pdf" @if($editTreatmentPlan->diagnostic_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{trans('home.Therapeutic-intervention')}}  </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    @php $treatmentsIds=\App\TreatmentPlansTreatments::where('treatment_plan_id',$editTreatmentPlan->id)->pluck('treatments_id')->toArray()@endphp
                                                    <select id="therapeutic_intervention" multiple data-placeholder="{{ trans('home.choose-therapeutic-intervention') }}"  type="text" class="form-control select2 newStyle" name="therapeutic_intervention[]"  tabindex="12"  data-parsley-required-message="{{trans('home.field-required')}}">
                                                        @foreach(\App\Treatments::where('active',1)->pluck('title_'.config('app.locale'),'id')->toArray() as $id=>$name)
                                                            <option value="{{ $id }}" {{  in_array($id,$treatmentsIds) ? 'selected' : ''   }}> {{ $name }} </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <label for="error-therapeutic_intervention"></label>
                                            @error('therapeutic_intervention')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="therapeutic_intervention_pdf" @if($editTreatmentPlan->therapeutic_intervention_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                </div>


                                <div class="row col-md-12">
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-4 mx-2"><strong>   {{ trans('home.problem-short-desc') }}   </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <div class="form-group">
                                                        {{ Form::textarea('problem_description', $editTreatmentPlan->problem_description , ['placeholder' => '','id'=>'problem_description','class' => 'form-control forminput' , 'cols' => 20, 'rows' =>5]) }}
                                                    </div>

                                                </div>
                                            </div>
                                            <label for="error-problem_description"></label>
                                            @if ($errors->has('problem_description'))
                                                <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $errors->first('problem_description') }}</strong>
                                                    </span>
                                            @endif
                                        </div>

                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="problem_description_pdf" @if($editTreatmentPlan->problem_description_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                    <div class="col-md-5">

                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-4 mx-2"><strong> {{ trans('home.assign-Work') }} </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <div class="form-group">
                                                        {{ Form::textarea('homework',$editTreatmentPlan->homework, ['placeholder' => '', 'id'=>'homework','class' => 'form-control forminput' , 'cols' => 20, 'rows' =>5]) }}
                                                    </div>

                                                </div>
                                            </div>
                                            <label for="error-homework"></label>
                                            @if ($errors->has('homework'))
                                                <span class="alert alert-danger" role="alert">
                                                    <strong>{{ $errors->first('homework') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="homework_pdf" @if($editTreatmentPlan->homework_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                </div>

                                <!-- full width row -->
                                <div class="form-group">
                                        <h4 for="validationDefault01" class="mt-4 mx-4"><strong>  {{trans('home.sessions')}} </strong></h4>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="table_pdf" @if($editTreatmentPlan->table_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                        <div class="formelement">
                                            <div class="forminputdiv">
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="sample_1">
                                                        <thead>
                                                        <tr class="text-center">
                                                            <th>#</th>
                                                            <th>{{trans('home.date-time')}}</th>
                                                            <th>{{trans('home.period')}}</th>
                                                            <th>{{trans('home.attend')}}</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $x=1;?>
                                                        @foreach($clientSessions as $clientSession)
                                                            <tr id="sessions-{{ $clientSession->id }}" class="text-center" tabindex="9">
                                                                <td>{{ $clientSession->id }}</td>
                                                                <td>{{ $clientSession->start_time }}</td>
                                                                <td>{{ $clientSession->type }}</td>
                                                                <td>
                                                                    <input data-id="{{ $clientSession->id }}"  type="checkbox"  name="change_status"  @if($clientSession->attend==1) checked="checked" @endif    class="change_status"  id="checkbox-{{ $clientSession->id }}">
                                                                </td>
                                                            </tr>
                                                            <?php $x++;?>
                                                        @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    <label for="error-change_status"></label>
                                        @error('change_status')
                                        <span class="invalid-feedback alert alert-danger" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>


                                <div class="row col-md-12">
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong>{{trans('home.Long-term-goals')}} </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <div class="form-group">
                                                        {{ Form::textarea('long_term', $editTreatmentPlan->long_term, ['placeholder' => 'Your Comment','id'=>'long_term','class' => 'form-control forminput' , 'cols' => 20, 'rows' =>5]) }}
                                                    </div>
                                                </div>
                                            </div>
                                            <label for="error-long_term"></label>
                                            @error('long_term')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="long_term_pdf" @if($editTreatmentPlan->long_term_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{trans('home.short-term-goals')}} </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <div class="form-group">
                                                        {{ Form::textarea('short_term', $editTreatmentPlan->short_term, ['placeholder' => 'Your Comment', 'id'=>'short_term'  ,'class' => 'form-control forminput' , 'cols' => 20, 'rows' =>5]) }}
                                                    </div>
                                                </div>
                                            </div>
                                            <label for="error-short_term"></label>
                                            @error('short_term')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="short_term_pdf" @if($editTreatmentPlan->short_term_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>

                                </div>


                                <div class="row col-md-12">
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong>  {{trans('home.Conversion')}}   </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <select id="transfer"  type="text" class="form-control newStyle" name="transfer"  tabindex="13"  data-parsley-required-message=" التحويل مطلوب">
                                                        <option value="0">  {{trans('home.choose-transfer')}}</option>
                                                        <option value="1" {{  $editTreatmentPlan->transfer == 1 ? 'selected' : ''  }}> {{trans('home.no-transfer')}} </option>
                                                        <option value="2" {{  $editTreatmentPlan->transfer == 2 ? 'selected' : ''  }}> {{trans('home.clinical-psychologist')}} </option>
                                                        <option value="3" {{  $editTreatmentPlan->transfer == 3 ? 'selected' : ''  }}> {{trans('home.psychiatrist')}} </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <label for="error-transfer"></label>
                                            @error('transfer')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>

                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="transfer_pdf" @if($editTreatmentPlan->transfer_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{ trans('home.current-status') }}  </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <select id="current_status"  type="text" class="form-control newStyle" name="current_status"  tabindex="14"  data-parsley-required-message=" الوضع الحالي مطلوب">
                                                        <option value="0">  {{trans('home.choose-current-status')}}</option>
                                                        <option value="1" {{  $editTreatmentPlan->current_status == 1 ? 'selected' : ''  }}> {{trans('home.in-progress')}} </option>
                                                        <option value="2" {{  $editTreatmentPlan->current_status == 2 ? 'selected' : ''  }}> {{trans('home.closed')}} </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <label for="error-current_status"></label>
                                            @error('current_status')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="current_status_pdf" @if($editTreatmentPlan->current_status_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                </div>



                                <div class="row col-md-12">

                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong>  {{trans('home.last-visit')}}  </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <input id="last_visit"  type="datetime-local" class="form-control newStyle" name="last_visit" value="{{ !empty($last_Session->start_time) ? date('Y-m-d\TH:i', strtotime($last_Session->start_time)) : ''  }}" tabindex="15"/>
                                                </div>
                                            </div>
                                            <label for="error-last_visit"></label>
                                            @error('last_visit')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="last_visit_pdf" @if($editTreatmentPlan->last_visit_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                    <div class="col-md-5">

                                        <div class="form-group">
                                            <h4 for="validationDefault01" class="mt-3"><strong> {{ trans('home.therapist-name')  }}  </strong></h4>
                                            <div class="formelement">
                                                <div class="forminputdiv">
                                                    <input id="therapist_name" type="text" class="form-control newStyle" rows="5" value="{{ config('app.locale') == "en" ? $data->name_e :  $data->name_a }}"  name="therapist_name" tabindex="16" readonly>
                                                </div>
                                            </div>
                                            <label for="error-therapist_name"></label>
                                            @error('therapist_name')
                                            <span class="invalid-feedback alert alert-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>

                                    </div>
                                    <div class="col-md-1 mt-4">
                                        <h4><strong> PDF </strong></h4>
                                        <input type="checkbox" name="therapist_name_pdf" @if($editTreatmentPlan->therapist_name_pdf) checked="checked" @endif class="form-control" value="1">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12 text-center">
                                        <button type="submit" class="lgx-btn mt-5" style="width:30%">
                                            {{ trans('auth.save-plan') }}
                                        </button>
                                    </div>
                                </div>


                            </form>
                        </div> <!-- row -->
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scriptSection')
    <script src="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/js/bootstrap-datetimepicker.min.js"></script>
    <script>
         $('.select2').select2();
        $('.datepickerymd').datetimepicker({
            //debug:true,

        });
         $("#updatePlanForm").validate({
             errorPlacement: function(error, element) {
                 // Append error within linked label
                 console.log('error')
                 console.log(error)
                 console.log(element)
                 console.log(element.attr( "id" ))
                 $( element )
                     .closest( "form" )
                     .find( "label[for='error-" + element.attr( "id" ) + "']" )
                     .append( error );
             },
             errorElement: "span",
             rules : {
                 // serial_number : {
                 //     required:true,
                 // },


                 //---
                 /*age:{
                     required:true,
                 },
                 gender:{
                     required:true,
                 },
                 problem:{
                     required:true,
                 },
                 therap_evaluation:{
                     min:1,
                 },
                 "diagnostic[]":{
                     required:true,
                 },
                 "therapeutic_intervention[]":{
                     required:true,
                 },
                 homework:{
                     required:true,
                 },
                 transfer:{
                     min:1,
                 },
                 current_status:{
                     min:1,
                 },*/


                 //--
             },
             messages: {
                 serial_number : {
                     required:"@lang('home.required_field')",
                 },
                 age:{
                     required:"@lang('home.required_field')",
                 },
                 gender:{
                     required:"@lang('home.required_field')",
                 },
                 problem:{
                     required:"@lang('home.required_field')",
                 },
                 therap_evaluation:{
                     min: "@lang('home.required_field')",
                 },
                 "diagnostic[]":{
                     required:"@lang('home.required_field')",
                 },
                 "therapeutic_intervention[]":{
                     required:"@lang('home.required_field')",
                 },
                 homework:{
                     required:"@lang('home.required_field')",
                 },
                 transfer:{
                     min: "@lang('home.required_field')",
                 },
                 current_status:{
                     min: "@lang('home.required_field')",
                 },
             },
         });
    </script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}" type="text/javascript"></script>
<script>

    $(document).on('change', '.change_status', function () {
        token = '{{ csrf_token() }}';
        var id = $(this).attr('data-id');
        var statues=$(this).is(':checked');
        console.log(id);
        if(statues)
        {
            $.ajax({
                type: "POST",
                url: "{{route('update-plan-attend')}}",
                data: {"attend": 1,"id": id,_token:token},
                success: function (msg) {
                    console.log(msg)
                }
            });

        }

    });
</script>
@endsection
