@extends('layouts.site')
@section('meta_tags')
    <title>{{ config('app.name', 'New Life') }} | {{ trans('home.blog') }}</title>
    <style>
        .hidden{
            display:none!important;
        }
    </style>
@endsection
@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-5">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{ trans('home.home') }}</a></li>
                                        <li class="active">{{ trans('home.videos') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <section id="blog-section">
        <div class="lgx-blog lgx-blog-list">
            <div class="lgx-inner">
                <div class="container">
                    <h3>@lang('home.last videos')</h3>
                    <div class="row dir-rtl">
                        @foreach(\App\Videos::where('active',1)->orderBy('sort','ASC')->pluck('iframe')->toArray() as $videoIframe)
                            <div class="col-4">
                                {!! preg_replace('/width="(.*?)"/i', 'width="100%"',preg_replace('/height="(.*?)"/i', 'height="100%"',$videoIframe)) !!}
                            </div>
                        @endforeach
                    </div>
                </div><!-- //.CONTAINER -->

            </div><!-- //.INNER -->

        </div>
    </section>
@endsection
@section('scriptSection')
    <script>
        $(document).ready(function(){
            $(document).on('click','#loadMore',function(e){
                $("#loader").removeClass('hidden');
                $("#loadMore").addClass('hidden')
                e.preventDefault();
                skip=$(".blog-area .lgx-card-single").length;
                $.ajax({
                    type: "GET",
                    url: "{{ route('get_more_blog') }}",
                    data: {"skip": skip},
                    success: function (msg) {
                        if(msg.success){
                            if(msg.html.length){
                                $(".blog-area .row").append(msg.html);
                                $("#loadMore").removeClass('hidden')
                            }else{
                                $("#loadMore").remove();
                            }

                        }
                        $("#loader").addClass('hidden');
                    }
                });
            });
        })
    </script>
@endsection
