<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Stevebauman\Location\Facades\Location;
/*
|--------- -----------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
// Route::get('getSession',function(){
//     $sessions=\App\Sessions::select('start_time')->whereIn('id',[7362,7363])->get();
//     $sessionsData=[];
//     foreach ($sessions as $session){
//         $sessionsData[]=date('Y-m-d h:i:s ',strtotime($session->start_time));
//     }
//    return [$sessions,$sessionsData];
// })->middleware('FrontPagesApi');

//Route::group(['namespace'=>'Api\User'], function () {
//    Route::group(['prefix' => 'v1/therapists'], function () {
//        Route::get('/{id}/sessions', 'AppController@getTherapistSessions');
//    });
//});

Route::get('language', function(){
    if(request()->header('lang') == 'en' )
            {
                return 'en';
            }
            else
            {
                return 'ar';
            }
});

Route::group(['middleware'=>'FrontPagesApi'], function(){

    Route::get('/users',function(){
       return auth('api')->user()->type;
    });
    Route::group(['namespace'=>'Api', 'prefix' => 'v1', 'middleware' =>'api.guest'], function (){
        Route::group(['namespace'=>'User'], function ($request){
            Route::post('/session/{id}/getRedirectPage', 'AppController@getRedirectPage')->name('book_redirect');
            Route::post('/session/{id}/getSecrets', 'AppController@getSecrets');
        });
    });
    Route::group(['namespace'=>'Api', 'prefix' => 'v1'], function () {
        Route::group(['middleware'=>'api','prefix'=>'user', 'namespace'=>'User'], function ($request){
            Route::post('login', 'AuthController@login');
            //Therapist


            Route::post('/sendWebNotification', 'AppController@sendWebNotification');


            Route::post('/getAllNotifications', 'AppController@getAllNotifications');


            Route::post('therapist_login', 'AuthController@therapist_login');
            Route::post('register', 'AuthController@register');
            Route::post('therapist_register', 'AuthController@therapistRegister');
            Route::post('forget_password', 'AuthController@forgetPassword');
            Route::post('reset_password', 'AuthController@resetPassword');
            Route::get('/userID/{id}', 'AuthController@userID');

            Route::post('/insert_rate/{id}', 'AppController@insertRate');

            Route::post('/getAvailableSessionsForScheduling', 'AppController@getAvailableSessionsForScheduling');
            Route::post('scheduling_session', 'AppController@schedulingSession');


            Route::post('auth/{social}/callback','AppController@callback');


            Route::post('/check_deleted', 'AuthController@checkDeleted');
            Route::get('clientViewPlan/{therapist_session}', 'AppController@clientViewPlan');

            Route::group(['middleware'=>['jwt.verify']], function ($router) {


                Route::get('get-medical-plans', 'AppController@getPlans');


                Route::get('client-messages/{id}', 'AppController@clientMessages');
                Route::post('client-messages/{id}', 'AppController@addMessage');


                Route::post('client-messages/{id}/allowChat', 'AppController@allowChat');

                Route::post('client_send_message/{client_session}/{message}', 'AppController@answerMessage');
                Route::get('client_send_message/{client_session}', 'AppController@getClientMessagePage');
                Route::post('client_send_message/{client_session}', 'AppController@sendMessage');


                //set and get lang of user app
                Route::post('setUserLang', 'AppController@setUserLang');
                Route::get('getUserLang', 'AppController@getUserLang');


                Route::post('/sessions/history', 'AppController@getVisitorHistorySessions');
                Route::post('/sessions/today', 'AppController@getTodaySessionsOfVisitor');
                Route::post('/sessions/upcoming', 'AppController@getVisitorSessions');
                //  Route::post('/session/{id}/getRedirectPage', 'AppController@getRedirectPage')->name('book_redirect');
                Route::post('logout', 'AuthController@logout');
                Route::post('refresh', 'AuthController@refresh');
                Route::put('/profile/edit', 'AuthController@updateProfile');
                Route::put('/password/change', 'AuthController@changePassword');
                Route::post('/cancelSessionForVisitor', 'AppController@cancelSessionForVisitor');
            });
            //start_session_video url
            Route::get('/start_session_video/{visitor_id}/{session_id}', 'AppController@start_session_video');
        });
        Route::group(['middleware'=>['api','jwt.verify'], 'namespace'=>'User'], function (){
            //reservation
            Route::post('therapists/{therapist}/sessions/{sessions}/reserve/', 'AppController@reserveSessionWithPayment');
            //cancelSessionsForTherapist
            Route::post('/cancelSessionsForTherapist', 'AppController@cancelSessionsForTherapist');
        });
        Route::group(['namespace'=>'User'], function () {
            Route::get('specialties', 'AppController@Specialties');
            Route::get('languages', 'AppController@languages');
            Route::get('blog', 'AppController@blog');
            Route::get('blog/post/{post}', 'AppController@post');
            Route::post('contact_us', 'AppController@contactUs');


            Route::get('/static-pages', 'AppController@staticPages');


            // therapist data

            Route::get('/timezones/{user_id}', function($user_id){
                $user = \App\User::find($user_id);
                if($user)
                {
                    $timezone = $user->timezone;
                }
                else
                {
                    $timezone = '';
                }
                $array=[];
                foreach(DateTimeZone::listIdentifiers(DateTimeZone::ALL) as $key=>$timeZone)
                {
                    array_push($array, $timeZone);
                }
                return response()->json(['success'=>true, 'data' => $array, 'myTimeZone' => $timezone]);
            });


            Route::get('/location/{ip}','AppController@locationIP');
            Route::get('/countries', 'AppController@countries');

            Route::post('/checkStatusOfSession/{id}', 'AppController@checkStatusOfSession')->name('checkStatusOfSession');


            Route::group(['prefix'=>'therapists'], function () {
                    Route::get('/', 'AppController@therapists'); //
                    Route::get('/{therapist}', 'AppController@therapist'); //
                    Route::get('/{id}/sessions', 'AppController@getTherapistSessions'); //
                    Route::post("changeTimeZone", 'AppController@changeTimeZone');
            });


            Route::group([
              'middleware'=>['jwt.verify'],

                'prefix'=>'therapists'], function () {
                Route::get('/{id}/sessions/history', 'AppController@getTherapistHistorySessions');
                Route::get('/{id}/sessions/today', 'AppController@getTherapistSessionsAvailable');
                //New Upcoming
                Route::get('/{id}/sessions/upcoming', 'AppController@getTherapistSessionsUpcoming');

                Route::post('/getRequestsOfTherapists', 'AppController@getRequestsOfTherapists');
                Route::post('/canceltherapists/{id}', 'AppController@canceltherapists');


                Route::post('/clientFile', 'AppController@client_file');

                Route::get('/reviews/{id}', 'AppController@reviews');
                Route::post('/invoices/{id}', 'AppController@invoices');

                Route::post('/clients', 'AppController@therapistClients');
                Route::post('/client_file', 'AppController@clients_files');

                Route::get('/basic_info/{id}', 'AppController@basic_info')->middleware('FrontPagesApi');
                Route::post('/deleteSessionsForTherapist', 'AppController@deleteSessionsForTherapist');

                Route::post('/save_basic_info/{id}', 'AppController@save_basic_info');
                //add session
                Route::post('/calenderOperations', 'AppController@calenderOperations');
                Route::post('/scheduleCalenderSession', 'AppController@scheduleCalenderSession');
                //Therapist Edit Profile
                Route::post('/update_basic_info', 'AppController@update_basic_info');
                Route::post('/update_basic_info_part_two', 'AppController@update_basic_info_part_two');
                Route::post('/update_basic_info_certificates', 'AppController@update_basic_info_certificates');
                Route::post('/update_basic_info_resume', 'AppController@update_basic_info_resume');
                Route::post('/update_basic_info_licence', 'AppController@update_basic_info_licence');
                Route::post('/update_basic_info_picture', 'AppController@update_basic_info_picture');
               


                Route::post('create_attend', 'AppController@save_attend');

                //TreatementPlan
                Route::post('/client-plan/{therapist_session}/create', 'AppController@create_plan');
                Route::post('/client-plan/{therapist_session}/store', 'AppController@store_plan');
               // Route::post('/client-plan/{therapist_session}/edit', 'AppController@edit_plan');
                 Route::post('/client-plan/{id}/update', 'AppController@update_plan');



            });
        });
    });









});
