<?php

namespace App\Exports;

use App\Models\KPI;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class KPISExport implements WithMapping, WithHeadings,FromQuery
{

    public function query()
    {
        $kpis=KPI::query();
        if(request('IDS')){
            $kpis=$kpis->whereIn('id',explode(',',request('IDS')));
        }
        return $kpis;
    }
    /**
    * @return \Illuminate\Support\Collection
    */

    public function map($kpi) : array {
        return [

            $kpi->title,
            $kpi->status,
            $kpi->created_at?$kpi->created_at->format('d M Y, h:i a'):'',

        ] ;
    }
    public function headings() : array {
        return [
            __('Title'),
            __('Status'),
            __('Created At')
        ] ;
    }
}
