<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UsersKPI extends Model
{
    use HasFactory,SoftDeletes;
    protected $guarded=['id'];
    protected $table='users_kpis';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_changes_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_changes_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_changes_action('delete',$model);
        });
    }
    public function KPI(){
        return $this->belongsTo(KPI::class,'kpi_id');
    }
    public function User(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function Questions(){
        return $this->hasMany(UsersKPISQuestion::class,'users_kpi_id');
    }
}
