<?php

namespace Database\Factories;

use App\Models\Department;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Department>
 */
class DepartmentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $department=Department::inRandomOrder()->first();
        return [
            //
            'title'=>fake()->jobTitle,
            'status'=>fake()->randomElement(config('app.statusArray')),
        ];
    }
}
