@extends('dashboard.layouts.app')
@push('headScripts')
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" type="text/css">@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('Job Titles & Job Titles') }} /</span> {{ __('Job Titles') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('Job Titles') }}</h5>
                        <div class="m-4 mb-0 mt-0">
                            @if(PerUser('job_titles.export'))
                                <div class="btn-group float-end ms-1 me-1" role="group">
                                    <button id="exportSelectedJob Titles" type="button" class="btn btn-primary dropdown-toggle export-selected" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fadeIn animated bx bx-export"></i>
                                        {!! __('Export Selected :type',['type'=>__('Job Title')]) !!}
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="exportSelectedJob Titles">
                                        <a class="dropdown-item export-type" data-type="csv">{{ __('CSV') }}</a>
                                        <a class="dropdown-item export-type" data-type="excel">{{ __('Excel') }}</a>
                                        <a class="dropdown-item export-type" data-type="pdf">{{ __('PDF') }}</a>
                                    </div>
                                    <form action="{{ route('job_titles.export') }}" method="POST" id="exportData" class="d-inline-block">
                                        <input type="hidden" id="exportIDS" name="IDS">
                                        <input type="hidden" name="export_type" value="excel">
                                        @csrf
                                        {{--                            <button class="btn btn-info export-selected"><i class="fadeIn animated bx bx-export"></i> {!! __('Export Selected :type',['type'=>__('Job Title')]) !!}</button>--}}
                                    </form>
                                </div>
                                <div class="btn-group float-end ms-1 me-1" role="group">
                                    <button id="exportJob Titles" type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fadeIn animated bx bx-export"></i>
                                        {{ __('Export') }}
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-left" aria-labelledby="exportJob Titles">
                                        <a class="dropdown-item export-type" data-type="csv">{{ __('CSV') }}</a>
                                        <a class="dropdown-item export-type" data-type="excel">{{ __('Excel') }}</a>
                                        <a class="dropdown-item export-type" data-type="pdf">{{ __('PDF') }}</a>
                                    </div>
                                    <form action="{{ route('job_titles.export') }}" method="POST" class="d-inline-block">
                                        <input type="hidden" name="export_type" value="excel">
                                        @csrf
                                        {{--                            <button class="btn btn-info "><i class="fadeIn animated bx bx-export"></i> {{ __('Export') }}</button>--}}
                                    </form>
                                </div>


                            @endif
                            @if(PerUser('job_titles.destroy'))
                                <a href="#" class="btn btn-danger delete-selected float-end ms-1 me-1"><i class="fadeIn animated bx bx-trash-alt"></i> {!! __('Delete Selected :type',['type'=>__('Job Title')]) !!}</a>
                            @endif
                            @if(PerUser('job_titles.create'))
                                <a href="{{ route('job_titles.create') }}" class="btn btn-primary float-end ms-1 me-1"><i class="fadeIn animated bx bx-message-square-add"></i> {{ __('Create :type',['type'=>__('Job Title')]) }}</a>
                            @endif
                        </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            {{ $dataTable->table(['class' => 'table table-bordered table-striped mb-0']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script src="{{ asset('vendor/sweetalert/sweetalert.all.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script>
        $(document).on('click','.export-type',function(e){
            e.preventDefault();
            let form=$(this).parent().parent().find('form')
            form.find('[name="export_type"]').val($(this).attr('data-type'));
            form.submit();
        })
        function checkMultiDeleteButton(){
           if($(".job_title-checkbox").is(':checked')){
               $(".delete-selected").removeClass('disabled');
               $(".export-selected,.export-types").removeClass('disabled');
           }else{
               $(".delete-selected").addClass('disabled')
               $(".export-selected,.export-types").addClass('disabled')

           }
        }
        checkMultiDeleteButton();
        $(document).on('click','.delete-selected',function(){
            let IDS=[];
            $('.job_title-checkbox:checked').each(function(){
                IDS.push($(this).val());
            })
            Swal.fire({
                title: '{{ __('Do you really want to delete this?') }}',
                showCancelButton: true,
                confirmButtonText: '{{ __('Yes') }}',
                cancelButtonText: '{{ __('No') }}',
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('job_titles.multi_destroy') }}",
                        data:{IDS},
                        success: function (msg) {
                            window.LaravelDataTables["job_titles"].draw();
                            Swal.fire(msg.message, '', msg.success?'success':'error')
                            $(".delete-selected").addClass('disabled').find('.selectedCount').text(0)
                        }
                    });

                }
            })
        })
        function addSelectedCount(){
            $(".selectedCount").text($(".job_title-checkbox:checked").length)
            let IDS=[];
            $('.job_title-checkbox:checked').each(function(){
                IDS.push($(this).val());
            })
            $("#exportIDS").val(IDS);
        }
        $(document).on('change','#selectAllCheckbox',function(){
            $('table#job_titles tbody input[type="checkbox"].job_title-checkbox').prop('checked',$(this).is(':checked'))
            checkMultiDeleteButton();
            addSelectedCount()
        });
        $(document).on('change','.job_title-checkbox',function (){
            checkMultiDeleteButton();
            addSelectedCount()
        })
        @if(PerUser('job_titles.destroy'))
        $(document).on('click','.delete-selected',function(){

        });
        $(document).on('click','.delete-this',function(e){
            e.preventDefault()
            let el=$(this);
            let url=el.attr('data-url')
            let id=el.attr('data-id')
            Swal.fire({
                title: '{{ __('Do you really want to delete this?') }}',
                showCancelButton: true,
                confirmButtonText: '{{ __('Yes') }}',
                cancelButtonText: '{{ __('No') }}',
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: url,
                        success: function (msg) {
                            window.LaravelDataTables["job_titles"].draw();
                            Swal.fire(msg.message, '', msg.success?'success':'error')
                        }
                    });

                }
            })
        })
        @endif
    </script>
@endpush
