<?php

namespace App\Http\Controllers\Dashboard;

use App\DataTables\DepartmentsDataTable;
use App\Exports\DepartmentsExport;
use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use App\Models\Department;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class DepartmentsController extends Controller
{
    //
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DepartmentsDataTable $dataTable){
        return $dataTable->render('dashboard.departments.index');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //

        return view('dashboard.departments.create_edit');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validateDepartments($request);
        Department::create(array_merge($request->only(['title','status'],['created_by'=>auth()->id()])));
        alert()->success(__('Success'),__('Create Successfully'));
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Department $department)
    {
        //
        return view('dashboard.departments.create_edit',compact('department'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Department $department)
    {
        //
        $this->validateDepartments($request);
        $updateData=array_merge($request->only('title','status',['updated_by'=>auth()->id()]));
        $department->update($updateData);
        alert()->success(__('Success'),__('Update Successfully'));
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Department $department)
    {
        //
        $department->deleted_by=auth()->id();
        $department->save();
        $department->delete();
        return response()->json(['success'=>true,'message'=>__('Delete Successful')]);
    }

    public function validateDepartments($request){
        $valid=[

            'status'=>'required|in:'.implode(',',config('app.statusArray')),
        ];
        if($request->department){
//            $valid['email']='required|email|unique:departments,email,'.$request->department->id.',NULL,deleted_at,NULL';
            $valid['title']=['required',Rule::unique('departments','title')->whereNull('deleted_at')->ignore($request->department->id,'id')];
        }else{
           $valid['title']='required|unique:departments';
        }
        return $request->validate($valid);
    }
    public function deleteMulti(Request $request){
        $count=Department::whereIn('id',$request->IDS)->update(['deleted_by'=>auth()->id(),'deleted_at'=>now()]);
        return response()->json(['success'=>true,'message'=>__('Delete :count Successful',['count'=>$count])]);
    }
    public function export(Request $request){
        switch ($request->export_type){
            case'csv':
                return Excel::download(new DepartmentsExport,'departments_'.time().'.csv',\Maatwebsite\Excel\Excel::CSV);
                break;
            case'excel':
                return Excel::download(new DepartmentsExport,'departments_'.time().'.xlsx',\Maatwebsite\Excel\Excel::XLSX);
                break;
            case'pdf':
                $departments=Department::query();
                if(request('IDS')){
                    $departments=$departments->whereIn('id',explode(',',request('IDS')));
                }
                $departments=$departments->get();
                return Pdf::loadView('dashboard.departments.export_pdf',['departments'=>$departments])->download('departments_'.time().'.pdf');
                break;
        }

    }

}
