<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //actual > target
        Schema::create('users_kpis_questions', function (Blueprint $table) {
            $table->id();
            $table->integer('users_kpi_id')->default(0);
            $table->integer('kpi_id')->default(0);
            $table->integer('user_id')->default(0);
            $table->integer('kpi_question_id')->default(0);
            $table->string('kpi_question_question')->nullable();
            $table->integer('kpi_question_weight')->default(0);
            $table->string('employee_target')->nullable();
            $table->string('employee_actual')->nullable();
            $table->integer('employee_score')->default(0);
            $table->integer('updated_by')->default(0);
            $table->integer('created_by')->default(0);
            $table->integer('deleted_by')->default(0);
            $table->softDeletes();
            $table->timestamps();
            $table->index('id','id_index');
            $table->index('kpi_id','kpi_id_index');
            $table->index('user_id','users_id_index');
            $table->index('kpi_question_id','kpi_question_id_index');
            $table->index('users_kpi_id','users_kpi_id_index');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users_kpis_questions');
    }
};
