<?php

namespace Database\Seeders;

use App\Models\KPI;
use App\Models\User;
use App\Models\UsersKPI;
use App\Models\UsersKPISQuestion;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UsersKPISSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        for($x=0;$x<=50;$x++){
            $year=date('Y',strtotime('- '.$x.' months'));
            $month=date('m',strtotime('- '.$x.' months'));
            foreach (KPI::where('status','published')->has('KPISQuestions')->with('KPISQuestions')->get() as $kpi){
                foreach (User::where('id','!=',1)->where('job_title_id',$kpi->job_title_id)->pluck('id','job_title_id')->toArray() as $job_title_id=>$user_id){
                    $created_at=$year.'-'.$month.'-01 '.fake()->time();
                    $users_kpi=UsersKPI::create(array_merge(['user_id'=>$user_id,'year'=>$year,'month'=>$month,'kpi_id'=>$kpi->id,'created_by'=>1,'created_at'=>$created_at]));
                    $total_kpi_question_weight=0;
                    $total_employee_target=0;
                    $total_employee_actual=0;
                    foreach ($kpi->KPISQuestions as $question){
                        $target=1;
                        $actual=1;
                        $score=($actual/$target)*100;
                        $createdData=[
                            'users_kpi_id'=>$users_kpi->id,
                            'kpi_id'=>$kpi->id,
                            'user_id'=>$user_id,
                            'kpi_question_id'=>$question->id,
                            'kpi_question_question'=>$question->question,
                            'kpi_question_weight'=>$question->weight,
                            'employee_target'=>$target,
                            'employee_actual'=>$actual,
                            'employee_score'=>$score,
                            'created_by'=>1,
                            'created_at'=>$created_at,
                        ];

                        $total_employee_target+=$target;
                        $total_employee_actual+=$actual;
                        $total_kpi_question_weight+=$question->weight;
                        UsersKPISQuestion::create($createdData);
                    }
                    $total_employee_score=($total_employee_actual/$total_employee_target)*100;
                    $users_kpi->update([
                        'total_kpi_question_weight'=>$total_kpi_question_weight,
                        'total_employee_target'=>$total_employee_target,
                        'total_employee_actual'=>$total_employee_actual,
                        'total_employee_score'=>$total_employee_score,
                        'updated_by'=>1

                    ]);
                }
            }


//            foreach (User::where('id','!=',1)->pluck('id','job_title_id')->toArray() as $job_title_id=>$user_id){
//                $kpi=KPI::where('job_title_id',$job_title_id)->where('status','published')->has('KPISQuestions')->with('KPISQuestions')->first();
//                $users_kpi=UsersKPI::create(array_merge(['user_id'=>$user_id,'year'=>$year,'month'=>$month,'kpi_id'=>$kpi->id,'created_by'=>1]));
//                $total_kpi_question_weight=0;
//                $total_employee_target=0;
//                $total_employee_actual=0;
//                foreach ($kpi->KPISQuestions as $question){
//                    $target=1;
//                    $actual=1;
//                    $score=($actual/$target)*100;
//                    $createdData=[
//                        'users_kpi_id'=>$users_kpi->id,
//                        'kpi_id'=>$kpi->id,
//                        'user_id'=>$user_id,
//                        'kpi_question_id'=>$question->id,
//                        'kpi_question_question'=>$question->question,
//                        'kpi_question_weight'=>$question->weight,
//                        'employee_target'=>$target,
//                        'employee_actual'=>$actual,
//                        'employee_score'=>$score,
//                        'created_by'=>1
//                    ];
//
//                    $total_employee_target+=$target;
//                    $total_employee_actual+=$actual;
//                    $total_kpi_question_weight+=$question->weight;
//                    UsersKPISQuestion::create($createdData);
//                }
//                $total_employee_score=($total_employee_actual/$total_employee_target)*100;
//                $users_kpi->update([
//                    'total_kpi_question_weight'=>$total_kpi_question_weight,
//                    'total_employee_target'=>$total_employee_target,
//                    'total_employee_actual'=>$total_employee_actual,
//                    'total_employee_score'=>$total_employee_score,
//                    'updated_by'=>1
//                ]);
//            }
        }
    }
}
