<?php

namespace App\Http\Controllers\Dashboard;

use App\DataTables\UserKPISDataTable;
use App\DataTables\UserKPISReportDataTable;
use App\DataTables\UserKPISTotalReportDataTable;
use App\Exports\UserKPISExport;
use App\Http\Controllers\Controller;
use App\Models\KPI;
use App\Models\KPISQuestion;
use App\Models\User;
use App\Models\UsersKPISQuestion;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use App\Models\UsersKPI;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class UsersKPISController extends Controller
{
    //
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(UserKPISDataTable $dataTable){
        return $dataTable->render('dashboard.users_kpis.index');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        //
        if($request->ajax()){
            if($request->user_id&&$request->year_month){
                $user=User::find($request->user_id);
                if($user){
                    $kpi=KPI::where('job_title_id',$user->job_title_id)->where('status','published')->has('KPISQuestions')->with('KPISQuestions')->first();
                    if($kpi){
                        $year=null;
                        $month=null;
                        if(str_contains($request->year_month,'-')){
                            list($month,$year)=explode('-',$request->year_month);
                        }
                        if(!$year||!$month){
                            return response()->json(['success'=>false,'message'=>'Please select valid year & month']);
                        }
                        if(UsersKPI::where(['user_id'=>$user->id,'year'=>$year,'month'=>$month])->count()){
                            return response()->json(['success'=>false,'message'=>'There are Appraisal added before']);
                        }
                        $html=view('dashboard.users_kpis.show_questions',['questions'=>$kpi->KPISQuestions])->render();
                        return response()->json(['success'=>true,'html'=>$html]);
                    }
                    return response()->json(['success'=>false,'message'=>'No KPI Found']);
                }
                return response()->json(['success'=>false,'message'=>'No User Found']);
            }
            return response()->json(['success'=>false,'message'=>'Ops please try again with select user & year & month']);
        }

        return view('dashboard.users_kpis.create_edit');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $year=null;
        $month=null;
        if(str_contains($request->year_month,'-')){
            list($month,$year)=explode('-',$request->year_month);
        }

        //dd($request->input(),$year,$month);
        $request->merge([
            'year'=>$year,
            'month'=>$month,
        ]);
        $this->validateUserKPIS($request);
        $user=User::find($request->user_id);
        $kpi=KPI::where('job_title_id',$user->job_title_id)->where('status','published')->has('KPISQuestions')->with('KPISQuestions')->first();
        $users_kpi=UsersKPI::create(array_merge($request->only(['user_id','year','month']),['kpi_id'=>$kpi->id,'created_by'=>auth()->id()]));
        $total_kpi_question_weight=0;
        $total_employee_target=0;
        $total_employee_actual=0;
        foreach ($request->question as $question_id=>$items){
            $question=KPISQuestion::find($question_id);
            $target=$request->question[$question_id]['target'];
            $actual=$request->question[$question_id]['actual'];
            $score=($request->question[$question_id]['actual']/$request->question[$question_id]['target'])*100;
            $createdData=[
                'users_kpi_id'=>$users_kpi->id,
                'kpi_id'=>$kpi->id,
                'user_id'=>$user->id,
                'kpi_question_id'=>$question_id,
                'kpi_question_question'=>$question->question,
                'kpi_question_weight'=>$question->weight,
                'employee_target'=>$target,
                'employee_actual'=>$actual,
                'employee_score'=>$score,
                'created_by'=>auth()->id()
            ];

            $total_employee_target+=$target;
            $total_employee_actual+=$actual;
            $total_kpi_question_weight+=$question->weight;
            UsersKPISQuestion::create($createdData);
        }
        $total_employee_score=($total_employee_actual/$total_employee_target)*100;
        $users_kpi->update([
            'total_kpi_question_weight'=>$total_kpi_question_weight,
            'total_employee_target'=>$total_employee_target,
            'total_employee_actual'=>$total_employee_actual,
            'total_employee_score'=>$total_employee_score,
            'updated_by'=>auth()->id()
        ]);
        alert()->success(__('Success'),__('Create Successfully'));
        return redirect()->back();
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(UsersKPI $users_kpi)
    {
        //
        return view('dashboard.users_kpis.create_edit',compact('users_kpi'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, UsersKPI $users_kpi)
    {
        //
        $this->validateUserKPIS($request);
        if($request->weight){
            $total=0;
            foreach ($request->weight as $weight){
                $total+=$weight;
            }
            if($total!=100){
                alert()->error(__('Error'),__('Total Weight of questions must be 100%'));
                return redirect()->back()->withInput();
            }
        }
        //$user=User::find($request->user_id);
        $user=User::find($users_kpi->user_id);
        $kpi=KPI::where('job_title_id',$user->job_title_id)->where('status','published')->has('KPISQuestions')->with('KPISQuestions')->first();
        $total_kpi_question_weight=0;
        $total_employee_target=0;
        $total_employee_actual=0;
        //dd($request->input());
        $IDS=[];
        foreach ($request->question as $question_id=>$items){
            $question=KPISQuestion::find($question_id);
            $target=$request->question[$question_id]['target'];
            $actual=$request->question[$question_id]['actual'];
            $score=($request->question[$question_id]['actual']/$request->question[$question_id]['target'])*100;
            $array=[
                'users_kpi_id'=>$users_kpi->id,
                'kpi_id'=>$kpi->id,
                'user_id'=>$user->id,
                'kpi_question_id'=>$question_id,
            ];
            $createdData=[
                'kpi_question_question'=>$question->question,
                'kpi_question_weight'=>$question->weight,
                'employee_target'=>$target,
                'employee_actual'=>$actual,
                'employee_score'=>$score,
            ];
            if($usersKPISQuestion=UsersKPISQuestion::where($array)->first()){
                UsersKPISQuestion::where('id',$usersKPISQuestion->id)->update(array_merge($createdData,['updated_by'=>auth()->id()]));
            }else{
                $usersKPISQuestion=UsersKPISQuestion::create(array_merge($array,$createdData,[ 'created_by'=>auth()->id()]));
            }
            $total_employee_target+=$target;
            $total_employee_actual+=$actual;
            $total_kpi_question_weight+=$question->weight;
            $IDS[]=$usersKPISQuestion->id;
        }
        UsersKPISQuestion::where('users_kpi_id',$users_kpi->id)->whereNotIn('id',$IDS)->delete();
        $total_employee_score=($total_employee_actual/$total_employee_target)*100;
        $users_kpi->update([
            'total_kpi_question_weight'=>$total_kpi_question_weight,
            'total_employee_target'=>$total_employee_target,
            'total_employee_actual'=>$total_employee_actual,
            'total_employee_score'=>$total_employee_score,
            'updated_by'=>auth()->id(),
        ]);

        alert()->success(__('Success'),__('Update Successfully'));
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(UsersKPI $users_kpi)
    {
        //
        $users_kpi->deleted_by=auth()->id();
        $users_kpi->save();
        $users_kpi->delete();
        return response()->json(['success'=>true,'message'=>__('Delete Successful')]);
    }

    public function validateUserKPIS($request){
        $valid=[

        ];

        if(!$request->question){
            alert()->error(__('Error'),__('Please add questions'));
        }

        //dd($valid);
        if($request->users_kpi){
            if($request->users_kpi->user_id){
                $user=User::find($request->users_kpi->user_id);
                $kpi=KPI::where('job_title_id',$user->job_title_id)->where('status','published')->has('KPISQuestions')->with('KPISQuestions')->first();
                foreach ($kpi->KPISQuestions as $question){
                    $valid['question.'.$question->id.'.target']='required|gte:question.'.$question->id.'.actual';
                    $valid['question.'.$question->id.'.actual']='required|lte:question.'.$question->id.'.target';
                }
            }
//            $valid['year']=['required',Rule::unique('users_kpis','year')->where('month',$request->month)->where('user_id',$request->user_id)->whereNull('deleted_at')->ignore($request->user_kpi->id,'id')];
//            $valid['month']=['required',Rule::unique('users_kpis','month')->where('year',$request->year)->where('user_id',$request->user_id)->whereNull('deleted_at')->ignore($request->user_kpi->id,'id')];
//            $valid['user_id']=['required',Rule::unique('users_kpis','user_id')->where('month',$request->month)->where('year',$request->year)->whereNull('deleted_at')->ignore($request->user_kpi->id,'id')];
        }else{
            if($request->user_id){
                $user=User::find($request->user_id);
                $kpi=KPI::where('job_title_id',$user->job_title_id)->where('status','published')->has('KPISQuestions')->with('KPISQuestions')->first();
                foreach ($kpi->KPISQuestions as $question){
                    $valid['question.'.$question->id.'.target']='required|gte:question.'.$question->id.'.actual';
                    $valid['question.'.$question->id.'.actual']='required|lte:question.'.$question->id.'.target';
                }
            }
           $valid['year']=['required',Rule::unique('users_kpis','year')->where('month',$request->month)->where('user_id',$request->user_id)->whereNull('deleted_at')];
           $valid['month']=['required',Rule::unique('users_kpis','month')->where('year',$request->year)->where('user_id',$request->user_id)->whereNull('deleted_at')];


            if (!PerUser('users_kpis.show_all')){
                $userIDS=\App\Models\User::whereIn('job_title_id',\App\Models\KPI::where('status','published')->has('KPISQuestions')->pluck('job_title_id')->toArray())->where(function ($q){$q->where('path','LIKE','%:'.auth()->id().'::%')->where('id','!=',auth()->id());})->pluck('id')->toArray();
                $valid['user_id']=['required',Rule::unique('users_kpis','user_id')->where('month',$request->month)->where('year',$request->year)->whereNull('deleted_at'),'in:'.implode(',',$userIDS)];
            }else{
                $valid['user_id']=['required',Rule::unique('users_kpis','user_id')->where('month',$request->month)->where('year',$request->year)->whereNull('deleted_at')];
            }
        }
        return $request->validate($valid);
    }
    public function deleteMulti(Request $request){
        $count=UsersKPI::whereIn('id',$request->IDS)->update(['deleted_by'=>auth()->id(),'deleted_at'=>now()]);
        return response()->json(['success'=>true,'message'=>__('Delete :count Successful',['count'=>$count])]);
    }
    public function export(Request $request){
        switch ($request->export_type){
            case'csv':
                return Excel::download(new UserKPISExport,'users_kpis_'.time().'.csv',\Maatwebsite\Excel\Excel::CSV);
                break;
            case'excel':
                return Excel::download(new UserKPISExport,'users_kpis_'.time().'.xlsx',\Maatwebsite\Excel\Excel::XLSX);
                break;
            case'pdf':
                $users_kpis=UsersKPI::query();
                if(request('IDS')){
                    $users_kpis=$users_kpis->whereIn('id',explode(',',request('IDS')));
                }
                $users_kpis=$users_kpis->get();
                return Pdf::loadView('dashboard.users_kpis.export_pdf',['users_kpis'=>$users_kpis])->download('users_kpis_'.time().'.pdf');
                break;
        }

    }
    public function report(UserKPISReportDataTable $dataTable){
        return $dataTable->render('dashboard.users_kpis.report');
    }
    public function totalReport(UserKPISTotalReportDataTable $dataTable){
        return $dataTable->render('dashboard.users_kpis.total_report');
    }

}
